#include<stdio.h>
#include<process.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>

int matchp(char *str)
	{
	char *cp;
	for(cp=str;(*cp)!='.';cp++)
		if(!*cp)
			return(0);
	if(((cp[1]=='v')||(cp[1]=='V'))&&((cp[2]=='c')||(cp[2]=='C'))&&((cp[3]=='e')||(cp[3]=='E'))&&!cp[4])
		return(1);
	return(0);
	}

unsigned char buf[4096];

main(int argc, char **argv)
	{
	char fnstr[16];
	FILE *lfd;
	int n, cpifd, cpofd, retval;
	if(argc<2)
		{
		printf("\nUSAGE swaplist <listfile>\n\n");
		printf("Listfile has lines that are filenames, like ZIPLIST\n");
		printf("All .VCE files will be byte-swapped.\n");
		exit(1);
		}
	if((lfd=fopen(argv[1], "r"))==NULL)
		{
		printf("Error opening listfile %s.\n", argv[1]);
		exit(2);
		}
	retval=0;
	while(1)
		{
		if(fgets(fnstr, 79, lfd)==NULL)
			exit(0);
		if(fnstr[strlen(fnstr)-1]=='\n')
			fnstr[strlen(fnstr)-1]='\0';
		printf("%s: ", fnstr);
		if(!matchp(fnstr))
			{
			printf("Irrelevant.\n");
			continue;
			}
		if(spawnlp(P_WAIT, "byteswap.exe", "byteswap", fnstr, "bstmp.vce", NULL))
			{
			retval=1;
			printf(" ERROR in swap spawn return\n");
			}
		else
			{
			if((cpifd=open("bstmp.vce", O_RDONLY|O_BINARY))==-1)
				{
				retval=1;
				printf(" ERROR in copy source open.\n");
				}
			else if((cpofd=open(fnstr, O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
				{
				retval=1;
				printf(" ERROR in copy target open.\n");
				}
			else
				{
				while(1)
					{
					if((n=read(cpifd, buf, 4096))<=0)
						{
						printf(" OK\n");
						break;
						}
					if(write(cpofd, buf, n)!=n)
						{
						retval=1;
						printf(" ERROR in copy write.\n");
						break;
						}
					if(n<4096)
						{
						printf(" OK\n");
						break;
						}
					}
				close(cpifd);
				close(cpofd);
				}
			}
		}
	if(retval)
		printf("There was at least one error in this process.\n");
	exit(retval);
	}