$INCLUDE: 'C:\FG\INTRFACE.FOR'

      PROGRAM MAIN

      INTEGER*2 VISUAL, HIDDEN
      PARAMETER (VISUAL=0)
      PARAMETER (HIDDEN=1)

      INTEGER*2 NEW_MODE, OLD_MODE
      INTEGER*2 FRAME, OFFSET
      INTEGER*2 I
      INTEGER*2 STATUS
      INTEGER*2 FG_ALLOCATE, FG_FREEPAGE
      INTEGER*2 FG_BESTMODE, FG_GETMODE

C  initialize the video environment

      NEW_MODE = FG_BESTMODE(320,200,2)
      IF (NEW_MODE .LT. 0 .OR. NEW_MODE .EQ. 12) THEN
         STOP 'This program requires a 320 x 200 color graphics mode.'
      END IF
      OLD_MODE = FG_GETMODE()
      CALL FG_SETMODE(NEW_MODE)
      STATUS = FG_ALLOCATE(HIDDEN)

C  draw the background in the upper left corner

      CALL FG_SETPAGE(HIDDEN)
      CALL FG_SETCOLOR(1)
      CALL FG_RECT(0,95,0,49)
      CALL FG_SETCOLOR(15)
      CALL FG_MOVE(48,25)
      CALL FG_ELLIPSE(20,20)

C  copy it to the center of the visual page

      CALL FG_TRANSFER(0,95,0,49,112,124,HIDDEN,VISUAL)

C  slide the object across the background three times

      CALL FG_SETCOLOR(10)
      DO 10 I = 0,35
         FRAME  = MOD(I,12)
         OFFSET = 10 * FRAME - 10
         CALL FG_TRANSFER(0,95,20,29,112,105,HIDDEN,HIDDEN)
         CALL FG_RECT(112+OFFSET,131+OFFSET,96,105)
         CALL FG_TRANSFER(112,207,96,105,112,105,HIDDEN,VISUAL)
         CALL FG_WAITFOR(2)
10    CONTINUE

C  restore the original video mode and return to DOS

      STATUS = FG_FREEPAGE(HIDDEN)
      CALL FG_SETMODE(OLD_MODE)
      CALL FG_RESET

      STOP ' '
      END
