#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Common makefile targets used by all SciTech Software
#               makefiles. This file includes targets for cleaning the
#               current directory, and maintaining the source files with
#               RCS.
#
# $Id: COMMON.MK 1.1 1994/08/22 11:08:20 kjb Exp $
#
#############################################################################

# Target to build the library file if specified

.IF $(LIBFILE)

lib: $(LIBFILE)

$(LIBFILE): $(OBJECTS)

# Install the library files

install: $(LIBFILE)
    $(INSTALL) $(LIBFILE) $(LIB_DEST)

.END

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

INC :=  $(SCITECH)\INCLUDE

# Clean up directory removing all files not needed to make the library

clean:
    -rm -f *.obj *.o *.sym *.bak *.tdk *.swp *.map *.err *.csm *.pch
.IF $(LIBFILE)
    -rm -f $(LIBFILE)
.END

cleanexe:   clean
.IF $(UNIX)
    -rm -f $(EXEFILES)
.ELSE
    -rm -f *$E *.drv
.ENDIF

realclean:  cleanexe
.IF $(LIBFILE)
    -rm -f $(LIB_DEST)\$(LIBFILE)
.END

.IF $(LOCALRCS) == $(NULL)

# RCS Maintenance routines. Assumes the existence of the RCSFILES list
# to determine the files to apply the RCS commands to, and that the
# foreach.exe program is available on the path. For all files in the
# RCSFILES_H list we either copy the files from the standard include
# directory in order to check them in, or copy the checked out files back
# into the standard include directory (the -cf and -ct options of foreach).

stamp:
    @foreach "rcs -N$(VERSION): -srelease" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach "rcs -N$(VERSION): -srelease" $(mktmp $(RCSFILES_H:t" \n")\n)

rcsit:
    @foreach "rcs $(RCSOPT)" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach "rcs $(RCSOPT)" $(mktmp $(RCSFILES_H:t" \n")\n)

# Remove unchanged source files (public header files are not removed)

rcsclean:
    @foreach rcsclean $(mktmp $(RCSFILES:t" \n")\n)
    @foreach -cl $(INC) rcsclean $(mktmp $(RCSFILES_H:t" \n")\n)

# Check in the latest revisions of source files with RCS

ci:
    @foreach "ci -q -u -mnone $(RCSOPT)" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach -cf $(INC) "ci -q -u -mnone $(RCSOPT)" $(mktmp $(RCSFILES_H:t" \n")\n)

# Check out the latest revisions of source files from RCS

co:
    @foreach "co -q $(RCSOPT)" $(mktmp $(RCSFILES:t" \n")\n)
    @foreach -ct $(INC) "co -q $(RCSOPT)" $(mktmp $(RCSFILES_H:t" \n")\n)

.ENDIF

