#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Watcom C++ 10.0 16 bit version.
#
# $Id: WC16.MK 1.1 1994/08/22 11:08:20 kjb Exp $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT SHW BETA

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := wcl      # C-compiler and flags
   CFLAGS       += -ml -zq -w2 -s -fh
   COMPILE_ONLY := -c       # Only compile the C source, dont link
   AS           := tasm     # Assembler and flags
   ASFLAGS      += /MX /m /D__LARGE__ /i$(SCITECH)\INCLUDE
   LD           := wlink    # Loader and flags
   LDFLAGS      +=
   LIB          := wlib     # Librarian
   LIBFLAGS     += -q

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -d2      # Turn on debugging for C compiler
   LIBFLAGS     += -p=128   # Larger page size for libraries with debug info!
   ASFLAGS      += /ZI      # Turn on debugging for assembler
   LDFLAGS      += D A      # Turn on debugging for linker
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -oneatx
.END

# Optionally turn on direct i387 FPU instructions

.IF $(FPU)
   CFLAGS       += -fpi87 -fp3
   ASFLAGS      += -DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# Use a larger stack during linking if requested

.IF $(STKSIZE)
    LDFLAGS     += OP STACK=$(STKSIZE)
.ENDIF

# Define where to install library files
   LIB_DEST     := $(SCITECH)\$(LIB_DIR)\WC16

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; $(CC) $(CFLAGS) -c $<
   %$O: %$P ; $(CC) $(CFLAGS) -c $<
   %$O: %$A ; $(AS) $(ASFLAGS) $(<:s,/,\);

# Implicit rule for building a library file using response file
   %$L: ; $(LIB) $(LIBFLAGS) $@ @$(mktmp,$*.rsp -+$(?:t"\n-+")\n)

# Implicit rule for building an executable file using response file
   %$E: ;
@[
    @trimlib $(mktmp OP quiet\nN $@\nF $(&:t",")\nLIBR $(EXELIBS:t",")) $*.lnk
    $(LD) $(LDFLAGS) @$*.lnk
    @rm $*.lnk
]

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

