;****************************************************************************
;*
;*						  	  PM/Lite Library
;*
;*                  Copyright (C) 1994 SciTech Software
;*							All rights reserved.
;*
;* Filename:    $RCSfile: _pmlite.asm $
;* Version:     $Revision: 1.1 $
;*
;* Language:	80386 Assembler
;* Environment:	IBM PC Real mode and 16/32 bit protected mode
;*
;* Description:	Low level assembly support.
;*
;* $Id: _pmlite.asm 1.1 1994/08/22 07:46:53 kjb release $
;*
;****************************************************************************

		IDEAL

INCLUDE "model.mac"				; Memory model macros

header      _pmode              ; Set up memory model

begcodeseg  _pmode              ; Start of code segment

ifndef	DPMI16
ifndef	WINDPMI16
ife 	flatmodel

struc   rmregs_s
ax      dw	?
bx		dw	?
cx		dw	?
dx		dw	?
si		dw	?
di		dw	?
ends	rmregs_s
RMREGS	= (rmregs_s PTR es:bx)

struc	rmsregs_s
es		dw	?
cs		dw	?
ss		dw	?
ds		dw	?
ends	rmsregs_s
RMSREGS	= (rmsregs_s PTR es:bx)

;----------------------------------------------------------------------------
; void PM_callRealMode(unsigned s,unsigned o, RMREGS *regs,
;	RMSREGS *sregs)
;----------------------------------------------------------------------------
; Calls a real mode procedure, loading the appropriate registers values
; from the passed in structures. Only the DS and ES register are loaded
; from the SREGS structure.
;----------------------------------------------------------------------------
procstart	_PM_callRealMode

		ARG     s:WORD, o:WORD, regs:DWORD, sregs:DWORD

		LOCAL	addr:DWORD, bxVal:WORD, esVal:WORD = LocalSize

		enter_c	LocalSize
		push	ds
		push	es

		mov		ax,[o]			; Build the address to call in 'addr'
		mov		[WORD addr],ax
		mov		ax,[s]
		mov		[WORD addr+2],ax

		les		bx,[sregs]
		mov     ax,[RMSREGS.ds]
		mov     ds,ax			; DS := passed in value
		mov		ax,[RMSREGS.es]
		mov		[esVal],ax
		les		bx,[regs]
		mov		ax,[RMREGS.bx]
		mov		[bxVal],ax
		mov		ax,[RMREGS.ax]	; AX := passed in value
		mov		cx,[RMREGS.cx]	; CX := passed in value
		mov		dx,[RMREGS.dx]	; DX := passed in value
		mov		si,[RMREGS.si] 	; SI := passed in value
		mov		di,[RMREGS.di]	; DI := passed in value
		push	bp
		push	[esVal]
		pop		es				; ES := passed in value
		mov		bx,[bxVal]		; BX := passed in value

		call	[addr]			; Call the specified routine

		pop		bp
		push	es
		pop		[esVal]
		push	bx
		pop		[bxVal]
		les		bx,[sregs]
		push	ds
		pop		[RMSREGS.ds]	; Save value of DS
		push	[esVal]
		pop		[RMSREGS.es]	; Save value of ES
		les		bx,[regs]
		mov		[RMREGS.ax],ax	; Save value of AX
		mov		[RMREGS.cx],cx	; Save value of CX
		mov		[RMREGS.dx],dx	; Save value of DX
		mov		[RMREGS.si],si	; Save value of SI
		mov		[RMREGS.di],di	; Save value of DI
		mov		ax,[bxVal]
		mov     [RMREGS.bx],ax	; Save value of BX

		pop		es
		pop		ds
		leave_c
		ret

procend		_PM_callRealMode

endif
endif
endif

if flatmodel

;----------------------------------------------------------------------------
; unsigned char PM_getByte(unsigned s, unsigned o)
;----------------------------------------------------------------------------
procstart	_PM_getByte

		ARG		s:UINT, o:UINT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     eax,[o]
		mov		al,[eax]

		pop		ds
		pop		ebp
		ret

procend		_PM_getByte

;----------------------------------------------------------------------------
; unsigned short PM_getWord(unsigned s, unsigned o)
;----------------------------------------------------------------------------
procstart	_PM_getWord

		ARG		s:UINT, o:UINT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     eax,[o]
		mov		ax,[eax]

		pop		ds
		pop		ebp
		ret

procend		_PM_getWord

;----------------------------------------------------------------------------
; unsigned long PM_getLong(unsigned s, unsigned o)
;----------------------------------------------------------------------------
procstart	_PM_getLong

		ARG		s:UINT, o:UINT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     eax,[o]
		mov		eax,[eax]

		pop		ds
		pop		ebp
		ret

procend		_PM_getLong

;----------------------------------------------------------------------------
; void PM_setByte(unsigned s, unsigned o,unsigned char v)
;----------------------------------------------------------------------------
procstart	_PM_setByte

		ARG		s:UINT, o:UINT, v:UCHAR

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     edx,[o]
		mov		al,[v]
		mov		[edx],al

		pop		ds
		pop		ebp
		ret

procend		_PM_setByte

;----------------------------------------------------------------------------
; void PM_setWord(unsigned s, unsigned o,unsigned short v)
;----------------------------------------------------------------------------
procstart	_PM_setWord

		ARG		s:UINT, o:UINT, v:USHORT

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     edx,[o]
		mov		ax,[v]
		mov		[edx],ax

		pop		ds
		pop		ebp
		ret

procend		_PM_setWord

;----------------------------------------------------------------------------
; void PM_setLong(unsigned s, unsigned o,unsigned long v)
;----------------------------------------------------------------------------
procstart	_PM_setLong

		ARG		s:UINT, o:UINT, v:ULONG

		push	ebp
		mov		ebp,esp
		push    ds

		mov		ax,[WORD s]
		mov		ds,ax
		mov     edx,[o]
		mov		eax,[v]
		mov		[edx],eax

		pop		ds
		pop		ebp
		ret

procend		_PM_setLong

;----------------------------------------------------------------------------
; void PM_memcpynf(void *dst,unsigned src_s,unsigned src_o,unsigned n)
;----------------------------------------------------------------------------
; Copies a block of memory from a far memory block to a near memory block.
;----------------------------------------------------------------------------
procstart	_PM_memcpynf

		ARG		dst:DPTR, src_s:UINT, src_o:UINT, n:UINT

		enter_c	0
		push	ds

		mov		ax,[WORD src_s]
		mov     ds,ax
		mov		esi,[src_o]		; DS:ESI -> source memory block
		mov		edi,[dst]		; ES:EDI -> destination memory block
		mov		ecx,[n]

		shr		ecx,1
	rep	movsw
		adc		ecx,ecx
	rep	movsb

		pop		ds
		leave_c
		ret

procend		_PM_memcpynf

;----------------------------------------------------------------------------
; void PM_memcpyfn(unsigned dst_s,unsigned dst_o,void *src,unsigned n)
;----------------------------------------------------------------------------
; Copies a block of memory from a near memory block to a far memory block.
;----------------------------------------------------------------------------
procstart	_PM_memcpyfn

		ARG		dst_s:UINT, dst_o:UINT, src:DPTR, n:UINT

		enter_c	0
		push	es

		mov		esi,[src]		; DS:ESI -> source memory block
		mov		ax,[WORD dst_s]
		mov     es,ax
		mov		edi,[dst_o]		; ES:EDI -> source memory block
		mov		ecx,[n]

		shr		ecx,1
	rep	movsw
		adc		ecx,ecx
	rep	movsb

		pop		es
		leave_c
		ret

procend		_PM_memcpyfn

;----------------------------------------------------------------------------
; unsigned _PL_allocsel(void)
;----------------------------------------------------------------------------
; Allocate am empty segment selector with Phar Lap (there is no C based
; API for doing this in a compiler portable manner).
;----------------------------------------------------------------------------
procstart	__PL_allocsel

		mov		ah,48h			; Allocate memory service
		xor		ebx,ebx			; EBX := 0 pages to allocate
		int		21h
		jc		@@Fail
		and		eax,0FFFFh		; EAX := segment selector
		ret

@@Fail: xor		eax,eax
		ret

procend		__PL_allocsel

endif

endcodeseg  _pmode

		END						; End of module
