' $linesize:132
' $title: 'RBBS-SUB6.BAS 17.5, Copyright 1986-94 by D. Thomas Mack'
'  Copyright 1990 by D. Thomas Mack, all rights reserved.
'  Name ...............: RBBSSUB6.BAS
'  First Released .....: June 21, 1992
'  Subsequent Releases.:
'  Copyright ..........: 1986-1994
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'     RBBS-PC.BAS utilizes a lot of common subroutines.  Those that do not
'     require error trapping are incorporated within RBBSSUB 2-7 as
'     separately callable subroutines in order to free up as much
'     code as possible within the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine        Line     Function of Subroutine
'   Name            Number
' ----------        ------   ----------------------
'  EchoSet           42849   Allow user to set echo pref
'  FixMessageHdr     23100   Fix message header
'  GetLC             65030   Retrieve Last User on RBBS
'  GetMessageHdr     23000   Get message header
'  InitWelc           1761   Display Initial Welcome
'  JoinConference     5300   Join a conference
'  MsgSys             1797   Message System
'  PersInfo           5111   Change Personal Info
'  QuestAns           1401   Answer questionaire
'  ReadColorDef      65045   Retrieve External colors for RBBS
'  ShowUsrProfile    65002   Display users profile
'  Statistics        65000   Display users Statistics
'  UpdtMessageHdr    24000   Update message header
'  UserMaint         11000   SysOp User Maintenance
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
1401  '$SUBTITLE: 'QuestAns -- subroutine to answer questionaire'
' $PAGE
'
' NAME: QuestAns
'
' PURPOSE: To allow user to answer questionaire.
'
' INPUTS : WhatQues     ACTION TO PERFORM
'          WasX
'
' OUTPUTS: NONE
'
     SUB QuestAns (WhatQues, WasX)
     ON WhatQues GOSUB 1402,1408
     EXIT SUB
1402 WasA1$ = ZAnsMenu$
     CALL Talk (13,ZOutTxt$)
     ReturnToPrompt = (ZWasQ > 1)
1405 ZStackC = ZTrue
     CALL SubMenu ("Which questionnaire(s), L)ist" + ZPressEnterExpert$, _
        WasA1$,ZQuesPath$,".DEF","",ZTrue,ZFalse,ZTrue,"",WasX,ZTrue)
     IF ZWasQ = 0 THEN _
        RETURN
     IF ZSubParm = -1 THEN _
        RETURN
     QuestHold$ = ZWasZ$
     GOSUB 1408
     CLOSE 2
     CALL UpdtCalr (QuestHold$ + " questionnaire " + _
        MID$("answeredaborted",1 - 8 * ZQuestAborted,8),2)
     IF ReturnToPrompt THEN _
        RETURN
     GOTO 1405
1408 CALL AskUsers
     IF NOT ZOK THEN _
        RETURN
     IF ZAdjustedSecurity THEN
        ZSubParm = 6
        GOSUB 1410
        FIELD 5,128 AS ZUserRecord$
        LSET ZSecLevel$ = MKI$(ZUserSecLevel)
        IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN
           PUT 5,ZUserFileIndex
        END IF
        ZSubParm = 8
        GOSUB 1410
        CALL SetPrompt
        CALL XferType (2,ZTrue)
        CALL SetPrivileges
        ZErrCode = 0
     END IF
     REDIM ZOutTxt$(ZMsgDim)
     IF ZSubParm = -1 THEN _
        RETURN
     ZOK = ZTrue
     RETURN
1410 CALL FileLock
     RETURN
     END SUB
'
1761  '$SUBTITLE: 'InitWelc -- subroutine to display Initial Welcome'
' $PAGE
'
' NAME: InitWelc
'
' PURPOSE: To display initial welcome.  Formerly in RBBS-PC.BAS
'
' INPUTS :   DoFile        1 = Show PreLog & Welcome
'                          2 = Show file ZFileName$
'
' OUTPUTS:   None
'
'
'
      SUB InitWelc (DoFile)
      ON DoFile GOSUB 1762,1790
      EXIT SUB
1762  ZFileName$ = ZPreLog$
      GOSUB 1790
      CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
      ZFileName$ = ZWelcomeFile$
      GOSUB 1790
      RETURN
1790  CALL Graphic (ZFileName$,ZTrue)
      CALL BufFile (ZFileName$,WasX,ZFalse)
      CALL Carrier
      IF ZSubParm = -1 THEN _
         EXIT SUB
      RETURN
      END SUB
'
1797 '$SUBTITLE: 'MsgSys -- Message System routines'
' $PAGE
'
' NAME   : MsgSys
'
' PURPOSE: Messaging system.  Formerly in RBBS-PC.BAS.
'
' INPUTS : MParm       -  1  - New User welcome message
'                      -  2  - Comment to SysOp
'                      -  3  - Enter a message
'                      -  4  - Kill a message
'                      -  5  - Personal mail (look for)
'                      -  6  - Read messages
'                      -  7  - Scan message headers
'                      -  8  - Topic msg scan
'                      -  9  - 2350
'                      - 10  - Forgotten Password
'                      - 11  - Mail Check at logon
'                      - 12  - Extended file description
'                      - 13  - Margin change
'                      - 14  - Return from User Editing
'                      - 15  - Load Msgs for Statistics Scan
'
'
' OUTPUTS:   MParm     -  1  - Return from Logoff Comment
'                      -  2  - RETURN 10595
'                      -  3  - GOTO 5160
'                      -  4  - RETURN 13600
'                      -  5  - RETURN 1235
'                      -  6  - RETURN 1205
'                      -  7  - Dropped Carrier
'                      -  8  - GOTO 13000
'                      -  9  - Sleep Disconnect
'                      - 10  - Dropped Carrier
'                      - 11  - GOTO 10620
'                      - 12  - Time Limit Exceeded
'
'            ZJParm    -  3  - RETURN 108
'
'
     SUB MsgSys (MParm,ActionFlag,GetOut,LogonMailNew,UtilMarginChange,MsgSec,UserCanReadMsg) STATIC
     REDIM PRESERVE ZUserIn$(ZMsgDim)
     UserCanReadMsg = ZFalse
     StatsCheck = (MParm = 15)
     Temp = MParm
     MParm = 0
     ON Temp GOSUB 1799,1800,2000,3900,1900,4330,4340,4320,2350,1798,1895,2008,3100,4560,1900
     EXIT SUB
'
' ***  C - COMMAND FROM MAIN MENU (LEAVE COMMENT FOR SYSOP)   **
'

1798 OrigSubject$ = "FORGOTTEN PASSWORD"
     GOTO 1801
1799 '
1800 IF ZNetConference THEN
        CALL SkipLine (1)
        ZOutTxt$ = ZFG9$ + "Cannot leave a comment to SysOp" + _
                " in Networked message base!" + ZEmphasizeOff$
        CALL QuickTPut1 (ZOutTxt$)
        IF GetOut THEN _
           ZMParm = 1
        RETURN
     END IF
     OrigSubject$ = "COMMENT"
1801 MsgTo$ = "SYSOP"
     Subject$ = OrigSubject$
     MsgFrom$ = ZActiveUserName$
     GOSUB 1893
     IF (ZActiveMessages >= ZMaxMsgs OR _
        ((NOT ZMsgsCanGrow) AND _
        (ZNextMsgRec + 5 > ZHighestMsgRecord)) OR _
        NOT ZCmntsAsMsgs ) THEN _
        ZOutTxt$ = "Want a Reply?  Use "+MID$(ZAllOpts$,5,1) + _
                           " instead.  Leave a comment (Y,[N])" : _
        GOSUB 4875 : _
        IF NOT ZYes THEN _
           CALL SkipLine (1) : _
           RETURN _
        ELSE ZSysopComment = ZTrue : _
             GOTO 2007
     ZSysopComment = ZFalse
     ZSysopMsg = ZTrue
     ZMsgHeader$ = "comment"
     GOTO 2010
1850 WasBX = &H3
     ZWasEN$ = ZCmntsFile$
     GOSUB 4845
     CALL OpenWork (2,ZCmntsFile$,ZTrue)
     ZOutTxt$ = ZFGF$ + ZFirstName$ + ZFG9$ + _
          ", Thanks for the comments!" + ZEmphasizeOff$
     GOSUB 4800
     CALL AMorPM
     CALL PrintWork (2,ZActiveUserName$+" "+ZCurDate$+" "+ZTime$+" Node "+ZNodeID$,ZFalse)
     FOR WasX = 1 TO ZLinesInMsg
        CALL PrintWork (2,ZOutTxt$(WasX),ZFalse)
     NEXT
     CALL PrintWork (2,ZCarriageReturn$,ZFalse)
     CLOSE 2
     IF ZErrCode <> 0 THEN _
        ZWasEL = 1850 : _
        MParm = 8 : _
        RETURN
     WasBX = &H3
     ZWasEN$ = ZCmntsFile$
     GOSUB 4850
     CALL UpdtCalr ("Left comment",1)
     REDIM ZOutTxt$(ZMsgDim)
     RETURN
'
' ****  P - COMMAND FROM MAIN MENU (DISPLAY PERSONAL MAIL)  ****
'
1893 ActionFlag = ZTrue
     GOTO 1897
1895 IF ZTurboLogon OR ZNonStop THEN _
        RETURN
     IF ZDoMailCheck THEN _
        GOTO 1896
     ZOutTxt$ = ZFG1$ + "Check mail in " + ZFGF$ + ZConfName$ + _
                ZFG1$ + " ([Y]" + ZFG1$ + ",N)" + ZEmphasizeOff$
     GOSUB 4785               ' call popcmdstack
     IF ZNo THEN _
        SkipMain = ZTrue : _
        RETURN
1896 ZUserIn$(0) = LEFT$("NEW ",-4*LogonMailNew)
1897 IF ZActiveMessageFile$ = ZPrevBase$ AND ZTurboBase THEN _
        ActionFlag = ZFalse : _
        RETURN
1900 GOSUB 4700               ' Open Msg Base
     IF ZJParm = 3 THEN _
        RETURN
     IF ZPrivateDoor THEN _
        ActionFlag = ZTrue
     ZPrevBase$ = ZActiveMessageFile$
     ZTurboBase = ZTrue
     ShowActive = ZFalse
     ClearTwirly = ZFalse
     IF NOT ActionFlag THEN _
        CALL QuickTPut (ZFG4$ + "Checking messages in " + ZFGB$ + ZConfFileName$,0) : _
        ShowActive = ZTrue _
     ELSE CALL QuickTPut (ZFG4$ + "Loading messages",0)
     WasA1$ = ""
     MsgCt = 0
     MsgsFromUser = ZFalse
     ZActiveMessages = 0
     MailReported = ActionFlag
     FirstOld = ZTrue
     CALL GetMessageHdr
     MsgRec = ZFirstMsgRecord
     ZMaxMsgs = VAL(MID$(ZMsgRec$,89,7))
     NumDots = 0
1905 GET 1,MsgRec
     CALL CheckInt (MID$(ZMsgRec$,117,4))
     IF ZErrCode <> 0 THEN _
        ZWasEL = 1905 : _
        MParm = 8 : _
        RETURN
     NumRecsInMsg = VAL(MID$(ZMsgRec$,117,4))
     IF NumRecsInMsg < 1 THEN _
        NumRecsInMsg = 1
1906 IF ActionFlag OR (FirstOld AND NOT MailReported) THEN _
        CALL MarkTime (NumDots)
     CALL Carrier
     IF ZSubParm = -1 THEN _
        MParm = 2 : _
        RETURN
1910 IF MsgRec >= ZNextMsgRec THEN _
        LowMsgNumber = ZMsgPtr(1,2) : _
        GOTO 1950
1915 GOSUB 4660
     IF MID$(ZMsgRec$,116,1) <> ZActiveMessage$ THEN _
        GOTO 1946
     WasX$ = MID$(ZMsgRec$,121,2)
     IF WasX$ <> "  " THEN
        IF CVI(WasX$) > ZUserSecLevel THEN
           GOTO 1945
        ELSE
           IF VAL(LEFT$(ZMsgRec$,5)) > ZLastMsgRead THEN _
              IF (LEFT$(ZMsgRec$,1) = "*" AND UserInHeader) OR LEFT$(ZMsgRec$,1) = " " THEN _
                 UserCanReadMsg = ZTrue
        END IF
     END IF
     IF ActionFlag THEN _
        GOTO 1935
'
' ** ALLOW USERS WITH NAMES LONGER THAN 22 CHARS TO RECEIVE PRIVATE MAIL *
'
1920 IF NOT UserInHeader THEN _
        GOTO 1945
     IF MsgToCaller THEN _
        GOTO 1925
     GOTO 1940
1925 ZWasA = VAL(MID$(ZMsgRec$,2,4))
     IF LogonMailNew THEN _
        IF ZWasA <= ZLastMsgRead THEN _
           GOTO 1935
     IF NOT ShowActive THEN _
        GOTO 1930
     MailReported = ZTrue
     FirstNew = (ZWasA > ZLastMsgRead)
     IF NOT ClearTwirly THEN _
        CALL QuickTPut(ZBackSpace$ + " " + ZBackSpace$,0)
     ClearTwirly = ZTrue
     IF FirstNew THEN _
        MsgCt = 0 : _
        CALL SkipLine (1) : _
        CALL QuickTPut1 (ZEmphasizeOn$ + "New mail for you (* = Private)" + ZEmphasizeOff$) _
     ELSE IF FirstOld THEN _
             CALL SkipLine (1) : _
             CALL QuickTPut1 (ZFG4$ + "Old mail for you (* = Private)" + ZEmphasizeOff$) : _
             FirstOld = ZFalse
     ShowActive = NOT FirstNew
1930 CALL QuickTPut (LEFT$(ZMsgRec$,5),0)
     MsgCt = MsgCt + 1
     IF MsgCt MOD 15 = 0 THEN _
        CALL SkipLine (1) : _
        CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
1935 IF NOT MsgFromCaller THEN _
        GOTO 1945
1940 MsgsFromUser = MsgsFromUser + 1
     WasA1$ = WasA1$ + LEFT$(ZMsgRec$,5)
1945 ZActiveMessages = ZActiveMessages + 1
     ZMsgPtr(ZActiveMessages,1) = MsgRec
     ZMsgPtr(ZActiveMessages,2) = VAL(MID$(ZMsgRec$,2,4))
1946 MsgRec = MsgRec + NumRecsInMsg
     GOTO 1905
1950 IF NOT ClearTwirly THEN _
        CALL QuickTPut(ZBackSpace$ + " " + ZBackSpace$,0)
     IF NOT MailReported THEN _
        ZOutTxt$ = ZFGE$ + "Sorry, " + ZFGF$ + _
             ZFirstName$ + ZFGE$ + _
             ", No " + ZUserIn$(0) + "mail for you" + ZEmphasizeOff$ : _
        GOSUB 4795                ' tput routine
     IF MsgsFromUser = 0 OR NOT ZMsgReminder OR ActionFlag THEN _
        GOTO 1961
     ZOutTxt$ = ZFG4$ + "Mail you left" + ZEmphasizeOff$
     GOSUB 4800
1960 WasK = 1
     FOR MsgCt = 1 TO MsgsFromUser
        ZOutTxt$ = MID$(WasA1$,WasK,5)
        WasK = WasK + 5
        GOSUB 4810                   ' tput no cr/lf
        IF MsgCt MOD 15 = 0 THEN _
           CALL SkipLine (1) : _
           CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
     NEXT
     WasA1$ = ""
     CALL SkipLine (1)
     IF ZUserSecLevel >= ZOptSec(9) THEN _
        CALL QuickTPut1 (ZFG9$ + "Please K)ill your old messages" + ZEmphasizeOff$)
1961 IF NOT ZExpertUser AND Temp = 5 THEN _
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
     ActionFlag = ZFalse
     IF NOT ClearTwirly THEN _
       IF StatsCheck THEN _
          CALL WipeLine(79) _
       ELSE CALL SkipLine(1)
     RETURN
'
' ****  E - COMMAND FROM MAIN MENU (ENTER MESSAGE)  ***
'
2000 QuotedReply = ZFalse
     MsgFrom$ = ZActiveUserName$
     ZSysopMsg = ZFalse
     GOSUB 1893
2001 IF (LowMsgNumber > 0 AND ZActiveMessages >= ZMaxMsgs) _
           OR ZHighMsgNumber >= 9999 THEN
        IF ZActiveMessageFile$ = ZMainMsgFile$ AND _
           ZActiveMessages = 1 THEN
           ZJParm = 1
           CALL JoinConference (Found)
           IF ZJParm = 3 THEN _
              RETURN
        ELSE
           ZOutTxt$ = "No more messages allowed!  Try tomorrow"
           GOSUB 4795
           GOTO 3650
        ENDIF
     ENDIF
2002 '
2006 IF NOT (ZReply OR MsgFwd) THEN _
        MsgPswd$ = ""
     ZSysopComment = ZFalse
     IF ZReply OR MsgFwd THEN _
        SaveAnsIndex = ZAnsIndex
     IF MsgFwd OR NOT ZReply THEN _
        IF ZUserSecLevel >= ZOptSec(5) THEN _
           MsgTo$ = ""
2007 IF ZSysopComment THEN _
        ZWasZ$ = ZCmntsFile$ : _
        ZMsgHeader$ = "comment" _
     ELSE ZWasZ$ = ZActiveMessageFile$ : _
          ZMsgHeader$ = "message"
2008 IF ZSysopComment OR ZMsgsCanGrow THEN _
        ZWasY$ = "on disk" : _
        CALL FindFree : _
        GOTO 2009
     IF ZNextMsgRec + 5 < ZHighestMsgRecord THEN _
        GOTO 2010
     ZWasY$ = "in file"
     ZFreeSpace$ = "1"
2009 IF VAL(ZFreeSpace$) >= 2000 THEN _
        GOTO 2010
     ZOutTxt$ = "No room " + ZWasY$ + " for " + ZMsgHeader$
     GOSUB 4815                      ' tput with cr/lf
     CALL DelayTime (2)
     GOTO 3650
2010 IF NOT QuotedReply THEN _
        ZLinesInMsg = 0 : _
        WasL = 0 : _
        WasX = 0 : _
        REDIM ZOutTxt$(ZMsgDim)
     IF ZGetExtDesc THEN _
        GOTO 2100
     GOSUB 1893
     RcvrRecNum = 0
2020 CALL SetWhoTo (-ZEnableCC*(ZUserSecLevel>=ZOptSec(5)),MsgTo$,MsgFrom$,_
                     RcvrRecNum,Found,INSTR(ZMsgSecCats$,"U")>0,_
                     FirstLineText$,SecondLineText$,AddressLine)
     IF ZNetConference THEN _
        IF MsgTo$ = "SYSOP" THEN _
           GOTO 1800
     IF MsgTo$ = "" THEN _
        RETURN
     IF ZSysopComment OR ZSysopMsg THEN _
        GOTO 2100
     IF ZReply OR MsgFwd THEN _
        Found = ZTrue : _
        CALL Trim (MsgTo$):  _
        GOTO 2035 _
     ELSE Subject$ = ""
     GOSUB 2065              ' get subject
     IF MParm <> 0 THEN _
        RETURN
2035 IF QuotedReply THEN _
        RETURN
     GOTO 2100
'
' *****  SET/CHANGE SUBJECT FOR A MESSAGE   ***
'
2065 IF Subject$ <> "" THEN _
        ZOutTxt$ = "Change subject from " + _
             Subject$ + _
             " to" _
     ELSE ZOutTxt$ = "Subject"
     ZMacroMin = 99
     ZParseOff = ZTrue
     GOSUB 4790
     IF LEN(ZUserIn$) > 25 THEN _
        ZOutTxt$ = "25 chars max" : _
        GOSUB 4815 : _                  ' tput with cr/lf
        GOTO 2065
     IF ZWasQ = 0 THEN _
        IF Subject$ <> "" THEN _
           RETURN _
        ELSE GOSUB 2435 : _
             IF ZYes THEN _
                MParm = 3 : _
                RETURN _
             ELSE GOTO 2065
     Subject$ = ZUserIn$
     CALL AllCaps (Subject$)
     OrigSubject$ = Subject$
     RETURN
'
' *****  ENTER MAIN BODY OF MESSAGE  ****
'
2100 'CALL SaveUserActivity("M", ZNodeRecIndex, ZFalse)
     GOSUB 2105
     GOSUB 2101
     IF NOT ZYes THEN _
        GOTO 2120             ' line editor
     GOSUB 2105
     GOTO 2110                ' ansi editor
2101 ZYes = ZFalse
     IF (ZUserGraphicDefault$ = "C" OR NOT ZHiLiteOff) AND NOT ZGetExtDesc THEN
        ZOutTxt$ = ZFG1$ + "Use the " + ZFGA$ + "ANSI" + ZFG1$ + _
                  " Full Screen Editor (Y,[N]" + ZFG1$ + ")" + ZEmphasizeOff$
        GOSUB 4785
     END IF
     RETURN
2105 IF ZIConference AND ZConfMode AND FirstLineText$ <> "" THEN
        ZOutTxt$(1) = FirstLineText$
        IF SecondLineText$ <> "" THEN _
           ZOutTxt$(2) = SecondLineText$
     END IF
     IF FirstLineText$ <> "" THEN _
        ZLinesInMsg = 1
     IF SecondLineText$ <> "" THEN _
        ZLinesInMsg = 2
     RETURN
2110 CALL Ansied (MsgTo$,OrigSubject$,MsgLockLines)
     I = ZSubParm
     CALL SkipLine (1)
     IF I = -2 THEN      ' Sleep Disconnect
        MParm = 9
        EXIT SUB
     ELSEIF I = -1 THEN  ' Lost Carrier
        MParm = 10
        EXIT SUB
     ELSEIF I = 1 THEN   ' Save Message
        GOTO 3400
     ELSEIF I = 2 THEN   ' Abort Message
        GOTO 2430
     END IF
2120 IF ZGetExtDesc THEN
        CALL SkipLine (1)
        ZOutTxt$ = ZFG4$ + "Continue Description for: " + _
                   ZFGF$ + ZFileNameHold$ + ZCrLf$ + _
                   ZFG4$ + "You'll have" + ZFGF$ + _
                   STR$(ZMaxMsgLines) + ZFG4$ + " Extra Lines."
        ZOutTxt$ = ZOutTxt$ + "  Press " + ZEmphasizeOn$ + "[ENTER]" + _
                   ZEmphasizeOff$ + ZFG4$ + " By Itself for Menu." + _
                   ZEmphasizeOff$ + ZCrLf$
        CALL QuickTPut1 (ZOutTxt$) : _
        ZOutTxt$ = ZFG1$ + "Line #1: " + ZFGE$ + "[" + ZFGF$ + ZDesc$ + _
                   + ZFGE$ + "]" + ZEmphasizeOff$
        CALL Line25
     ELSE
        ZOutTxt$ = "Type " + ZMsgHeader$ + STR$(ZMaxMsgLines) + _
                   " lines max" +  ZPressEnter$
     END IF
     GOSUB 4795                                    ' tput - skip a line first
     GOSUB 3200                                    ' [-------]
     IF FirstLineText$ <> "" AND ZIConference THEN _
        WasL = 1 : _
        GOSUB 3020
2125 ZLinesInMsg = ZLinesInMsg + 1
2127 IF ZGetExtDesc THEN _
        TempLinesInMsg = ZLinesInMsg + 1 _
     ELSE TempLinesInMsg = ZLinesInMsg
     IF ZRemoteEcho OR ZLocalUser THEN _
        ZOutTxt$ = RIGHT$(STR$(TempLinesInMsg),2) + _
             ": " + _
             ZOutTxt$(ZLinesInMsg) _
     ELSE ZOutTxt$ = ZOutTxt$(ZLinesInMsg)
     GOSUB 4810                                   ' tput no cr/lf
     CALL LineEdit(ZLinesInMsg,ZRightMargin + 1)
     IF ZWaitExpired THEN _
        GOTO 2300 _
     ELSE IF ZSubParm = -1 THEN _
             MParm = 10 : _
             EXIT SUB
     CALL FindFKey
     IF ZSubParm < 0 THEN _
        MParm = 7 : _
        EXIT SUB
     IF ZOutTxt$(ZLinesInMsg) = "" THEN _
        ZLinesInMsg = ZLinesInMsg - 1 : _
        GOTO 2300
2140 WasJ = ZLinesInMsg
     GOSUB 2200
     IF WasX THEN _
        GOTO 2300
     GOTO 2125
2200 WasX = 0
     IF WasJ < (ZMaxMsgLines - 2) THEN _
        RETURN
     ZOutTxt$ = MID$("2 lines leftLast line   Full",12 * (WasJ-(ZMaxMsgLines - 2)) + 1,12)
     WasX = (WasJ > (ZMaxMsgLines - 1))
2210 GOSUB 4815                            ' tput with cr/lf
     RETURN
'
' *****  FINAL MESSAGE DISPOSITION   ****
'
2300 CALL SkipLine (1)
     IF ZExpertUser THEN _
        GOTO 2315
2302 ZOutTxt$ = "A)bort, " + LEFT$("B)atch import, ",-15 * (ZSysop OR ZLocalUser)) + _
                "C)ontinue adding, D)elete lines, E)dit a line"
     CALL TopPrompt
     ZOutTxt$ = "I)nsert lines, L)ist, M)argin change, R)evise subj, S)ave msg, ?)help"
     CALL TopPrompt
2315 ZOutTxt$ = "Edit Sub-function <A," + _
          LEFT$("B,",-2 * (ZSysop OR ZLocalUser)) + _
          "C,D,E,I,L,M,R,S,?>"
     GOSUB 4785
     IF ZWasQ = 0 THEN _
        GOTO 2315
     CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
     ZWasZ$ = ZUserIn$(ZAnsIndex)
2330 ON INSTR("ABCDEILMRS?",ZWasZ$) GOTO 2400,2335,2332,2500,2600,2800,3000,3100,2440,3400,2345
     GOTO 2300
2332 IF ZLinesInMsg < 1 THEN _
        ZLinesInMsg = 1
     GOTO 2127
2335 WasX = ZLinesInMsg
     CALL MsgImport (ZMaxMsgLines,ZRightMargin,ZLinesInMsg,ZOutTxt$())
     IF ZLinesInMsg > WasX THEN _
        GOTO 3000 _
     ELSE GOTO 2300
'
' *****  DISPLAY MESSAGE SUBCOMMANDS HELP FILE   ****
'
2345 ZFileName$ = ZHelp$(4)
     CALL InitWelc (2)
     GOTO 2302
2350 IF ZCurPUI$ = "" OR ZSubBoard THEN _
        ZCurPUI$ = ZMainPUI$
     CALL FindIt (ZCurPUI$)
     ZCustomPUI = ZOK
     IF NOT ZOK THEN _
        ZCurPUI$ = ""
     ZPrevPUI$ = ""
     RETURN
'
' ****  ABORT MESSAGE   ***
'
2400 GOSUB 2435
     IF NOT ZYes THEN _
        GOTO 2300
2430 ZOutTxt$ = "Aborted"
     GOSUB 4795
     GOTO 3650
2435 ZOutTxt$ = "Abort " + _
          ZMsgHeader$ + _
          " (Y,[N])"
     GOSUB 4785
     RETURN
'
' *****  CHANGE SUBJECT OF A MESSAGE  ****
'
2440 GOSUB 2065
     GOTO 2300
'
' *****  (BLOCK) DELETE MESSAGE LINE(S)  *****
'
2500 ZOutTxt$ = "Delete from"
     GOSUB 3300
     IF ZWasQ = 0 THEN _
        IF Mark1 = 0 THEN _
        GOTO 2300
     Mark1 = ZTestedIntValue
     IF ZAnsIndex < ZLastIndex AND ZUserIn$(ZAnsIndex+1) = "-" THEN _
           ZAnsIndex = ZAnsIndex + 1 _
     ELSE Temp = INSTR(ZUserIn$(ZAnsIndex),"-") : _
             IF Temp > 0 AND Temp < LEN(ZUserIn$(ZAnsIndex)) THEN _
                ZUserIn$(ZAnsIndex) = MID$(ZUserIn$(ZAnsIndex),Temp+1) : _
                ZAnsIndex = ZAnsIndex - 1
2520 Temp$ = ZFG1$ + "Up to and including Line # (" + ZFG4$ + "ENTER =" + _
              ZFGB$ + STR$(Mark1) + ZFG1$ + ")" + ZEmphasizeOff$
     CALL ChangeInt (ZFalse,Temp$,0,Mark1,ZLinesInMsg)
     IF ZWasQ = 0 THEN _
        Mark2 = Mark1 _
     ELSE Mark2 = ZTestedIntValue
     CALL SkipLine(1)
     GOTO 2530
2522 FOR WasX = Mark1 TO Mark2
        CALL AskMore ("",ZTrue,ZTrue,WasXX,ZFalse)
        IF ZNo OR ZRet THEN _
           WasX = Mark2 + 1 _
        ELSE ZOutTxt$ = ZOutTxt$(WasX) : _
           GOSUB 4805
     NEXT
     CALL SkipLine(1)
2530 IF ZGetExtDesc THEN _
        TempMark1 = Mark1 + 1 : _
        TempMark2 = Mark2 + 1 _
     ELSE _
        TempMark1 = Mark1 : _
        TempMark2 = Mark2
     ZOutTxt$ = ZFG1$ + "Delete lines" + ZEmphasizeOff$ + STR$(TempMark1) + "-" + _
        MID$(STR$(TempMark2),2) + " (Y,[N],L)ist)"
     GOSUB 4785
     Temp$ = ZUserIn$(ZAnsIndex)
     CALL AllCaps(Temp$)
     IF Temp$ = "L" THEN GOTO 2522
     IF NOT ZYes THEN _
        ZOutTxt$ = ZFG1$ + "NOT Deleted" + ZEmphasizeOff$: _
        GOSUB 4815 : _                     ' tput with cr/lf
        GOTO 2555
2550 ZBlockSize = (Mark2 - Mark1) + 1
     EndOfBuffer = ZLinesInMsg + 1
     ZLinesInMsg = ZLinesInMsg - ZBlockSize
     FOR WasX = Mark1 TO ZLinesInMsg
        ZOutTxt$(WasX) = ZOutTxt$(WasX + ZBlockSize)
     NEXT
     FOR WasX = (ZLinesInMsg + 1) TO (EndOfBuffer)
        ZOutTxt$(WasX) = ""
     NEXT
     ZOutTxt$ = ZFG1$ + "Deleted" + ZFGF$ + STR$(ZBlockSize) + _
                ZFG1$ + " line(s)" + ZEmphasizeOff$
     GOSUB 4815                                         ' tput with cr/lf
2555 Mark1 = 0
     Mark2 = 0
     GOTO 2300
'
' ****  EDIT MESSAGE LINE  ***
'
2600 ZOutTxt$ = "Edit"
     GOSUB 3300
     IF ZWasQ = 0 THEN _
        GOTO 2300
     IF ZWasQ <> 0 THEN _
        CALL EditALine (ZTestedIntValue)
     IF ZSubParm < 0 THEN _
        MParm = 7 : _
        EXIT SUB
     GOTO 2300
2800 IF ZLinesInMsg >= ZMaxMsgLines AND NOT ZSysop THEN _
        ZOutTxt$ = "Message full" : _
        GOSUB 4815 : _                        ' tput with cr/lf
        GOTO 2300
2820 ZOutTxt$ = "Insert Before" : _
     GOSUB 3300
     IF ZWasQ = 0 THEN _
        GOTO 2300
2830 WasLL = ZLinesInMsg
     WasK = ZLinesInMsg - ZTestedIntValue
     FOR WasX = ZTestedIntValue TO ZLinesInMsg
        ZUserIn$(WasX + 1 - ZTestedIntValue) = ZOutTxt$(WasX)
        ZOutTxt$(WasX) = ""
     NEXT
     ZLinesInMsg = ZTestedIntValue
2840 ZOutTxt$ = RIGHT$(STR$(ZLinesInMsg),2) + _
          ": " + ZOutTxt$(ZLinesInMsg)
     GOSUB 4810                 ' tput no cr/lf
     CALL LineEdit(ZLinesInMsg,ZRightMargin + 1)
     IF ZOutTxt$(ZLinesInMsg) = "" THEN _
        GOTO 2920
2870 ZLinesInMsg = ZLinesInMsg + 1
     WasJ = ZLinesInMsg + WasK - 1
     GOSUB 2200
     IF NOT WasX THEN _
        GOTO 2840
2920 FOR WasX = 1 TO WasK + 1
        ZOutTxt$(ZLinesInMsg + WasX - 1) = ZUserIn$(WasX)
     NEXT
     REDIM ZUserIn$(ZMsgDim)
     ZLinesInMsg = WasLL + ZLinesInMsg - ZTestedIntValue
     GOTO 2300
'
' *****  LIST MESSAGE CONTENTS   ****
'
3000 GOSUB 3010
     GOTO 2300
3010 ZStopInterrupts = ZFalse
     CALL SkipLine (1)
     IF (ZWasQ = 1 OR MsgFwd) AND NOT ZGetExtDesc THEN _
        WasL = 1 : _
        ZOutTxt$ = ZFG4$ + "To: " + ZFGB$ + _
             MsgTo$ + _
             ZFG4$ + " Re: " + ZFGB$ + _
             Subject$ + ZEmphasizeOff$ : _
        GOSUB 4815 : _                        ' tput with cr/lf
        CALL QuickTPut (MID$("    ",1,-4 * (NOT ZRemoteEcho)),0) : _
        GOSUB 3200
3020 IF ZGetExtDesc THEN _
        WasL = 1
     FOR WasX = WasL TO ZLinesInMsg
        CALL AskMore ("",ZTrue,ZTrue,WasXX,ZFalse)
        IF ZNo OR ZRet THEN _
           WasX = ZLinesInMsg + 1 _
        ELSE _
           IF ZGetExtDesc THEN _
              ZOutTxt$ = RIGHT$(STR$(WasX + 1),2) + _
                 ": " + ZOutTxt$(WasX) : _
              GOSUB 4815 _                        ' tput with cr/lf
           ELSE _
              ZOutTxt$ = RIGHT$(STR$(WasX),2) + _
                   ": " + ZOutTxt$(WasX) : _
              GOSUB 4815                        ' tput with cr/lf
     NEXT
     RETURN
'
' *****  CHANGE MARGIN WIDTH   ****
'
3100 CALL ChangeInt (ZTrue,"Right margin",ZRightMargin,8,72)
     IF ZWasQ <> 0 THEN _
        ZRightMargin = ZTestedIntValue
3150 IF UtilMarginChange THEN _
        RETURN
     GOTO 2300
3200 ZOutTxt$ = "[" + _
          STRING$(ZRightMargin - 2,45) + _
          "]"
     IF ZRemoteEcho OR ZLocalUser THEN _
        ZOutTxt$ = "    " + _
             ZOutTxt$
     GOSUB 4795
     RETURN
3300 Temp$ = ZOutTxt$ + " Line #"
     Temp = MsgLockLines + 1
     CALL SkipLine (-(ZAnsIndex >= ZLastIndex))
     CALL ChangeInt (ZFalse,Temp$,0,Temp,ZLinesInMsg)
     IF ZSubParm = -1 THEN _
        MParm = 2 : _
        RETURN
     RETURN
'
' ****  SAVE MESSAGE   ***
'
3400 IF ZGetExtDesc THEN _
        ZSysopComment = ZFalse : _
        RETURN
     IF ZSysopComment THEN _
        ZSysopComment = ZFalse : _
        GOTO 1850
     IF ZOutTxt$(1) = "" AND INSTR(LEFT$(MsgTo$,31),"UUCP") > 0 THEN
        CALL SkipLine (1)
        CALL QuickTPut1 ("CAN NOT save messages that begin with BLANK lines")
        CALL QuickTPut1 ("DELETE the BLANK line(s) or ABORT the message")
        IF I = 1 THEN
           CALL DelayTime (2)
           I = 0
           GOTO 2110
        ELSE
           GOTO 2300
        END IF
     END IF
3405 IF ZSysopMsg THEN _
        MsgPswd$ = "^READ^" _
     ELSE Temp$ = MsgPswd$ : _
          CALL MsgProt (MsgTo$,Found,MsgPswd$) : _
          IF MsgPswd$ = "" THEN _
             MsgPswd$ = Temp$ : _
             IF I = 1 THEN _
                I = 0 : _
                GOTO 2110 _
             ELSE _
                GOTO 2300
     SaveReplyStatus = ZReply
     ZReply = ZTrue
3406 ZSysopMsg = ZFalse
     ZReply = SaveReplyStatus
     GOSUB 4835                ' lock msgs
     GOSUB 4700                ' open msgs
     IF ZJParm = 3 THEN _
        RETURN
     IF LOF(1) = 0 THEN _
        ZWasDF$ = ZActiveMessageFile$ : _
        CLOSE 1 : _
        KILL ZActiveMessageFile$ : _
        GOSUB 4840 : _
        MParm = 4 : _
        RETURN
     CALL GetMessageHdr
     MsgRecSave$ = ZMsgRec$
     MsgCorrected = ZFalse
     CALL FixMessageHdr
     ZWasSL = 0
     ZWasN$ = ""
     ZLastIndex = 0
     ZHighMsgNumber = ZHighMsgNumber + 1
3410 ZActiveMessages = ZActiveMessages + 1
     MsgNum$ = STR$(ZHighMsgNumber) + _
                       SPACE$(5 - LEN(STR$(ZHighMsgNumber)))
     IF MsgPswd$ = "^READ^" THEN _
        MID$(MsgNum$,1,1) = "*" : _
        SecForMsg = ZPrivateReadSec _
     ELSE SecForMsg = ZPublicReadSec
3460 IF NOT MsgFwd THEN _
        MsgFrom$ = LEFT$(ZActiveUserName$ + SPACE$(31),31) _
     ELSE _
        MsgFrom$ = LEFT$(MsgFrom$ + SPACE$(31),31)
3461 MsgTo$ = LEFT$(MsgTo$ + SPACE$(31),31)
     MID$(MsgTo$,23,8) = TIME$
     MID$(MsgTo$,31,1) = CHR$(ZNumHeaders)
     Subject$ = LEFT$(OrigSubject$ + SPACE$(25),25)
     MsgPswd$ = LEFT$(MsgPswd$ + SPACE$(15),15)
     IF QuotedReply AND _
        ZLinesInMsg > ZMaxMsgLines THEN _
           ZLinesInMsg = ZMaxMsgLines
     FOR WasJ = 1 TO ZLinesInMsg
        ZOutTxt$(WasJ) = ZOutTxt$(WasJ) + _
                CHR$(227)
        ZWasSL = ZWasSL + LEN(ZOutTxt$(WasJ))
     NEXT
     NumRecs = ZWasSL \ 128 + ZNumHeaders - (ZWasSL MOD 128 <> 0)
     ZWasN$ = STR$(NumRecs)
3530 Temp = ZNextMsgRec
     ZNextMsgRec = Temp + VAL(ZWasN$)
     LSET ZMsgRec$ = MsgRecSave$
     CALL UpdtMessageHdr
     GET 1,Temp
     ZMsgPtr(ZActiveMessages,1) = Temp
     ZMsgPtr(ZActiveMessages,2) = ZHighMsgNumber
     LSET ZMsgRec$ = MsgNum$ + _
                     MsgFrom$ + _
                     MsgTo$ + _
                     ZCurDate$ + _
                     Subject$ + _
                     MsgPswd$ + _
                     ZActiveMessage$ + _
                     ZWasN$ + _
                     SPACE$(4 - LEN(ZWasN$)) + _
                     MKI$(SecForMsg)
' ---[ write out list of people msg is to ]---
     UserFileIndexSave = ZUserFileIndex
     UserRecordHold$ = ZUserRecord$
     CALL OpenWork (2,ZNodeWorkFile$,ZFalse)
     WHILE NOT EOF(2)
        CALL ReadParms (ZWorkAra$(),2,1)
        MID$(ZMsgRec$,37,22) = LEFT$(ZWorkAra$(1)+ SPACE$(22),22)
        RcvrRecNum = VAL(ZWorkAra$(2))
        PUT 1,Temp
        Temp = Temp + 1
        NumRecs = NumRecs - 1
' ---[ notify receiver that has new mail waiting ]---
        CALL SetUserFlag (RcvrRecNum, 512, "mail")
        IF ZFunnyMessage THEN _
           ZMailWaiting = -1
     WEND
     ZWasN$ = ""
     ZOutTxt$ = "Adding new msg #" + _
          STR$(ZHighMsgNumber)
     IF NOT ZLocalUser THEN _
        CALL UpdtCalr (ZOutTxt$,1)
     GOSUB 4810                        ' tput no cr/lf
3600 'NumDots = 0
     FOR WasJ = 1 TO ZLinesInMsg
        ZWasN$ = ZWasN$ + ZOutTxt$(WasJ)
        IF LEN(ZWasN$) > 127 THEN _
           LSET ZMsgRec$ = ZWasN$ : _
           PUT 1 : _
           ZWasN$ = MID$(ZWasN$,129)
3630 NEXT
     IF LEN(ZWasN$) > 0 THEN _
        LSET ZMsgRec$ = ZWasN$ : _
        PUT 1
     REDIM ZOutTxt$(ZMsgDim)
     IF MsgCorrected THEN _
        MsgCorrected = ZFalse : _
        ActionFlag = ZTrue : _
        CALL SkipLine (1) : _
        GOSUB 1900
3640 CALL SkipLine (1)
     GET 1,1
     GOSUB 4830
     ZUserFileIndex = UserFileIndexSave
     LSET ZUserRecord$ = UserRecordHold$
3650 QuotedReply = ZFalse
     MsgLockLines = 0
     IF ZReply OR MsgFwd THEN _
        ZReply = ZFalse : _
        ZAnsIndex = SaveAnsIndex : _
        RETURN
     IF ZGetExtDesc THEN _
        ZLinesInMsg = 0
     IF GetOut THEN _
        MParm = 1
     RETURN
'
' ****  K - COMMAND FROM MAIN MENU (KILL MESSAGE)  ***
'
3900 ZKillMessage = ZFalse
     CALL SkipLine (1)
3930 ZOutTxt$ = "Msg #(s) to Kill" + LEFT$(", M)arked",-9*(ZMarkedMsgs$ <> "")) + ZPressEnterExpert$
     GOSUB 4790
     IF ZWasQ = 0 THEN _
        RETURN
     GOSUB 1893
     ZWasZ$ = ZUserIn$(ZAnsIndex)
     CALL UnMarkItems (ZMarkedMsgs$,ZAnsIndex,ZLastIndex,Found,ZTrue)
3935 CALL CheckInt (ZUserIn$(ZAnsIndex))
     IF ZErrCode <> 0 THEN _
        GOTO 3930
     MsgToKill = ZTestedIntValue
3950 GOSUB 4700
     CALL KillMsg (MsgToKill,ZActiveMessages)
4040 IF ZKillMessage THEN _
        RETURN
     GOTO 3930
'
' ****  Sysop Available toggle
'
4130  ZSubParm = -8
      CALL FindFKey
      ZSubParm = 0
      RETURN
'
' ****  X)pert Toggle
'
4240 CALL Toggle(9)
     RETURN
'
' ****  T)opic - QUICK SCAN MESSAGES  ***
'
4320 QuickScanMsgs = ZTrue
     ReadMsgs = ZFalse
     ScanMsgs = ZFalse
     MsgStart = 76
     MsgEnd = 100
     SecIndex= 0
     GOTO 4350
'
' ****  R - COMMAND FROM MAIN MENU (READ MESSAGES)  ****
'
4330 IF ZLinkNext THEN _
        ZLinkNext = ZFalse : _
        GOSUB 1893 : _
        GOSUB 4700 : _
        NumMsgsSelected = 1 : _
        ZAnsIndex = 1 : _
        MsgIndex = 1 : _
        ZLastIndex = 1 : _
        CanKill = (ZSysop OR ZUserSecLevel >= ZSecKillAny) : _
        IF LinkForward THEN _
           CurMsg = ZLastMsgRead + 1 : _
           GOTO 4450 _
        ELSE CurMsg = ZHighMsgNumber : _
             GOTO 4490
     QuickScanMsgs = ZFalse
     ReadMsgs = ZTrue
     Forward = ZFalse
     ZGlobalRead = ZFalse
     HiLiteRec = -1
     ScanMsgs = ZFalse
     MsgStart = 6
     MsgEnd = 100
     IF ZLocalUserMode OR NOT ZLocalUser THEN _
        IF ReadMsgIn$ <> ZActiveMessageFile$ THEN _
           ReadMsgIn$ = ZActiveMessageFile$ : _
           CALL UpdtCalr ("Read Messages in " + ReadMsgIn$,1)
     GOSUB 4895
     GOTO 4350
'
' ****  S - COMMAND FROM MAIN MENU (SCAN MESSAGE HEADERS)  ***
'
4340 IF ZWasQ < 2 THEN _
        GOSUB 4895
4345 QuickScanMsgs = ZFalse
     ReadMsgs = ZFalse
     ScanMsgs = ZTrue
     MsgStart = 6
     MsgEnd = 100
     SecIndex = 0
'
' ** MESSAGE READ MAINLINE (QUICK SCAN, READ & SCAN) ALL USE THIS ROUTINE *
'
4350 SearchHeader$ = ""
     SubInHeader$ = ""
4352 SearchString$ = ""
     DontPrint = ZFalse
     JustReplied = ZFalse
     QuotedReply = ZFalse
     CanKill = (ZSysop OR ZUserSecLevel >= ZSecKillAny)
     GOSUB 1893
     GOSUB 4700         ' open msg file
     ZWasZ$ = ""
     FOR WasI = 2 TO ZLastIndex
        IF INSTR("Ss*",ZUserIn$(WasI)) > 0 THEN _
           ZUserIn$(WasI) = MID$(STR$(ZLastMsgRead+1),2) + "+"
        IF INSTR("Ll",ZUserIn$(WasI)) > 0 THEN _
           ZUserIn$(WasI) = MID$(STR$(ZHighMsgNumber),2) + "-"
        IF INSTR("Gg",ZUserIn$(WasI)) > 0 THEN _
           GOSUB 4640
     NEXT
4360 ZWasLG$(11) = ZWasZ$
     NumMsgsSelected = ZLastIndex
     MsgIndex = ZAnsIndex
     ZLastIndex = 0
     AddressedToUser = ZFalse
     ToRequested = ZFalse
     FromRequested = ZFalse
     ZLinkNext = ZFalse
'     CALL SaveUserActivity("M", ZNodeRecIndex, ZFalse)
4370 MsgIndex = MsgIndex  + 1
4371 IF MsgIndex <= NumMsgsSelected THEN _
        IF LEN(ZUserIn$(MsgIndex)) = 1 AND _
           INSTR("Cc",ZUserIn$(MsgIndex)) > 0 THEN _
           GOTO 4370 _
        ELSE _
        CALL CheckInt (ZUserIn$(MsgIndex)) : _
        IF ZErrCode <> 0 THEN _
           ZWasEL = 4371 : _
           MParm = 8 : _
           RETURN _
        ELSE CurMsg = ZTestedIntValue : _
             ZAnsIndex = MsgIndex : _
             GOTO 4415
4380 WasA1$ = "Msg #" + _
           STR$(LowMsgNumber) + _
           "-" + _
           MID$(STR$(ZMsgPtr(ZActiveMessages,2)),2) + _
           " (H)lp,S)ince,L)ast" + _
           LEFT$(",G)lobal",8*(ZLinkedConf$ ="" OR ZGlobalRead)+8)
     CALL SkipLine (-QuickScanMsgs)
     IF ZGlobalRead THEN _
        CALL QuickTPut1 ("Reading globally")
     IF AddressedToUser OR ToRequested OR FromRequested THEN _
        ZWasY$ = LEFT$("TO",-2*(ToRequested OR AddressedToUser)) + _
             LEFT$("/",-AddressedToUser) + _
             LEFT$("FROM",-4*(FromRequested OR AddressedToUser)) : _
        CALL QuickTPut1 ("Include only msgs "+ZWasY$+" you.  Read what msgs (? for help)") _
     ELSE WasA1$ = WasA1$ + ",T)o,F)rom,M)" : _
          IF ReadMsgs AND ZMarkedMsgs$ <> "" THEN _
             WasA1$ = WasA1$ + "arked" _
          ELSE WasA1$ = WasA1$ + "ine"
     IF SearchString$ = "" THEN _
        WasA1$ = WasA1$ + _
             ", text" _
     ELSE CALL QuickTPut1 ("Include only msgs with text " + SearchString$ + ".  Read what msgs (? for help)")
4390 ZOutTxt$ = WasA1$ + ", [Q]uit)"
     ZMacroMin = 99
     ZTurboKey = 0
     CALL WipeLine(79)
4400 GOSUB 4790               ' call popcmdstack
     IF ZWasQ = 0 THEN _
        RETURN
4402 IF LEN(ZUserIn$(ZAnsIndex)) = 1 THEN _
        WasY = INSTR("QqHh?",ZUserIn$(ZAnsIndex)) : _
        IF WasY > 2 THEN _
            ZFileName$ = ZHelpPath$ + "MR" + ZHelpExtension$ : _
            CALL InitWelc (2) : _
            GOTO 4390 _
        ELSE IF WasY > 0 THEN _
                RETURN
     MsgIndex = 0
     NumMsgsSelected = ZWasQ
     GOTO 4370
4415 Forward = ZFalse
     Reverse = ZFalse
     FOR WasI = ZAnsIndex to ZLastIndex
        IF INSTR("Gg",ZUserIn$(WasI)) > 0 THEN _
           GOSUB 4640
     NEXT
     IF ZAnsIndex <= ZLastIndex OR LEN(ZUserIn$(ZAnsIndex)) = 1 THEN _
        IF INSTR("Ss*",ZUserIn$(ZAnsIndex)) > 0 THEN _
           CurMsg = ZLastMsgRead + 1 : _
           Forward = ZTrue : _
           GOTO 4430 _
        ELSE IF INSTR("Ll",ZUserIn$(ZAnsIndex)) > 0 THEN _
                CurMsg = ZHighMsgNumber : _
                Reverse = ZTrue : _
                GOTO 4490 _
        ELSE IF INSTR("Gg",ZUserIn$(ZAnsIndex)) > 0 THEN _
                ZGlobalRead = ZTrue : _
                GOTO 4370
4416 IF INSTR("Mm",ZUserIn$(ZAnsIndex)) = 0 THEN _
        GOTO 4418
     IF ReadMsgs THEN _
        ZWasZ$ = "M" : _
        CALL UnMarkItems (ZMarkedMsgs$,MsgIndex,NumMsgsSelected,Found,ReadMsgs) : _
        MsgIndex = MsgIndex + Found _
     ELSE Found = ZFalse
     AddressedToUser = NOT Found
     GOTO 4370
4418 ZWasA = INSTR("FfTt",ZUserIn$(ZAnsIndex))
     IF ZWasA > 0 THEN _
        ToRequested = (ZWasA > 2) : _
        FromRequested = (ZWasA < 3) : _
        GOTO 4370
     IF CurMsg = 0 THEN _
        IF SearchHeader$ <> "" THEN _
           GOTO 4370 _
        ELSE SearchString$ = ZUserIn$(ZAnsIndex) : _
             SearchCt = 0 : _
             CALL AllCaps (SearchString$) : _
             CALL Remove (SearchString$,CHR$(34) + CHR$(39)) : _
             SearchHeader$ = SearchString$ : _
             SubInHeader$ = SearchHeader$ : _
             GOTO 4370
     CALL SkipLine (-ReadMsgs)
4430 IF RIGHT$(ZUserIn$(ZAnsIndex),1) = "+" THEN _
        Forward = ZTrue
     IF RIGHT$(ZUserIn$(ZAnsIndex),1) = "-" THEN _
        Reverse = ZTrue : _
        GOTO 4490
4450 ZMsgDimIndex = 1                  ' search FORWARD/EXACT for current msg
4452 IF ZMsgDimIndex > ZActiveMessages THEN _
        GOTO 4515
     IF ReadMsgs AND _
        ZMsgPtr(ZMsgDimIndex,2) = CurMsg THEN _
        GOTO 4520
4470 IF ((ReadMsgs AND Forward) OR _
        QuickScanMsgs OR ScanMsgs) AND _
        ZMsgPtr(ZMsgDimIndex,2) >= CurMsg THEN _
        GOTO 4520
4480 ZMsgDimIndex = ZMsgDimIndex + 1
     GOTO 4452
4490 ZMsgDimIndex = ZActiveMessages     ' search REVERSE for current msg
4492 IF ZMsgDimIndex < 1 THEN _
        GOTO 4515
     IF ZMsgPtr(ZMsgDimIndex,2) <= CurMsg THEN _
        GOTO 4540
4510 ZMsgDimIndex = ZMsgDimIndex - 1
     GOTO 4492
4515 IF Forward THEN _
        ZOutTxt$ = "No new messages" : _
        ZLastMsgRead = ZHighMsgNumber : _
        ZMailWaiting = ZFalse _
     ELSE ZOutTxt$ = "No such msg #" + _
               STR$(CurMsg)
     IF SubInHeader$ = "" THEN _
        GOSUB 4815                   ' tput with cr/lf
     ZLastIndex = 0
     GOTO 4637                       ' leave gosub
4520 EndingMsgIndex = ZMsgDimIndex   ' read a single message
     IF ReadMsgs AND NOT Forward THEN _
        GOTO 4560
4530 StartMsgIndex = ZMsgDimIndex
     EndingMsgIndex = ZActiveMessages
     WasSO = 1
     GOTO 4550
4540 StartMsgIndex = ZMsgDimIndex
     EndingMsgIndex = 1
     WasSO = -1
4550 WasXXX = EndingMsgIndex + WasSO
     ZMsgDimIndex = StartMsgIndex
4552 IF ZMsgDimIndex = WasXXX THEN _    ' top msg read loop end is 4635
        CALL Carrier : _
        GOTO 4637                       ' bails here when reached last msg
4560   CurHeader = ZMsgPtr(ZMsgDimIndex,1)
       IF CurHeader < 1 THEN _
          GOTO 4515
       CALL CheckKBStop
       IF ZRet THEN _
         GOTO 4637                      ' bails here
       GET 1,CurHeader
       ZPswdFailed = ZFalse
       UserInHeader = ZFalse
       ZWasZ$ = MID$(ZMsgRec$,101,15)
       MsgPswd$ = ZWasZ$
       CALL Trim(MsgPswd$)
4561   GOSUB 4660           ' multiple headers
       GOSUB 4655           ' update last msg read
4562   IF NOT CanKill THEN _
          IF INSTR(ZMsgRec$,"^READ^") > 0 AND NOT UserInHeader THEN _
             ZPswdFailed = ZTrue : _
             IF Forward OR Reverse THEN _
                GOTO 4635
4563   CurMsg = VAL(MID$(ZMsgRec$,2,4))
       IF ToRequested THEN _
          IF NOT MsgToCaller THEN _
             GOTO 4629
       IF FromRequested THEN _
          IF NOT MsgFromCaller THEN _
             GOTO 4629
       IF AddressedToUser AND NOT UserInHeader THEN _
          GOTO 4629
       WasX$ = MID$(ZMsgRec$,121,2)
       IF WasX$ = "  " THEN _
          MsgSec = ZMinLogonSec _
       ELSE MsgSec = CVI(WasX$)
       IF ZUserSecLevel < MsgSec THEN IF NOT ZSysOp THEN _
          GOTO 4629
4580   IF INSTR(ZMsgRec$,ZWasLG$(11)) = 0 THEN _
          GOTO 4635
4581   IF MID$(ZMsgRec$,116,1) = ZDeletedMsg$ THEN _
          GOTO 4630
       JustSearching = ZFalse
       IF SearchHeader$ <> "" THEN _
          ZFF = INSTR(ZMsgRec$,SearchHeader$) : _
          IF ZFF >= MsgStart AND ZFF <= MsgEnd THEN _
             HiLitePos = ZFF : _
             SearchCt = 0 : _
             GOTO 4582 _
          ELSE IF ReadMsgs AND SearchString$ <> "" THEN _
                  JustSearching = ZTrue : _
                  GOTO 4582 _
               ELSE GOTO 4629
4582   WasPG = ZFalse
       IF MID$(ZWasZ$,1,1) = "!" THEN _
          IF NOT CanKill THEN _
             WasPG = ZTrue : _
             ZPswdSave$ = MID$(ZWasZ$,2) + _
                              " " : _
             ZAttemptsAllowed = 0 : _
             ZSubParm = 1 : _
             CALL PassWrd
4584   IF ZPswdFailed AND _
          (QuickScanMsgs OR (ScanMsgs AND NOT WasPG)) THEN _
          GOTO 4635
4585   IF ZPswdFailed THEN _
          IF WasPG THEN _
             WasSJ$ = "<PASSWORD>" _
          ELSE WasSJ$ = "<PROTECTED>" _
       ELSE WasSJ$ = MID$(ZMsgRec$,76,25)
4590   IF QuickScanMsgs THEN
          IF LEFT$(ZMsgRec$,1) = "*" THEN
             ZOutTxt$ = ZFGF$ + LEFT$(ZMsgRec$,1) + ZFGE$ +  MID$(ZMsgRec$,2,4)
          ELSE
             ZOutTxt$ = ZFGE$ + LEFT$(ZMsgRec$,5)
          END IF
          ZOutTxt$ = ZOutTxt$ + " " +  ZFG1$ + LEFT$(WasSJ$,19) + _
               " " + ZEmphasizeOff$
          CALL CheckColor (ZOutTxt$,SubInHeader$,ZEmphasizeOff$)
          GOSUB 4810                ' tput no cr/lf
          SecIndex = SecIndex + 1
          IF SecIndex = 3 THEN
             SecIndex = 0
             CALL SkipLine (1)
             GOTO 4630
          ELSE
             GOTO 4630
          END IF
       END IF
4600   IF ScanMsgs THEN _
          GOSUB 4715 : _
          GOTO 4630
       IF NOT JustSearching THEN _
          GOSUB 4710 : _
          IF QuotedReply THEN _
             QuotedReply = ZFalse : _
             GOTO 4602
       IF ZRet THEN _
          GOTO 4630
       CanChangeSec = (ZUserSecLevel => ZSecChangeMsg)
       ShowKill =  - ((ZUserSecLevel >= ZOptSec(9)) AND (UserInHeader OR CanKill))
       IF ZExpertUser THEN _
          WasA1$ = ",H" + _
          MID$(",R",1,- (ZUserSecLevel >= ZOptSec(5)) * 2) + _
          ",T,M,=,+,-" + _
          MID$(",F",1,- (UserInHeader OR CanChangeSec) * 2) + _
          MID$(",K",1,ShowKill * 2) + _
          MID$(",U",1,- (ZUserSecLevel >= ZOptSec(54)) * 2) + _
          MID$(",S",1, - CanChangeSec * 2) + _
          MID$(",E",1, - (ZSysOp AND ZLocalUser) * 2) : _
          GOTO 4601
       GOSUB 4617
4601   ZTurboKey = -ZTurboKeyUser
4602   IF NOT ZPswdFailed THEN _
          GOTO 4603
       IF WasPG AND (NOT ZNonStop) THEN _
          ZAttemptsAllowed = 2 : _
          ZSubParm = 2 : _
          CALL PassWrd
       IF ZPswdFailed THEN _
          GOTO 4629
       CALL QuickTPut1 ("   Re:  " + MID$(ZMsgRec$,76,25))
4603   IF NOT JustSearching THEN
          IF ZWasGR > 0 THEN
             Temp$ = STRING$(ZRightMargin,205)
             IF ZWasGr > 1 THEN _
                Temp$ = ZFG4$ + Temp$ + ZEmphasizeOff$
          ELSE
             Temp$ = STRING$(ZRightMargin,61)
          END IF
          CALL QuickTPut (Temp$,1)
       END IF
       GOSUB 4750
       JustReplied = ZFalse
       DontPrint = ZFalse
       IF JustSearching THEN _
          GOTO 4629
       IF ZAnsIndex > NumMsgsSelected THEN _
          GOTO 4650
       CALL SkipLine (1)
       GOSUB 4890
       ZKillMessage = ZFalse
       ZReply = ZFalse
4604   ZTurboKey = -ZTurboKeyUser
       CALL AskMore (WasA1$,ZTrue,ZFalse,WasXX,ZFalse)
       IF ZSubParm = -1 THEN _
          EXIT SUB
       IF ZNo THEN _
          IF WasXX >= 32000 THEN _
             WasXX = 0 : _
             ZAnsIndex = ZLastIndex + 1 : _
             RETURN _
          ELSE GOTO 4637                     ' bails here
       IF ZNonStop THEN _
          GOTO 4629
       CALL AraAllCaps(ZUserIn$(),1)
       ZReply = (ZReply OR ZUserIn$(1) ="R")
4605   ON INSTR(" FUST+-KRH?=MEZ",LEFT$(ZUserIn$(1),1)) GOTO _
          4620,4606,4607,4608,4609,4610,4610,4611,4621,4612,4614,4615,4652,4616,4618
       GOTO 4620
4606   IF NOT (UserInHeader OR CanChangeSec) THEN _   ' Forward
         GOTO 4620
       MsgFwd = ZTrue
       GOTO 4623
4607   IF ZUserSecLevel < ZOptSec(54) THEN _    ' User edit
          GOTO 4620
       EditFromRead = 1
       ReturnRead = ZFalse
       ZReply=ZTrue
       CALL PutMsgAttr
       TempHashValue$ = MsgFrom$
       CALL Trim (TempHashValue$)
       IF TempHashValue$ = "SYSOP" THEN _
          TempHashValue$ = ZSecretName$
       GOTO 4780
4608   IF CanChangeSec THEN _            ' Security to read
          CALL PutMsgAttr : _
          GOSUB 4665 : _
          ZReply = ZFalse : _
          QuotedReply = ZTrue : _
          CALL GetMsgAttr : _
          DontPrint = ZTrue : _
          ZUserIn$ = "=" : _
          JustReplied = ZTrue : _
          GOTO 4560
       GOTO 4620
4609   CALL SetThread (CurMsg, OrigSubject$)     ' Thread
       IF ZWasQ > 0 THEN _
          SearchHeader$ = ZUserIn$(2) : _
          SubInHeader$ = SearchHeader$ : _
          CALL Trim (SubInHeader$) : _
          GOTO 4352
       GOTO 4620
4610   ZWasA = INSTR(" +-",ZUserIn$(1))      ' +/- read direction
       CurMsg = CurMsg + 5 - 2 * ZWasA
       Forward = (ZWasA = 2)
       Reverse = (NOT Forward)
       SearchString$ = ""
       IF Reverse THEN _
          GOTO 4490 _
       ELSE GOTO 4450
4611   IF (UserInHeader OR CanKill) THEN _     ' Kill
         IF ZUserSecLevel >= ZOptSec(9) THEN _
            CALL PutMsgAttr : _
            MsgToKill = CurMsg : _
            Temp = ZWasQ : _
            GOSUB 3950 : _
            CALL GetMsgAttr : _
            GOTO 4629 _
         ELSE ZViolation$ = "MORE KILL" : _
              GOSUB 4880 : _
              GOTO 4629
       GOTO 4620
4612   ZFileName$ = ZHelp$(7)  ' H - help
       CALL InitWelc (2)
4614   GOSUB 4617
       GOTO 4604
4615   CALL SkipLine (1) ' = read again
       GOTO 4560
4616   CALL MessageExport (EMsgRec$, ESent$, Year$, MsgSec, MsgTo$, MsgFrom$, Subject$)
       GOTO 4620
4617   IF ZGlobalSysop THEN _
          SplitLine$ = ZCrLf$ + "           " _
       ELSE SplitLine$ = ","
       WasA1$ = ",H)lp" + SplitLine$ + _
                MID$("R)ply",1, - (ZUserSecLevel >= ZOptSec(5)) * 6) + _
                ",T)hrd,M)rk" + _
                MID$(",F)wd",1, - (UserInHeader OR CanChangeSec) * 5) + _
                MID$(",K)ill",1, ShowKill * 6) + _
                MID$(",U)sr",1,- (ZUserSecLevel >= ZOptSec(54)) * 6) + _
                MID$(",S)ec",1, - CanChangeSec * 5) + _
                MID$(",E)xpt",1, - (ZSysOp AND ZLocalUser) * 6) + _
                ",=,+,- "
       RETURN
4618   IF ZUserIn$(1) = "Z" AND ZSysop THEN _
          ZMsgDimIndex = DGSMsgDimIndex : _
          MID$(DGSRecord$,123,6) = SPACE$(6) : _
          LSET ZMsgRec$ = DGSRecord$ : _
          GOSUB 4835 : _
          PUT 1,ZMsgPtr(ZMsgDimIndex,1) : _
          GOSUB 4840
4620   IF NOT ZReply THEN _
          GOTO 4629
4621   IF ZUserSecLevel < ZOptSec(5) THEN _     ' Reply
          ZViolation$ = "MORE RE" : _
          GOSUB 4880 : _                        ' call secviolation
          ZReply = ZFalse : _
          GOTO 4629
       IF LEFT$(OrigSubject$,3) <> "(R)" THEN _
          OrigSubject$ = "(R)" + _
                     LEFT$(OrigSubject$,22)
4622   IF NOT ZIConference THEN
          MsgTo$ = MsgFrom$
          CALL Trim (MsgTo$)
          QuoteTo$ = MsgTo$ + "'s "
       ELSE
          QuoteTo$ = ""
       END IF
       MsgFrom$ = ZActiveUserName$
4623   DontPrint = ZFalse
       CALL PutMsgAttr
       IF MsgFwd THEN _
          GOTO 4624
       IF ZNoQuoting THEN _
          GOTO 4627
       ZOutTxt$ = ZFG1$ + "Quote " + ZFGF$ + QuoteTo$ + ZFG1$ + _
                  "message (Y,[N]" + ZFG1$ + ")" + ZEmphasizeOff$
       GOSUB 4875                                    ' call tget
       IF ZRet OR NOT ZYes THEN _
          GOTO 4627
4624   QuotedReply = ZTrue
       ZLinesInMsg = ZLinesInMsg - 1
       IF HiLitedLine > 0 THEN _
          ZOutTxt$(HiLitedLine) = ZOutTxt$(0) : _
          HiLitedLine = 0
       IF MsgFwd THEN _
          TempRightMargin = ZRightMargin _
       ELSE TempRightMargin = ZRightMargin - 4
       CALL WordWrap (TempRightMargin,ZLinesInMsg,ZOutTxt$())
       IF ZLinesInMsg > ZMsgDim THEN _
          ZLinesInMsg = ZMsgDim : _
          CALL QuickTPut1 ("Original msg truncated to " + _
                      STR$(ZMsgDim) + " lines for editing!")
       IF MsgFwd AND NOT ZIConference THEN _
          GOTO 4625
       QuoteInit = INSTR(MsgTo$, " ")
       QuoteInit = QuoteInit + 1
       QuoteMark$ = LEFT$(MsgTo$, 1) + _
          MID$(MsgTo$, QuoteInit, 1) + ">"
       IF MsgTo$ = "SYSOP" THEN _
          QuoteMark$ = LEFT$(ZSysopFirstName$, 1) + _
             LEFT$(ZSysopLastName$, 1) + ">"
       FOR WasX = 1 TO ZLinesInMsg
          IF MID$(ZOutTxt$(WasX), 3, 1) = ">" THEN _
             ZOutTxt$(WasX) = ZOutTxt$(WasX) _
          ELSE ZOutTxt$(WasX) = QuoteMark$ + ZOutTxt$(WasX)
       NEXT
4625   WasX$ = MsgTo$
       GOSUB 2001
       IF (ZActiveMessages >= ZMaxMsgs) OR MsgTo$ = "" THEN _
          GOTO 4628
       IF MsgFwd THEN _
          MsgFwd$ = ZActiveUserName$ : _
          CALL Trim (MsgFwd$) : _
          CALL Trim (WasX$) : _
          MsgFwd$ = "Msg was to " + WasX$ + _
             ", forwarded by " + MsgFwd$
       IF (MsgFwd AND CanChangeSec AND NOT MsgFromCaller) THEN _
          CALL Trim (MsgFrom$) : _
          ZOutTxt$ = "Message was from " + _
             MsgFrom$ + _
             ", change to " + _
             ZActiveUserName$ + _
             " (Y,[N])" : _
          GOSUB 4875 : _                 ' TGet
          IF ZYes THEN _
             MsgFrom$ = ZActiveUserName$ : _
             CALL Trim (MsgFrom$) : _
             IF NOT ZIConference THEN _
                GOTO 4626
       IF (MsgFwd AND NOT MsgFromCaller) OR (ZIConference AND FirstLineText$ <> "") THEN
          IF SecondLineText$ <> "" THEN _
             MoveLinesCount = 3 _
          ELSE MoveLinesCount = 2
          FOR MsgFwdCount = ZLinesInMsg TO 1 STEP -1
             ZOutTxt$(MsgFwdCount + MoveLinesCount) = ZOutTxt$(MsgFwdCount)
          NEXT MsgFwdCount
          AddLinesCount = 2
          IF ZIConference THEN
             IF FirstLineText$ <> "" THEN _
                ZOutTxt$(1) = FirstLineText$
             IF SecondLineText$ <> "" THEN _
                ZOutTxt$(2) = SecondLineText$ : _
                AddLinesCount = 3
          ELSE
             ZOutTxt$(1) = MsgFwd$
             ZOutTxt$(2) = ""
          END IF
          ZLinesInMsg = ZLinesInMsg + AddLinesCount
          IF NOT CanChangeSec AND NOT ZIConference THEN _
             MsgLockLines = 1
       END IF
4626   ZWasZ$ = "L"
       WasL = 1
       GOSUB 2101       ' choose editor
       IF ZYes THEN
          GOSUB 2110    ' user chose ansied
       ELSE
         IF ZLinesInMsg >= ZMaxMsgLines THEN _
            CALL QuickTPut ("Msg cannot exceed" + _
                        STR$(ZMaxMsgLines) + " lines! ",0)
         IF NOT MsgFwd THEN _
            CALL SkipLine (1) : _
            CALL QuickTPut1 (ZFGE$ + "Please delete unneeded lines, then " + _
                 ZFGF$ + "[C]" + ZFGE$ + " continues reply" + ZEmphasizeOff$)
         GOSUB 3200           ' draw [---]
         GOSUB 3020           ' display msg to reply to
         GOSUB 2300           ' final msg disposition
       END IF
       GOTO 4628
4627   GOSUB 2000
4628   ZReply = ZFalse
       JustReplied = ZTrue
       QuotedReply = ZTrue
       CALL GetMsgAttr
       DontPrint = ZTrue
       ZUserIn$ = "="
       QuotedReply = ZTrue
       MsgFwd = ZFalse
       GOTO 4560
4629   QuotedReply = ZFalse
       JustReplied = ZFalse
       IF NOT Forward AND NOT Reverse THEN _
          GOTO 4370
4630   IF ZMsgDimIndex = EndingMsgIndex AND NOT ReadMsgs THEN
          IF SecIndex > 0 THEN _
             CALL SkipLine(1)
          CALL QuickTPut1 (ZFG9$ + "-- End of Msgs --" + ZEmphasizeOff$)
          CALL AskMore (",M)ark, #(s) to read",ZTrue,ZFalse,WasXX,ZFalse)
       ELSE
          CALL AskMore (",M)ark, #(s) to read",ZTrue,ZTrue,WasXX,ZFalse)
       END IF
       IF ZWasQ = 0 OR ZYes THEN _
          GOTO 4631
       IF ZNo THEN _
          RETURN
       IF ZSubParm = -1 THEN _
          MParm = 2 : _
          RETURN
       IF ZRet THEN _
          RETURN
       ZWasZ$ = ZUserIn$(1)
       CALL AllCaps (ZWasZ$)
       IF ZWasZ$ = "M" THEN _
          ZLastIndex = ZWasQ : _
          ZAnsIndex = 1 : _
          CALL AskItems ("M",ZWasZ$,ZTrue,"msg",ZMarkedMsgs$,ZFalse)
       IF VAL(ZWasZ$) > 0 THEN _
          FOR WasI = ZWasQ TO 1 STEP -1 : _
             ZUserIn$(WasI + 1) = ZUserIn$(WasI) : _
          NEXT : _
          ZUserIn$(1) = MID$(ZAllOpts$,INSTR(ZOrigCommands$,"R"),1) : _
          ZLastIndex = ZWasQ + 1 : _
          ZAnsIndex = 1 : _
          MParm = 5 : _
          RETURN
4631   IF NOT Forward AND NOT Reverse THEN _
          GOTO 4370          ' increment msg index value
       CALL CheckCarrier
       IF ZSubParm THEN _
          MParm = 2 : _
          RETURN
       IF ZRet THEN _
          RETURN
4635 IF WasSO = 0 THEN _      ' end msg read loop top is 4552
        WasSO = 1
     IF SearchString$ <> "" THEN _
        SearchCt = SearchCt + 1 : _
        IF SearchCt > 99 THEN _
           SearchCt = 0 : _
           ZOutTxt$ = "Searched for " + SearchString$ + " thru msg" + _
                      STR$(CurMsg) + "  Continue ([Y],N)" : _
           GOSUB 4790 : _
           IF ZNo THEN _
              RETURN
     ZMsgDimIndex = ZMsgDimIndex + WasSO
     GOTO 4552
4637 ZLastIndex = 0
     CALL SkipLine (1)
     IF Forward OR Reverse THEN _
        CALL NextConf (ZGlobalRead) : _
        IF ZHomeConf$ <> "" THEN _
           ZLinkNext = ZTrue : _
           LinkForward = Forward : _
           ZConfMailJoin = ZTrue : _
           MParm = 6 : _
           IF NOT ZExpertUser THEN _
              CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) : _
           RETURN
     IF ReadMsgs THEN _
        SearchString$ = "" : _
        SearchHeader$ = "" : _
        SubInHeader$ = "" : _
        ToRequested = ZFalse : _
        FromRequested = ZFalse : _
        AddressedToUser = ZFalse : _
        GOTO 4370
4640 FOR WasJ = WasI to ZLastIndex-1
        ZUserIn$(WasJ) = ZUserIn$(WasJ+1)
     NEXT
     ZGlobalRead = ZTrue
     ZLastIndex = ZLastIndex - 1
     IF NOT ZExpertUser THEN _
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
     RETURN
4650 IF NOT ZExpertUser THEN _
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) _
     ELSE CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
     CALL QuickTPut1 ("--End Msgs--")
     RETURN
4652 '****     mark current message         ****
     ZMarkedMsgs$ = ZMarkedMsgs$ + STR$(CurMsg) + ZCarriageReturn$
     CALL ReportMarked (ZMarkedMsgs$,"msg")
     GOTO 4604
4655 '****     update last message read     ****
     IF SearchHeader$ <> "" OR SearchString$ <> "" OR NOT ReadMsgs THEN _
        RETURN
4656 IF ZMsgPtr(ZMsgDimIndex,2) > ZLastMsgRead THEN _
        ZMailWaiting = ZFalse : _
        ZLastMsgRead = ZMsgPtr(ZMsgDimIndex,2)
     RETURN
4660 ZNumHeaders = ASC(MID$(ZMsgRec$,67,1))
     FirstActive = 0
     IF ZNumHeaders < 1 THEN _
        ZNumHeaders = 1
     CurrHeaderRecNum = LOC(1)
     WasI = 1
4661 WasY = (ASC(MID$(ZMsgRec$,116,1)) = 225)
     IF FirstActive = 0 THEN _
        IF WasY THEN _
           FirstActive = LOC(1)
     GOSUB 4662
     GET 1
     CALL ChkIfMsgHeader
     IF NOT ZOK THEN _
        ZNumHeaders = WasI
     IF MsgToCaller AND (WasY OR (ZUserSecLevel < ZSecKillAny)) THEN _
        CurrHeaderRecNum = LOC(1) - 1 _
     ELSE WasI = WasI + 1 : _
          IF WasI <= ZNumHeaders THEN _
              GOTO 4661 _
          ELSE IF FirstActive > 0 THEN _
                  CurrHeaderRecNum = FirstActive
     GET 1, CurrHeaderRecNum
     UserInHeader = (MsgFromCaller OR MsgToCaller)
     RETURN
4662 CALL ChkMsgName (MsgFromCaller,MsgToCaller)
     IF ZNewUserDGS AND INSTR(ZMsgRec$, "NEWUSER") > 0 THEN _
        MsgToCaller = ZTrue
     RETURN
'
' ****  S - CHANGE MESSAGE SECURITY   ***
'
4665 CALL Trim (MsgFrom$)
     ZOutTxt$ = "Change sender's name from " + _
        MsgFrom$ + _
        " to"
     GOSUB 4860
     IF ZWasQ = 0 THEN _
        GOTO 4666
     IF LEN(ZUserIn$) > 30 THEN _
        CALL QuickTPut1 ("30 chars max") : _
        GOTO 4665
     CALL AllCaps (ZUserIn$)
     MsgFrom$ = ZUserIn$
4666 CALL Trim (MsgTo$)
     ZOutTxt$ = "Change receiver's name from " + _
        MsgTo$ + _
        " to"
     GOSUB 4860
     IF ZWasQ = 0 THEN _
        GOTO 4667
     IF LEN(ZUserIn$) > 30 THEN _
        CALL QuickTPut1 ("30 chars max") : _
        GOTO 4666
     CALL AllCaps (ZUserIn$)
     MsgTo$ = ZUserIn$
     TempMsgTo$ = ZUserIn$
     CALL SetWhoTo (ZFalse,MsgTo$,MsgFrom$,RcvrRecNum,Found,ZTrue,_
                    FirstLineText$,SecondLineText$,AddressLine)
     IF MsgTo$ = "" THEN _
        MsgTo$ = TempMsgTo$
4667 CALL Trim (Subject$)
     ZOutTxt$ = "Change subject from " + _
        Subject$ + _
        " to"
     GOSUB 4860
     IF ZWasQ = 0 THEN _
        GOTO 4668
     IF LEN(ZUserIn$) > 25 THEN _
        CALL QuickTPut1 ("25 chars max") : _
        GOTO 4667
     CALL AllCaps (ZUserIn$)
     Subject$ = ZUserIn$
4668 CALL ChangeInt (ZTrue,"min sec to read",MsgSec,-32000,ZSysopSecLevel)
     IF ZWasQ <> 0 THEN _
        MsgSec = ZTestedIntValue
4669 ZReply = ZTrue
     CALL MsgProt (MsgTo$,Found,MsgPswd$)
     ZReply = ZFalse
4670 MsgTo$ = LEFT$(MsgTo$ + SPACE$(22),22)
     MsgFrom$ = LEFT$(MsgFrom$ + SPACE$(31),31)
     Subject$ = LEFT$(Subject$ + SPACE$(25),25)
     MsgPswd$ = LEFT$(MsgPswd$ + SPACE$(15),15)
     ZSubParm = 3
     CALL FileLock
     GET 1,CurHeader
     MID$(ZMsgRec$,37,22) = MsgTo$
     MID$(ZMsgRec$,6,31) = MsgFrom$
     MID$(ZMsgRec$,76,25) = Subject$
     MID$(ZMsgRec$,121,2) = MKI$(MsgSec)
     MID$(ZMsgRec$,101,15) = MsgPswd$
     IF LEFT$(MsgPswd$,6) = "^READ^" THEN _
        MID$(ZMsgRec$,1,1) = "*" _
     ELSE _
        MID$(ZMsgRec$,1,1) = " "
     PUT 1,CurHeader
     ZSubParm = 4
     CALL FileLock
     CALL QuickTPut1 ("Message header changed")
     CALL SkipLine (1)
     RETURN
'
' *****  OPEN AND SETUP MESSAGE BASE  *****
'
4700 CALL OpenMsg
     IF ZErrCode = 64 THEN _
        ZErrCode = 0 : _
        ZJParm = 4 : _
        CALL JoinConference (Found)
     FIELD 1, 128 AS ZMsgRec$
     RETURN
'
' *  FORMAT MESSAGE HEADER INFORMATION FOR DISPLAY
'
4710 IF ZRet THEN _
        RETURN
4715 IF MID$(ZMsgRec$,37,5) = "ALL  " THEN _
        MsgTo$ = "ALL" : _
        GOTO 4725
     DGSMsgDimIndex = ZMsgDimIndex
     DGSRecord$ = ZMsgRec$
4720 MsgTo$ = MID$(ZMsgRec$,37,22)
     IF (ZNewUserDGS AND INSTR(MsgTo$,"NEWUSER")) THEN _
         MsgTo$ = ZActiveUserName$
     CALL Trim (MsgTo$)
     IF ZNumHeaders > 1 THEN _
        MsgTo$ = MsgTo$ + " et al."
4725 IF LEN(MsgTo$) < 23 THEN _
        MsgTo$ = MsgTo$ + _
                      SPACE$(23 - LEN(MsgTo$))
     Subject$ = MID$(ZMsgRec$,76,25)
     CALL Trim (Subject$)
     CALL AllCaps (Subject$)
     OrigSubject$ = Subject$
     IF ZPswdFailed THEN _
        Subject$ = WasSJ$
4730 MsgFrom$ = MID$(ZMsgRec$,6,31)
     CALL Trim (MsgFrom$)
     IF LEN(MsgFrom$) < 23 THEN _
        MsgFrom$ = MsgFrom$ + _
                        SPACE$(23 - LEN(MsgFrom$))
     IF ZUserSecLevel >= ZSecChangeMsg THEN _
        Year$ = "Security:" + _
              STR$(MsgSec) _
        ELSE Year$ = ZConfName$
     IF MID$(ZMsgRec$,101,1) = "!" THEN _
        MID$(ZMsgRec$,1,1) = "!"
     Year2$ = MID$(STR$(ZMsgPtr(ZActiveMessages,2)),2)
     EMsgRec$ = LEFT$(ZMsgRec$,5)
     CALL Trim(Year2$)
     IF ZUserGraphicDefault$ = "C" OR NOT ZHiLiteOff THEN _
        ZClrScr$ = ZEscape$ + "[2J" _
     ELSE ZClrScr$ = ""
     ZOutTxt$ = ZClrScr$ + ZFG4$ + "Msg #: " + ZFGB$ + RTRIM$(EMsgRec$) + _
          ZFG4$ + " of " + ZFGB$ + Year2$ + _
          SPACE$(23-LEN(RTRIM$(EMsgRec$))-LEN(Year2$)) + Year$
     ESent$ = MID$(ZMsgRec$,68,8) + " " + MID$(ZMsgRec$,59,5)
     Year$ = ZFG1$ + "   Sent: " + ESent$
     IF MID$(ZMsgRec$,123,6) = SPACE$(6) THEN _
         DGSMSGRCV$ = " -> " _
     ELSE DGSMSGRCV$ = " => "
     IF NOT ZRet THEN _
        IF ReadMsgs THEN _
           CALL QuickTPut1 (ZOutTxt$): _
           WasX$ = MsgFrom$ : _
           CALL CheckColor (WasX$,SubInHeader$,ZFGE$) : _
           CALL QuickTPut1 (ZFGE$ + " From:  " + WasX$ + Year$) : _
           GOSUB 4735 : _
           WasX$ = MsgTo$ : _
           CALL CheckColor (WasX$,SubInHeader$,ZFGF$) : _
           CALL QuickTPut1 (ZFGF$ + "   To:  " + WasX$ + "  " + ZFG1$ + Year$) : _
           CALL CheckColor (Subject$,SubInHeader$,ZFG4$) : _
           ZOutTxt$ = ZFG4$ + "   Re:  " + Subject$ + ZEmphasizeOff$ : _
           CALL Line25 _
        ELSE ZOutTxt$ = ZFGF$ + LEFT$(ZMsgRec$,5) + _
                  " " + _
                  ZFGE$ + MID$(ZMsgRec$,68,5) + _
                  " " + _
                  ZFG4$ + LEFT$(MsgFrom$,18) + _
                  ZFGA$ + DGSMSGRCV$ + _
                  ZFG1$ + LEFT$(MsgTo$,19) + _
                  " " + _
                  ZFGB$ + LEFT$(Subject$,24) + ZEmphasizeOff$ : _
             CALL CheckColor (ZOutTxt$,SubInHeader$,"") : _
             GOTO 4745
     IF QuickScanMsgs OR _
        ScanMsgs THEN _
           GOTO 4745 _
     ELSE GOTO 4740
4735 IF MID$(ZMsgRec$,123,6) = STRING$(6,0) OR _
        MID$(ZMsgRec$,123,6) = SPACE$(6) THEN _
           Year$ = " Rcvd: -NO-" : _
           RETURN
     Year$ = " Rcvd: " + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,123,1))),2) + _
           "-" + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,124,1))),2) + _
           "-" + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,125,1))),2) + _
           " " + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,126,1))),2) + _
           ":" + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,127,1))),2)
     FOR WasI = 8 TO 15
        IF MID$(Year$,WasI,1) = " " THEN _
           MID$(Year$,WasI,1) = "0"
     NEXT
     FOR WasI = 17 TO 21
        IF MID$(Year$,WasI,1) = " " THEN _
           MID$(Year$,WasI,1) = "0"
     NEXT
     RETURN
4740 IF (NOT MsgToCaller) THEN _
        ZWasA = (MID$(ZMsgRec$,37,5) = "ALL  ") : _
        IF NOT ZWasA THEN _
           GOTO 4745
     IF MsgFromCaller AND NOT ZSysOp THEN _
        GOTO 4745
     Year$ = DATE$
     WasWK$ = TIME$
     MID$(ZMsgRec$,123,6) = CHR$(VAL(MID$(Year$,1,2))) + _
                                   CHR$(VAL(MID$(Year$,4,2))) + _
                                   CHR$(VAL(MID$(Year$,9,2))) + _
                                   CHR$(VAL(MID$(WasWK$,1,2))) + _
                                   CHR$(VAL(MID$(WasWK$,4,2))) + _
                                   CHR$(VAL(MID$(WasWK$,7,2)))
     GOSUB 4835                ' lock msgs
     PUT 1,CurrHeaderRecNum
     GOSUB 4840                ' unlock msgs
4745 GOSUB 4815                ' tput with cr/lf
     ZOutTxt$ = ""
     RETURN
'
' * UNCOMPRESS MESSAGE PRIOR TO DISPLAY
'
4750 IF NOT JustSearching THEN _
        GOSUB 4656: _
        CALL SkipLine (1) : _
        ZLinesInMsg = 1 : _
        MsgDimXtra = ZMsgDim + 25 : _
        REDIM ZOutTxt$(MsgDimXtra) : _
        Remain$ = "" : _
        HiLitedLine = 0
     RecToRead = ZMsgPtr(ZMsgDimIndex,1) + ZNumHeaders - 1
     FOR WasX = ZNumHeaders + 1 TO VAL(MID$(ZMsgRec$,117,4))
        WasJ = 1
        RecToRead = RecToRead + 1
        GET 1, RecToRead
        IF JustSearching THEN _
           ZOutTxt$ = ZMsgRec$ : _
           CALL AllCaps (ZOutTxt$) : _
           HiLitePos = INSTR(ZOutTxt$,SearchString$) : _
           IF HiLitePos > 0 THEN _
              SearchCt = 0 : _
              HiLiteRec = LOC(1) : _
              WasX = 9999 : _
              GOTO 4775 _
           ELSE GOTO 4775
4755    ZWasB = INSTR(WasJ,ZMsgRec$,CHR$(227))
        IF ZRet THEN _
           RETURN
4760    ZWasC = ZWasB - WasJ
        IF ZWasC < 0 THEN _
           ZWasC = 128
4765    ZOutTxt$ = MID$(ZMsgRec$,WasJ,ZWasC)
        IF HiLiteRec = LOC(1) THEN _
           IF HiLitePos >= WasJ AND HiLitePos < WasJ+ZWasC THEN _
              HiLiteRec = -1 : _
              Bracketed = ZTrue : _
              ZOutTxt$(0) = ZOutTxt$ : _
              CALL Bracket (ZOutTxt$,HiLitePos-WasJ+1,HiLitePos+LEN(SearchString$)-WasJ,ZEmphasizeOn$,ZEmphasizeOff$)
        IF ZWasB = 0 THEN _
           Remain$ = ZOutTxt$ : _
           GOTO 4775 _
        ELSE ZOutTxt$ = Remain$ + ZOutTxt$ : _
             Remain$ = "" : _
             WasJ = ZWasB + 1
4770    IF LEFT$(ZOutTxt$,1) = ZStartOfHeader$ OR _
           LEFT$(ZOutTxt$,LEN(ZScreenOutMsg$)) = ZScreenOutMsg$ THEN _
           GOTO 4755
        ZOutTxt$(ZLinesInMsg) = ZOutTxt$
        IF Bracketed THEN _
           Bracketed = ZFalse : _
           HiLitedLine = ZLinesInMsg
        ZLinesInMsg = ZLinesInMsg + 1
        IF ZLinesInMsg > MsgDimXtra THEN _
           ZLinesInMsg = ZLinesInMsg - 1 : _
           CALL SkipLine (1) : _
           CALL QuickTPut1 ("Message too long.  Truncated to" + STR$(MsgDimXtra) + " lines!") : _
           ZOutTxt$ = "" : _
           RETURN
        IF NOT DontPrint THEN _
           GOSUB 4815 : _             ' tput with cr/lf
           IF ZRet THEN _
              ZOutTxt$ = "" : _
              RETURN _
           ELSE CALL AskMore ("",ZTrue,ZTrue,ZAnsIndex,ZFalse) : _
                IF ZNo THEN _
                   DontPrint = ZTrue
        GOTO 4755
4775 NEXT
     IF DontPrint = ZTrue THEN _
        MParm = 3 : _
        RETURN
     IF JustSearching AND HiLitePos > 0 THEN _
        JustSearching = ZFalse : _
        GET 1,ZMsgPtr(ZMsgDimIndex,1) : _
        GOSUB 4710 : _
        GOTO 4750
     ZOutTxt$ = ""
     RETURN
4780 CALL UserMaint (EditFromRead, TempHashValue$, ReturnRead)
     IF ZSubParm < 0 THEN _
        MParm = 2 : _
        RETURN
     IF ReturnRead THEN _
        ReturnRead = ZFalse : _
        GOTO 4560
     RETURN
4785 ZTurboKey = -ZTurboKeyUser
4790 CALL PopCmdStack
     GOTO 4870
4795 ZSubParm = 1
     GOTO 4820
4800 ZSubParm = 2
     GOTO 4820
4805 ZSubParm = 3
     GOTO 4820
4810 ZSubParm = 4     ' no cr/lf
     GOTO 4820
4815 ZSubParm = 5     ' cr/lf
4820 CALL TPut
4825 IF ZSubParm < 0 THEN _
        MParm = 7 : _
        EXIT SUB
     IF ZSubParm = 8 THEN _
        GOSUB 4860
     RETURN
4830 ZSubParm = 2  ' UNLOCK MESSAGES AND FLUSH
     Flushed = ZTrue
     GOTO 4855
4835 ZSubParm = 3  ' LOCK MESSAGES
     GOTO 4855
4840 ZSubParm = 4  ' UNLOCK MESSAGES
     GOTO 4855
4845 ZSubParm = 9  ' LOCK COMMENTS/UPLOAD DIR
     GOTO 4855
4850 ZSubParm = 10 ' UNLOCK COMMENTS/UPLOAD DIR
4855 CALL FileLock
     IF Flushed THEN _
        FIELD 1,128 AS ZMsgRec$ : _
        Flushed = ZFalse
     IF ZSubParm = -1 THEN _
        ZSubParm = -9 : _
        CALL FindFKey : _
        MParm = 7 : _
        EXIT SUB
     RETURN
'
' * STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL INPUT ROUTINE
'
4860 GOSUB 4870
     ZSubParm = 1
4865 CALL TGet
4870 IF ZSubParm < 0 THEN _
        MParm = 7 : _
        EXIT SUB
     RETURN
4875 ZTurboKey = -ZTurboKeyUser
     GOTO 4860
'
' *****  RECORD SECURITY VIOLATIONS   ****
'
4880 CALL SecViolation
     IF NOT ZDenyAccess THEN _
        RETURN
4885 CALL DenyAccess
     MParm = 11
     RETURN
'
' * CALCULATE TIME REMAINING FOR USER
'
4890 CALL CheckTimeRemain (MinsRemaining)
     IF ZSubParm = -1 THEN _
        MParm = 12
        RETURN
     RETURN
4895 CALL QuickTPut1 (ZFGF$ + ZConfName$ + ZFGE$ + " Message base" + ZEmphasizeOff$)
     RETURN
     END SUB
'
5111  '$SUBTITLE: 'PersInfo -- subroutine to change Personal Info'
' $PAGE
'
' NAME   : PersInfo
'
' PURPOSE: To allow user to change personal infomation - "P" from
'          the utilities Menu.  Formerly in RBBS-PC.BAS
'
'
      SUB PersInfo STATIC
5112  CALL QuickTPut1 (ZUserLocation$ + " now " + ZWasCI$)
      WasA1$ = "Enter new "
      ZMacroMin = 99
      ZParseOff = ZTrue
5114  ZOutTxt$ = WasA1$ + ZUserLocation$
      IF NOT ZNewUser THEN _
         ZOutTxt$ = ZOutTxt$ + ZPressEnter$
      ZParseOff = ZTrue
      GOSUB 5140
      IF ZWasQ = 0 OR ZUserIn$ = SPACE$(LEN(ZUserIn$)) THEN _
         IF ZNewUser THEN _
            GOTO 5114 _
         ELSE GOTO 5116
      CALL AllCaps (ZUserIn$)
      CALL QuickTPut1 ("Set to " + ZUserIn$)
      LSET ZCityState$ = ZUserIn$
      ZWasCI$ = ZUserIn$
5116  CALL NewPassword ("Enter new password" + ZPressEnter$,ZTrue)
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         EXIT SUB
5120  ZOutTxt$ = "Re-enter new password ([ENTER] cancels)"
      ZHidden = ZTrue
      GOSUB 5150
      ZHidden = ZFalse
      IF ZWasQ = 0 THEN _
         EXIT SUB
      CALL AllCaps (ZUserIn$)
      IF ZWasZ$ <> ZUserIn$ THEN _
         ZOutTxt$ = "Passwords don't match!" : _
         GOSUB 5144 : _
         GOTO 5120
5125  IF ZMaxPswdChanges AND _
         ChangeThisSession > ZMaxPswdChanges AND _
         NOT ZSysop THEN _
             ZOutTxt$ = "No changes permitted" : _
             GOSUB 5142 : _
             EXIT SUB _
      ELSE CALL SrchPasswrds (Found) : _
           IF NOT Found THEN _
              GOTO 5129 _
           ELSE ZOutTxt$ = "Temporary change" : _
                GOSUB 5142 : _
                ZPswd$ = ZTempPassword$ : _
                ZSecsPerSession! = ZTempTimeAllowed * 60 : _
                ZUserSecLevel = ZTempSecLevel : _
                ZOutTxt$ = "Granted access level" + STR$(ZUserSecLevel) + _
                MID$(" (SYSOP)",1,-8 * (ZUserSecLevel >= ZSysopSecLevel)) : _
                GOSUB 5142 : _
                ZSysop = (ZUserSecLevel >= ZSysopSecLevel) : _
                CALL SetPrompt : _
                CALL XferType (2,ZTrue)
      IF ZActiveUserName$ = "SYSOP" THEN _
         ZUserIn$(1) = "********"
5126  CALL UpdtCalr ("Used temp password " + ZUserIn$,2)
      EXIT SUB
5129  IF ZOrigUserFile$ <> ZActiveUserFile$ THEN _
         CALL QuickTPut1 ("Please Quit Conference to change personal info") : _
         EXIT SUB
      ZSubParm = 6  ' LOCK USER BLOCK
      CALL FileLock
      CALL OpenUser (ZHighestUserRecord)
5130  IF ZUserFileIndex < 1 OR _
         ZUserFileIndex > 32767 THEN _
         ZErrCode=0 : _
         EXIT SUB
      GET 5,ZUserFileIndex
      CALL AllCaps (ZUserIn$)
      LSET ZPswd$ = ZUserIn$
      IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
         PUT 5,ZUserFileIndex
      ZSubParm = 8  ' UNLOCK USER BLOCK
      CALL FileLock
      ZOutTxt$ = "Password changed"
      ZStopInterrupts = ZTrue
      GOSUB 5142
      IF ZMaxPswdChanges THEN _
         ChangeThisSession = ChangeThisSession + 1
5131  CALL UpdtCalr ("New Password " + ZUserIn$(1),2)
      EXIT SUB
5140  CALL PopCmdStack
      GOTO 5152
5142  ZSubParm = 1
      GOTO 5146
5144  ZSubParm = 5
      GOTO 5146
5146  CALL TPut
5148  IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZSubParm = 8 THEN _
         GOSUB 5150
      RETURN
5150  GOSUB 5152
      ZSubParm = 1
      CALL TGet
5152  IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
      END SUB
'
'$SUBTITLE: 'JoinConference -- subroutine to join a conference'
' $PAGE
'
' NAME   : JoinConference
'
' PURPOSE: To join a conference.  Formerly in RBBS-PC.BAS.
'
' INPUTS :   ZJParm           1 - Join a conference
'                             2 - Join Main
'                             3 - 5301
'                             4 - 5350
'                             5 - News/Bulletin check
'                             6 - NewUser News/Bulletin check
'                             7 - compute days in registration
'                             8 - Check for Active User
'
' OUTPUTS:  ZJParm            1 - goto 202 on return to RBBS-PC.BAS
'                             2 - return 13600 in RBBS-PC.BAS
'                             3 - return 108 in RBBS-PC.BAS
'                             4 - return 852 in RBBS-PC.BAS
'                             5 - return 1205 in RBBS-PC.BAS
'                             6 - return 10595 in RBBS-PC.BAS
'
      SUB JoinConference (Found) STATIC
      Temp = 0
      Temp = ZJParm
      ZJParm = 0
      ON Temp GOSUB 5300,5323,5301,5350,5450,5451,5540,5460
      EXIT SUB
'
' ****  J - COMMAND FROM MAIN MENU (JOIN CONFERENCE)  ***
'
5300 WasA1$ = ZConfMenu$
     CALL BreakFileName (ZActiveMessageFile$,MsgDrvPath$,WasX$,ZWasY$,ZTrue)
     CALL Talk (12,ZOutTxt$)
5301 ZStackC = ZTrue
     CALL SubMenu ("Join what, L)ist M)ain N)ext, all/mail S)ince P)ers, or name ([Q]uit)",_
          WasA1$,MsgDrvPath$,"M.DEF",",M,MAIN,N,S,P,Q,", _
          ZTrue,ZFalse,ZFalse,"C.DEF",WasX,ZFalse)
     IF ZWasQ = 0 THEN _
        RETURN
     IF NOT ZSysOp THEN _
        ZActiveUserName$ = ZOrigUserNameDGS$ : _
        ZFirstName$ = OrigFirstName$
     IF ZSubParm = -1 THEN _
        ZJParm = 6 : _
        RETURN
5323 IF ZWasZ$ = "MAIN" THEN _
        ZWasZ$ = "M"
     WasX = (ZWasZ$ = "M")
     IF ZWasZ$ = ConfNameSave$ OR (WasX AND ZConfName$ = "MAIN") THEN _
        CALL QuickTPut1 ("You are already in " + ZConfName$) : _
        RETURN
     IF ZUserIn$(ZAnsIndex+1) = "!" AND ZAnsIndex < ZLastIndex THEN _
        ZTurboLogon = ZTrue : _
        ZAnsIndex = ZAnsIndex + 1
     ON INSTR("MNSPQ",ZWasZ$) GOTO 5350,5410,5415,5425,5532
     IF NOT ZOK THEN _
        GOTO 5300
     CLOSE 2
'
' ****  UPDATE PREVIOUS MESSAGE BASE CHECKPOINT RECORD  ***
'
5324 PrevConfName$ = ZConfName$
     ZConfName$ = ZWasZ$
     ZConfFileName$ = ZConfName$
     PrevMsg$ = ZActiveMessageFile$
     ZActiveMessageFile$ = ZFileName$
     GOSUB 5343
'
' ****  UPDATE PREVIOUS USER RECORD  ***
'
5325 GOSUB 5380
'
' *****  CHECK WHETHER HAVE SUBBOARD (I.E. CONFIG.DEF EXISTS)  ****
'
5327 UserRecordHold$ = ZUserRecord$
     ConfModeSave = ZConfMode
     ZConfMode = ZTrue
     PrevUser$ = ZActiveUserFile$
     PrevIndex = ZUserFileIndex
     PrevMainUser$ = ZMainUserFile$
     PrevUSL = ZUserSecLevel
     PrevDef$ = ZCurDef$
5328 WasX$ = ZConfName$ + _
          "C.DEF"
     CALL FindIt (WasX$)
     ZSubBoard = ZOK
     PrevConfMenu$ = ZConfMenu$
     IF NOT ZSubBoard THEN _
        CALL BreakFileName (ZMainMsgFile$,MsgDrvPath$,ZWasDF$,ZWasY$,ZTrue) : _
        WasX$ = MsgDrvPath$ + WasX$ : _
        CALL FindIt (WasX$) : _
        ZSubBoard = ZOK
     IF ZSubBoard THEN _
        IF LEN(ZConfName$) = 6 THEN _
           IF LEFT$(ZConfName$,4) = "RBBS" AND RIGHT$(ZConfName$,1) = "P" THEN _
              ZSubBoard = ZFalse
     IF NOT ZSubBoard THEN
        GOSUB 5435
        ZFileName$ = ZWelcomeFileDrvPath$ + ZConfName$ + "W.DEF"
     ELSE
        CALL ReadDef (WasX$)
        IF ZErrCode > 0 THEN
           CALL UpdtCalr ("Error"+STR$(ZErrCode)+" reading config file "+WasX$,2)
           ZErrCode = 0
           ZInConfMenu = ZFalse
           ZOutTxt$ = "error reading subboard"
           GOTO 5341
        ELSE
           WasX$ = ZMainUserFile$
           ZFileName$ = ""
           CALL FindIt (ZMainMsgFile$)
           IF NOT ZOK THEN
              ZOutTxt$ = "msg file missing for"
              ZInConfMenu = ZFalse
              GOTO 5341
           ELSE
              ZActiveMessageFile$ = ZMainMsgFile$
              GOSUB 5343
           END IF
        END IF
     END IF
     UpdateDate = ZTrue
     CALL FindIt (WasX$)
     IF ZOK THEN _
        GOTO 5330
'
' *****  NO USER FILE - A PUBLIC CONFERENCE   ****
'
     ZMainUserFile$ = PrevMainUser$
     IF (ZUserSecLevel < ZAutoAddSec) THEN _
        GOTO 5340
     GOTO 5345
'
' ****  CHECK CONFERENCE USER'S FILE  ***
'
5330 ZActiveUserFile$ = WasX$
     IF ZMainUserFileIndex < 1 THEN _
        Found = ZFalse : _
        ZUserFileIndex = 0 : _
        GOTO 5335
     IF ZSubBoard THEN _
        CALL WordInFile (PrevConfMenu$,ZConfName$,ZInConfMenu) _
     ELSE CALL WordInFile (ZConfMenu$,ZConfName$,ZInConfMenu)
     IF ZActiveUserName$ = "SYSOP" THEN _
        TempHashValue$ = ZOrigUserName$
     GOSUB 5460
     GOSUB 5500
     IF ZJParm = 1 THEN _
        RETURN
5335 IF Found THEN
        GOSUB 5445
        ZMainUserFileIndex = -(ZSubBoard * ZUserFileIndex) _
                               -((NOT ZSubBoard) * ZMainUserFileIndex)
        Temp = -(ZSubBoard * ZMinLogonSec) _
               -((NOT ZSubBoard) * ZAutoAddSec)
        CALL SetPrivileges
        ZErrCode = 0
        GOSUB 5430
        WasI = (ZUserSecLevel < ZOrigMainSec)
        WasJ = (ZUserSecLevel < Temp)
        WasK = (WasI AND WasJ)
        IF WasK THEN
           ZOutTxt$ = "you have been locked out of"
           GOTO 5341
        ELSE
           CALL BreakFileName (ZActiveUserFile$,Drive$,WasX$,WasY$,ZTrue)
           CALL ChkBanned(Drive$+WasX$,ZBlocked)
           IF ZBlocked = 1 THEN _
              ZOutTxt$ = "you have been locked out of" : _
              GOTO 5341
           GOSUB 5375
           GOTO 5345                ' successful join
        END IF
     END IF
'
' **** USER NOT FOUND.  AUTO-ADD TO SUBBOARD IF SUFFICIENT SECURITY ***
'
     ZNewUser = ZTrue
     IF ZSubBoard THEN _
        ZAutoAddSec = ZMinLogonSec
     IF (ZOrigSec >= ZAutoAddSec) AND _
            (ZUserFileIndex > 0) AND (ZMainUserFileIndex > 0) THEN _
        LSET ZUserRecord$ = UserRecordHold$ : _
        CALL QuickTPut1 ("MEMBER privileges granted in " + ZConfName$) : _
        MID$(ZUserOption$,3,2) = MKI$(0) : _
        MID$(ZUserOption$,1,2) = MKI$(0) : _
        ZActiveUserName$ = LEFT$(UserRecordHold$,30) : _
        CALL Trim (ZActiveUserName$) : _
        Temp = -(ZSubBoard * ZDefaultSecLevel) _
               -((NOT ZSubBoard) * ZUserSecSave) : _
        CALL SetSysOp : _
        Temp = -(ZWasA * ZSysopSecLevel) - ((NOT ZWasA) * Temp) : _
        LSET ZSecLevel$ = MKI$(Temp) : _
        ZUserSecLevel = Temp : _
        GOSUB 5375 : _
        ZPageLength = ZPageLengthDef : _
        GOSUB 5504 : _
        GOSUB 5475 : _
        UpdateDate = ZTrue : _
        Found = ZTrue : _
        GOTO 5335
     IF ZOrigSec >= ZAutoAddSec THEN _
        CALL QuickTPut1 ("GUEST privileges granted in " + ZConfName$) : _
        ZActiveUserFile$ = PrevUser$ : _
        UpdateDate = ZFalse : _
        ZUserFileIndex = PrevIndex : _
        GOSUB 5382 : _
        ZUserFileIndex = 0 : _
        GOTO 5345                ' successful join
     ZNewUser = ZFalse
5340 IF ZInConfMenu THEN _
        ZOutTxt$ = "insufficient security for" _
     ELSE ZOutTxt$ = "no such option"

5341 ZOutTxt$ = ZFGE$ + ZOutTxt$ + " - " + ZFGA$ + ZConfName$
'
' ****  CANNOT JOIN THE REQUESTED CONFERENCE.  THEREFORE, GO BACK  ***
'
     ZOutTxt$ = ZFG1$ + "Sorry " + ZFirstName$ + ", " + _
                ZOutTxt$ + ZEmphasizeOff$
     GOSUB 5485                            ' tput
     IF NOT ZExpertUser THEN _
        CALL SkipLine(1) : _
        CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
     ZConfName$ = PrevConfName$
     ZConfFileName$ = ZConfName$
     IF ZSubBoard THEN _
        CALL ReadDef (PrevDef$)
     ZActiveMessageFile$ = PrevMsg$
     GOSUB 5343
     ZUserFileIndex = PrevIndex
     ZActiveUserFile$ = PrevUser$
     GOSUB 5382
     ZConfMode = ConfModeSave
     GOSUB 5506
     ZAnsIndex = 0
     ZLastIndex = 0
     GOTO 5301
'
' ****  RESTORE A MESSAGE BASE   ***
'
5343 GOSUB 5344
     CALL GetMessageHdr
     RETURN
'
' *****  OPEN AND SETUP MESSAGE BASE  *****
'
5344 CALL OpenMsg
     IF ZErrCode = 64 THEN _
        ZErrCode = 0 : _
        GOTO 5350
     FIELD 1, 128 AS ZMsgRec$
     RETURN
'
' *****  SUCCESSFUL CONFERENCE JOIN  ****
'
5345 DGSStl$ = ""
     WHILE DGSAlias$ = ""
        Call AliasDGS (ZConfName$,ZOrigUserNameDGS$,DGSAlias$, _
                       DGSStl$,DGSFileName$)
     WEND
     DGSAlias$ = ""
     ZNewsFileName$ = ZWelcomeFileDrvPath$ + ZConfName$ + ".NWS"
     CALL FindFile (MsgDrvPath$ + ZConfName$ + "N.DEF",ZNetConference)
     CALL FindFile (MsgDrvPath$ + ZConfName$ + "I.DEF",ZIConference)
     CALL DeLink (ZConfName$)
     ConfNameSave$ = ZConfName$
     ZConfName$ = ZConfName$ + " " + MID$("ConferenceSubboard",1-10*ZSubBoard,10)
     IF ZGlobalSysop THEN _
        ZActiveUserName$ = "SYSOP"
     ZMarkedMsgs$ = ""
     ZTurboBase = ZFalse
     ZPrevBase$ = ""
5347 CALL UpdtCalr ("Entered " + ZConfName$,3)
     CALL QuickTPut1 ("Welcome to " + ZConfName$)
     IF NOT ZTurboLogon THEN _
        CALL InitWelc (2)
     GOSUB 5455
5348 GOSUB 5506
     GOSUB 5512
     ZBoardCheckDate$ = LEFT$("00-00-00",-ZNewUser*8) + _
                       LEFT$(ZLastDateTimeOn$,-(NOT ZNewUser)*8)
     IF ZSubBoard THEN _
        ZHasDoored = ZFalse : _
        ZActiveFMSDir$ = "" : _
        ZTimeLoggedOn$ = TIME$ : _
        ZJParm = 3 : _
        RETURN
     ZNewUser = ZFalse
     IF ZLastMsgRead > ZHighMsgNumber THEN _
        ZLastMsgRead = 0 : _
        MID$(ZUserOption$,3,2) = MKI$(0)
     IF UpdateDate THEN _
        ZTimeLoggedOn$ = TIME$ : _
        LSET ZLastDateTimeOn$ = ZCurDate$ + _
                                  " " + _
                                  ZTimeLoggedOn$ : _
     IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
        PUT 5,ZUserFileIndex
        GOSUB 5514
     IF PrevUSL <> ZUserSecLevel THEN _
        CALL SetPrompt
     GOSUB 5450
     ZJParm = 4
     RETURN
'
' ****  JOIN M)AIN   ***
'
5350 IF ZConfName$ <> "MAIN" THEN _
        CALL QuickTPut1 ("Rejoining " + ZOrigMsgName$)
     ZActiveUserName$ = ZOrigUserNameDGS$
     ZFirstName$ = OrigFirstName$
     CALL DeLink (ZConfName$)
     ZConfFileName$ = ZOrigMsgName$
     ZNewsFileName$ = ZOrigNewsFileName$
     ZTurboLogon = ZTrue
     ZMarkedMsgs$ = ""
     ZWasQ = 0
     ZNewUser = ZFalse
     ZInConfMenu = ZTrue
     IF ZActiveUserName$ = "SYSOP" THEN _
        ZActiveUserName$ = ZSecretName$ : _
        CALL Trim (ZActiveUserName$)
     ZConfigFileName$ = ZOrigCnfg$
     CALL ReadDef (ZConfigFileName$)
     IF ZOrigMsgFile$ <> ZActiveMessageFile$ THEN _
        ZActiveMessageFile$ = ZOrigMsgFile$ : _
        GOSUB 5343
     IF ZOrigUserFile$ <> ZActiveUserFile$ THEN _
        GOSUB 5380 : _
        ZActiveUserFile$ = ZOrigUserFile$ : _
        ZActiveUserName$ = ZOrigUserName$ : _
        GOSUB 5460 : _
        GOSUB 5512 : _
        IF Found THEN _
           GOSUB 5445 : _
           ZMainUserFileIndex = ZUserFileIndex : _
           CALL SetPrompt : _
           CALL XferType (2,ZTrue) _
        ELSE ZUserFileIndex = 0 : _
             ZMainUserFileIndex = 0
     CALL UpdtCalr ("Exited " + ZConfName$,3)
     ZConfName$ = "MAIN"
     ConfNameSave$ = ZConfName$
     ZNetConference = ZFalse
     ZIConference = ZFalse
     IF ZCurPUI$ = "" OR ZSubBoard THEN _
        ZCurPUI$ = ZMainPUI$
     CALL FindIt (ZCurPUI$)
     ZCustomPUI = ZOK
     IF NOT ZOK THEN _
        ZCurPUI$ = ""
     ZPrevPUI$ = ""
     ZUplds = ZGlobalUplds
     ZDnlds = ZGlobalDnlds
     ZDLToday! = ZGlobalDLToday!
     ZBytesToday! = ZGlobalBytesToday!
     ZDLBytes! = ZGlobalDLBytes!
     ZULBytes! = ZGlobalULBytes!
     ZDropTimes = ZGlobalDropTimes
     ZBankTime = ZGlobalBankTime
5360 ZConfMode = ZFalse
     ZBoardCheckDate$ = ZLastDateTimeOn$
     ZSubBoard = ZTrue
     GOSUB 5506
     ZJParm = 3
     RETURN
5375 IF ((ZUserSecLevel < ZAutoUpgradeSec) AND ZSubBoard) OR _
        ((ZUserSecLevel < ZOrigUpgradeSec) AND NOT ZSubBoard) THEN _
           IF ZUserSecLevel <> ZOrigSec THEN _
              ZUserSecLevel = ZOrigSec : _
              LSET ZSecLevel$ = MKI$(ZUserSecLevel)
     RETURN
'
' *****  UPDATE CURRENT USERS RECORD  ****
'
5380 IF ZUserFileIndex < 1 THEN _
        RETURN
     IF ZAdjustedSecurity AND NOT ZSysop THEN _
        LSET ZSecLevel$ = MKI$(ZUserSecLevel) : _
        ZUserSecSave = ZUserSecLevel
     IF ZSubBoard THEN _
        ZActiveUserName$ = ZOrigUserNameDGS$ : _
        ZFirstName$ = OrigFirstName$
     CALL UpdateU (ZFalse)
     RETURN
'
' *****  RESTORE A USER RECORD  ****
'
5382 IF ZUserFileIndex < 1 THEN _
        ZUserSecLevel = ZDefaultSecLevel : _
        RETURN
     CALL OpenUser (ZHighestUserRecord)
     GET 5,ZUserFileIndex
     GOSUB 5445
     RETURN
5410 CALL NextConf (ZTrue)
     IF ZHomeConf$ <> "" THEN _
        ZConfMailJoin = ZTrue : _
        ZJParm = 5 : _
        RETURN
     IF ZLinkedConf$ = "" THEN _
        CALL QuickTPut1("No conferences linked")
     GOTO 5301
5415 ZLinkNew = ZTrue
5420 CALL ConfMail (ZMailCheckConfirm,ZLinkNew,ZLinkPers)
     ZConfMailJoin = (ZHomeConf$ <> "")
     GOTO 5410
5425 ZLinkPers = ZTrue
     GOTO 5420
5430 IF ZSubBoard THEN _
        GOSUB 5540
     RETURN
5435 CALL BreakFileName (ZActiveMsgFile$,UserDrvPath$,ZWasDF$,ZWasY$,ZTrue)
     WasX$ = UserDrvPath$ + _
             ZConfName$ + _
             "U.DEF"
     CALL FindIt (WasX$)
     IF NOT ZOK THEN _
        CALL BreakFileName (ZActiveUserFile$,UserDrvPath$,ZWasDF$,ZWasY$,ZTrue) : _
        WasX$ = UserDrvPath$ + _
                ZConfName$ + _
                "U.DEF"
     RETURN
5440 IF LOF(5) < 1 THEN _
        ZWasDF$ = ZActiveUserFile$ : _
        ZJParm = 2 : _
        RETURN
     FIELD 5,31 AS ZUserName$, _
             15 AS ZPswd$, _
              2 AS ZSecLevel$, _
             14 AS ZUserOption$,  _
             24 AS ZCityState$, _
              1 AS MachineType$, _
              1 AS ZDropTimes$, _
              1 AS ZBankTime$,_
              4 AS ZTodayDl$, _
              4 AS ZTodayBytes$, _
              4 AS ZDlBytes$, _
              4 AS ZULBytes$, _
             14 AS ZLastDateTimeOn$, _
              3 AS ZListNewDate$, _
              2 AS ZUserDnlds$, _
              2 AS ZUserUplds$, _
              2 AS ZElapsedTime$
     FIELD 5,128 AS ZUserRecord$
     RETURN
'
' * GET USER DEFAULTS
'
5445 GOSUB 5440
     CALL SetSysOp
     CALL SetUserPref
     RETURN
5450 NewsDate# = VAL(MID$(ZBoardCheckDate$,4,2)) + _
        (100 * VAL(MID$(ZBoardCheckDate$,1,2))) + _
        (10000# * (1900 + VAL(MID$(ZBoardCheckDate$,7,2))))
     GOTO 5452
5451 NewsDate# = 0
5452 ZFileName$ = ZNewsFileName$
     CALL RBBSFind (ZFileName$,WasZ,WasY,ZMsgPtr,WasD)
     IF WasZ <> 0 THEN _
        RETURN
     FDate# = WasD + (100 * ZMsgPtr) + (10000# * (WasY + 1980))
     IF NewsDate# > FDate# THEN _
        RETURN
     IF ZTurboLogon THEN _
        CALL QuickTPut1(ZFGF$ + "NEWS" + ZFGB$ + " file updated since last call" + ZEmphasizeOff$) : _
        RETURN
     ZStopInterrupts = ZFalse
     CALL InitWelc (2)
     WasZ = 0
     RETURN
5455 GOSUB 5504
     GOSUB 5344
     IF LOF(1) = 0 THEN _
        ZWasDF$ = ZActiveMessageFile$ : _
        CLOSE 1 : _
        KILL ZActiveMessageFile$ : _
        GOSUB 5506 : _
        ZJParm = 2 : _
        RETURN
     CALL GetMessageHdr
     RETURN
5460  TempHashValue$ = ZHashValue$
      TempIndivValue$ = ZIndivValue$
5465  GOSUB 5455
      GOSUB 5508
      IF ZInConfMenu THEN _
         IF NOT ZPrivateDoor THEN _
            CALL QuickTPut1 ("Checking Users...")
5470  CALL OpenUser (ZHighestUserRecord)
      GOSUB 5440
      CALL FindUser (TempHashValue$,TempIndivValue$,ZStartHash,ZLenHash,_
                     ZStartIndiv,ZLenIndiv,ZHighestUserRecord,Found,_
                     ZUserFileIndex,ZWasSL)
     IF Found THEN _
        RETURN
     IF ZCurUserCount < (ZHighestUserRecord-1)*.95 THEN _
        RETURN
     ZOutTxt$ = "No room for new users in " + ZConfName$
     CALL UpdtCalr (ZOutTxt$,2)
     IF ZActiveUserFile$ <> ZMainUserFile$ THEN _
        ZUserFileIndex = 0 : _
        RETURN
      IF ZRememberNewUsers AND NOT ZSurviveNoUserRoom THEN _
         ZOutTxt$ = "Sorry, " + ZFirstName$ + ", " + ZOutTxt$ : _
         GOSUB 5485
      ZUserFileIndex = 0
      IF ZSurviveNoUserRoom THEN _
         ZRememberNewUsers = ZFalse
      RETURN
5475  CALL GetMessageHdr
      ZCurUserCount = ZCurUserCount + (ZWasSL = 0) * ZRememberNewUsers
5480  CALL UpdtMessageHdr
      GOSUB 5502
      IF ZRememberNewUsers THEN _
         GOSUB 5510
      GOSUB 5512
      RETURN
5485  ZSubParm = 2
      GOTO 5490
5490  CALL TPut
5495  IF ZSubParm < 0 THEN _
         ZJParm = 1 : _
         RETURN
      IF ZSubParm = 8 THEN _
         GOSUB 5524
      RETURN
5500  ZSubParm = 1  ' LOCK USERS & MESSAGES
      GOTO 5522
5502  ZSubParm = 2  ' UNLOCK MESSAGES AND FLUSH
      Flushed = ZTrue
      GOTO 5522
5504  ZSubParm = 3  ' LOCK MESSAGES
      GOTO 5522
5506  ZSubParm = 4  ' UNLOCK MESSAGES
      GOTO 5522
5508  ZSubParm = 5  ' LOCK USERS
      GOTO 5522
5510  ZSubParm = 6  ' LOCK USER BLOCK
      GOTO 5522
5512  ZSubParm = 7  ' UNLOCK USERS
      GOTO 5522
5514  ZSubParm = 8  ' UNLOCK USER BLOCK
      GOTO 5522
5522  CALL FileLock
      IF Flushed THEN _
         FIELD 1,128 AS ZMsgRec$ : _
         Flushed = ZFalse
      IF ZSubParm = -1 THEN _
         ZSubParm = -9 : _
         CALL FindFKey : _
         ZJParm = 1 : _
         RETURN
      RETURN
5524  GOSUB 5530
      ZSubParm = 1
5526  CALL TGet
5530  IF ZSubParm < 0 THEN _
         ZJParm = 1 : _
         RETURN
5532  RETURN
5540 IF ZRestrictByDate AND ZDaysInRegPeriod > 0 THEN _
        CALL CompDate (ZUserRegYY,ZUserRegMM,ZUserRegDD,UserComputeDate!) : _
        ZRegDaysRemaining = UserComputeDate! + _
                             ZDaysInRegPeriod - _
                             ZTodayComputeDate! : _
        CALL ExpireDate (UserComputeDate!,ZDaysInRegPeriod,ZExpirationDate$) _
     ELSE ZDaysInRegPeriod = 0
     IF NOT ZPrivateDoor THEN _
        IF ZRegDaysRemaining < 0 AND ZDaysInRegPeriod > 0 THEN _
        IF ZUserSecLevel > ZTempExpiredSec THEN _
           CALL QuickTPut1 (ZWasLG$(9) + _
                       " - security level set to" + _
                       STR$(ZTempExpiredSec)) : _
           ZFileName$ = ZHelpPath$ + "RGXPIRD" + ZHelpExtension$ : _
           CALL Graphic (ZFileName$,ZTrue) : _
           ZStopInterrupts = ZTrue : _
           CALL BufFile (ZFileName$,WasX,ZFalse) : _
           ZStopInterrupts = ZFalse : _
           CALL DelayTime (5) : _
           ZLogonErrorIndex = 9 : _
           ZUserSecLevel = ZTempExpiredSec : _
           LSET ZSecLevel$ = MKI$(ZUserSecLevel) : _
           CALL SetPrivileges : _
           ZErrCode = 0
     RETURN
     END SUB
'
'$SUBTITLE: 'UserMaint -- subroutine for user Maintenance'
' $PAGE
'
' NAME: UserMaint
'
' PURPOSE: User maintenance routine.  Formerly in RBBS-PC.BAS
'
' INPUTS :  EditFromRead      EDIT USER RECORD FROM MSG BASE
'           TempHashValue$    HASH VALUE OF USER
'
' OUTPUTS:  ReturnRead        WHETHER TO RETURN TO MSG SYSTEM
'
'
      SUB UserMaint (EditFromRead, TempHashValue$, ReturnRead)
      ReturnRead = ZFalse
11000 WasTU = ZUserFileIndex
      CALL DefaultU
      UserRecordHold$ = ZUserRecord$
      RegDateHold$ = ZRegDate$
      UserSecLevelSave = ZUserSecLevel
11001 ZStopInterrupts = ZTrue
      WasI = 1
      ScanUsers = ZFalse
      IF EditFromRead = 1 THEN _
         GOTO 11341
      ZOutTxt$ = "A)dd, L)st, P)rt, M)od, S)can users"
      GOSUB 13110
11003 IF ZWasQ = 0 THEN _
         IF EditFromRead > 0 THEN _
            GOTO 11325 _
         ELSE _
            ZUserFileIndex = WasTU : _
            LSET ZUserRecord$ = UserRecordHold$ : _
            GOSUB 13100 : _
            CALL SetSysOp : _
            CALL SetUserPref : _
            EXIT SUB
      WasQQ = 0
      ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
      CALL AllCaps (ZWasZ$)
      IF ZWasZ$ = "A" THEN _
         GOTO 12300 _
      ELSE IF ZWasZ$ = "M" THEN _
              ZStopInterrupts = ZTrue _
           ELSE IF ZWasZ$ = "P" THEN _
                   WasQQ = ZTrue _
                ELSE IF ZWasZ$ = "S" THEN _
                        ScanUsers = ZTrue : _
                        ZStopInterrupts = ZTrue _
                     ELSE IF ZWasZ$ <> "L" THEN _
                             GOTO 11001
11005 CALL OpenUser (ZHighestUserRecord)
      GOSUB 13100
      WasZ = 1
      IF ScanUsers THEN _
         ZOutTxt$ = "Scan for N)ame, P)wd, C)" + ZUserLocation$ + ", L)evel" + _
              LEFT$(", H)ash id",-9*(ZStartHash > 1 AND ZLenHash > 0)) : _
         GOSUB 13110 : _
         ZOutTxt$ = "" : _
         ScanFunction$ = LEFT$(ZUserIn$(1),1) : _
         CALL AllCaps (ScanFunction$) : _
         ZCR = 0 : _
         ZSubParm = 5 : _ ' cr/lf
         CALL TPut : _
         GOSUB 12966 : _
         GOTO 12962
11010 FOR WasJ = WasZ TO ZHighestUserRecord
         GET 5,WasJ
11015    CALL DispUserRec (WasQQ)
         IF NOT ZOK THEN _
            GOTO 11310
         IF ZRet <> 0 THEN _
           GOTO 11330
11107   IF NOT ZStopInterrupts THEN _
           GOTO 11310
11110   ZOutTxt$ = "D)el  F)ind  M)enu  N)ewPW  P)rnt  R)eset Grfx  C)" _
             + ZUserLocation$ + "  Q)uit"
        CALL TopPrompt
        ZOutTxt$ = "S)ecLvl  U)ser#  X)fer Cnts  T)ime Used  B)ank Acct  " + _
                   "!)Carrier Drops"
        CALL TopPrompt
        ZOutTxt$ = "#)Times on "
        IF ZRestrictByDate THEN _
           ZOutTxt$ = ZOutTxt$ + _
                " $)RegDate"
        GOSUB 13110                            ' popcmdstack
        IF NOT ScanUsers AND ZWasQ = 0 THEN _
           GOTO 11310
11115   ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
        CALL AllCaps (ZWasZ$)
        WasX = INSTR("DNPQFSMR$UXTBC!#",ZWasZ$)
        IF ZWasZ$ = "" AND ScanUsers THEN _
           GOTO 12965
        ON WasX GOTO 11130,11160,11220,11320,11340,11390,11330, _
                     11400,11450,11127,11490,11420,11423,11190, _
                     11424,11430
        GOTO 11110
11125   WasZ = VAL(ZUserIn$)
        IF WasZ < 1 OR WasZ > ZHighestUserRecord THEN _
           GOTO 11015
        GOTO 11010
11127   ZOutTxt$ = "What record # ([ENTER] Quits)"
        GOSUB 13115
        GOTO 11125
'
' *  D - COMMAND FROM 5- USER MAINTENANCE OPTIONS (DELETE USER)
'
11130   ZOutTxt$ = "Delete user (Y,[N])"
        GOSUB 13200
        IF ZYes THEN _
           LSET ZUserName$ = CHR$(0) + _
                             "deleted user" : _
           LSET ZSecLevel$ = MKI$(ZMinLogonSec - 1) : _
           LSET ZLastDateTimeOn$ = "01-01-80" + _
                                     " " + _
                                     ZTimeLoggedOn$
        GOTO 11290
'
' *  N - COMMAND FROM 5- USER MAINTENANCE OPTIONS (CHANGE USER PASSWORD)
'
11160   GOSUB 12800
        GOTO 11290
'
' *  P - COMMAND FROM 5- USER MAINTENANCE OPTIONS (PRINT USER FILE)
'
11185   CALL QuickTPut1 (ZUserLocation$ + " now " + ZWasCI$)
        WasA1$ = "Enter new "
        RETURN
11190 ' *** C - COMMAND FROM 5 - CHANGE CITY/STATE ***
        CityStateSave$ = ZWasCI$
        ZWasCI$ = ZCityState$
        CALL Trim (ZWasCI$)
        GOSUB 11185
        GOSUB 12960
        ZWasCI$ = CityStateSave$
        GOTO 11290
11220   WasQQ = NOT WasQQ
        GOTO 11015
11290   ZUserFileIndex = LOC(5)
        GOSUB 13230
        IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
           PUT 5,ZUserFileIndex
        GOSUB 13232
        ZUserFileIndex = 0
        GOTO 11015
11310   IF ScanUsers THEN _
           GOTO 12965
11311 NEXT
'
' *  Q - COMMAND FROM 5- USER MAINTENANCE OPTIONS (QUIT TO MAIN MENU)
'
11320 ZUserFileIndex = WasTU
      LSET ZUserRecord$ = UserRecordHold$
      ZRegDate$ = RegDateHold$
      IF EditFromRead > 0 THEN _
         GOTO 11325
      EXIT SUB
11325 ZReply = ZFalse
      JustReplied = ZTrue
      QuotedReply = ZTrue
      EditFromRead = 0
      CALL GetMsgAttr
      DontPrint = ZTrue
      ZUserIn$ = "="
      ReturnRead = ZTrue
      EXIT SUB
'
' *  M - COMMAND FROM 5- USER MAINTENANCE OPTIONS (MAIN USER MAINT. MENU)
'
11330 CLOSE 2
      IF EditFromRead > 0 THEN _
         EditFromRead = 2
      GOTO 11001
'
' *  F - COMMAND FROM 5- USER MAINTENANCE OPTIONS (FIND USER)
'
11340 ZOutTxt$ = ZPromptHash$ + _
           " to find.  ([ENTER] Quits)"
      CALL SkipLine (1)
      ZParseOff = ZTrue
      GOSUB 13115             ' popcmdstack
      IF ZWasQ = 0 THEN _
         GOTO 11015
      CALL Trim (ZUserIn$)
      TempHashValue$ = ZUserIn$
11341 IF LEN(TempHashValue$) < 2 OR LEN(TempHashValue$) > ZLenHash THEN _
         GOTO 11340
      CALL AllCaps (TempHashValue$)
      IF ZStartIndiv < 1 THEN _
         GOTO 11345
11342 ZOutTxt$ = ZPromptIndiv$ + _
           " to find"
      GOSUB 13200
      IF ZWasQ = 0 THEN _
         GOTO 11342
      TempIndivValue$ = ZUserIn$
      IF LEN(TempIndivValue$) > ZLenIndiv THEN _
         GOTO 11342
      CALL AllCaps (TempIndivValue$)
11345 GOSUB 12600                    ' open & lock user file, find user
      ZSubParm = 7  ' UNLOCK USERS
      GOSUB 13236
      ZSubParm = 4  ' UNLOCK MESSAGES
      GOSUB 13236
      ZUserFileIndex = 0
      IF Found THEN _
         GOTO 11015
11380 ZOutTxt$ = TempHashValue$ + _
           " " + _
           TempIndivValue$ + _
           " not found"
      ZSubParm = 3
      CALL TPut
      IF ZSubParm < 0 THEN _
         EXIT SUB
      GOTO 11310
'
' *  S - COMMAND FROM 5- USER MAINTENANCE OPTIONS (CHANGE USER SECURITY)
'
11390 GOSUB 11395
      IF ZWasQ > 0 THEN _
         LSET ZSecLevel$ = MKI$(WasOF)
      GOTO 11290
11395 ZOutTxt$ = "New sec level" + ZPressEnter$
      GOSUB 13115
      ZWasZ$ = ZUserIn$(ZAnsIndex)
      WasOF = VAL(ZWasZ$)
      IF WasOF > ZUserSecLevel THEN _
         WasOF = ZUserSecLevel
      RETURN
'
' *  R - COMMAND FROM 5- USER MAINTENANCE OPTIONS (RESET USER GRAPHICS)
'
11400 ZWasA = CVI(MID$(ZUserOption$,9,2))
      ZWasA = ZWasA AND &HFAFF                ' TURN HIGHLIGHTING OFF
      LSET ZUserOption$ = LEFT$(ZUserOption$,5) + _
                           "0" + _
                           MID$(ZUserOption$,7,2) + _
                           MKI$(ZWasA) + _
                           MID$(ZUserOption$,11)
      GOTO 11290
11420        ' * T - COMMAND FROM 5 - TIME USED
      Temp = CVI (ZElapsedTime$)
      CALL ChangeInt (ZTrue,"Time Used",Temp,-21900,2000)
      IF ZWasQ <> 0 THEN _
         LSET ZElapsedTime$ = MKI$(ZTestedIntValue)
      GOTO 11290
11423        ' * B - COMMAND FROM 5 - BANKED TIME
      Temp = ASC(ZBankTime$)
      CALL ChangeInt (ZTrue,"Banked Time",Temp,0,255)
      IF ZWasQ <> 0 THEN _
         LSET ZBankTime$ = CHR$(ZTestedIntValue)
      GOTO 11290
11424        ' * ! - COMMAND FROM 5 - DROPPED CARRIERS
      Temp = ASC(ZDropTimes$)
      CALL ChangeInt (ZTrue,"Dropped Carriers",Temp,0,255)
      IF ZWasQ <> 0 THEN _
         LSET ZDropTimes$ = CHR$(ZTestedIntValue)
      GOTO 11290
11430        ' * # - COMMAND FROM 5 - NUMBER OF LOG ONS
      Temp = CVI(MID$(ZUserOption$,1,2))
      CALL ChangeInt (ZTrue,"Times On",Temp,0,32000)
      IF ZWasQ <> 0 THEN _
         LSET ZUserOption$ = MKI$(ZTestedIntValue) + MID$(ZUserOption$,3)
      GOTO 11290

'
' *  $ - COMMAND FROM 5 - USER MAINTENANCE (CHANGE REGISTRATION DATE)
'
11450 ZOutTxt$ = "Enter new registration date (MM-DD-YY)"
      GOSUB 13115
      IF ZWasQ = 0 THEN _
         GOTO 11015
11455 WorkDate$ = ZUserIn$(ZAnsIndex)
      IF LEN(WorkDate$) < 8 THEN _
         GOTO 11450
      CALL ResetRegDate (WorkDate$)
      IF NOT ZOK THEN _
         GOTO 11450
      LSET ZUserOption$ = LEFT$(ZUserOption$,10) + _
                           ZRegDate$ + _
                           MID$(ZUserOption$,13)
      CALL SetRegDisplay
      ZRegDate$ = RegDateHold$
      GOTO 11290
'
' *  X - COMMAND FROM 5 - USER MAINTENANCE (CHANGE XFER COUNTERS)             *
'
11490 CALL CmndSysOpXfer
      GOTO 11290
'
' *  A - COMMAND FROM 5- USER MAINTENANCE OPTIONS (ADD USER)
'
12300 WasA1$ = ""
      Attempts = 0
      FirstNameSave$ = ZFirstName$
      LastNameSave$ = ZLastName$
      ActiveUserNameSave$ = ZActiveUserName$
      CityStateSave$ = ZWasCI$
      HashValueSave$ = HashValue$
      IndivValueSave$ = ZIndivValue$
      GOSUB 12500
      GOSUB 12840
      GOSUB 12850
      GOSUB 12598
      IF ZUserFileIndex = 0 THEN _
         ZSubParm = 1 : _  ' LOCK USERS & MESSAGES
         GOSUB 13236 : _
         GOTO 12330
      IF Found THEN _
         WasD$ = "User already exists" : _
         NumReturns = 1 : _
         CALL LPrnt(WasD$,NumReturns) : _
         ZSubParm = 1 : _  ' LOCK USERS & MESSAGES
         GOSUB 13236 : _
         GOTO 12330
12310 GOSUB 12630
      GOSUB 12800
12311 GOSUB 11395
      IF ZWasQ = 0 THEN GOTO 12311
      ZTempSecLevel = WasOF
      CALL SetNewUserDef
      LSET ZLastDateTimeOn$ = ZCurDate$ + _
                                " " + _
                                ZTimeLoggedOn$
      GOSUB 12960
      CALL AllCaps (ZUserIn$)
      LSET ZCityState$ = ZUserIn$
      LSET ZElapsedTime$ = MKI$(0)
      IF ZStartHash > 1 THEN _
         MID$(ZUserRecord$,ZStartHash,ZLenHash) = HashValue$
      IF ZStartIndiv > 1 THEN _
         MID$(ZUserRecord$,ZStartIndiv,ZLenIndiv) = ZIndivValue$
     IF ZUserFileIndex > 0 AND ZUserFileIndex < 32768 THEN _
        PUT 5,ZUserFileIndex
12320 GOSUB 13232
12330 ZUserSecLevel = UserSecLevelSave
      ZFirstName$ = FirstNameSave$
      ZLastName$ = LastNameSave$
      ZActiveUserName$ = ActiveUserNameSave$
      ZWasCI$ = CityStateSave$
      HashValue$ = HashValueSave$
      ZIndivValue$ = IndivValueSave$
      ZUserFileIndex = WasTU
      LSET ZUserRecord$ = UserRecordHold$
      GOTO 11001
'
' *  GET USER First AND Last NAMES
'
12500 IF Attempts > 5 THEN _
         ZFF = ZTrue : _
         RETURN
12510 Attempts = Attempts + 1
      ZOutTxt$ = WasA1$ + _
           ZFirstNamePrompt$
      CALL SkipLine (1)
      ZLogonActive = ZTrue
      GOSUB 12555
      ZLogonActive = ZFalse
      CALL Trim (ZWasZ$)
      ZFirstName$ = ZWasZ$
12530 ZOutTxt$ = WasA1$ + _
           ZLastNamePrompt$
      ZParseOff = ZTrue
      GOSUB 12555
12540 CALL Trim (ZWasZ$)
      ZLastName$ = ZWasZ$
      IF LEN(ZLastName$) < 2 THEN _
         IF LEN(ZFirstName$) > 2 THEN _
            GOTO 12500
      IF (LEN(ZFirstName$) + LEN(ZLastName$)) > 30 THEN _
         GOTO 12500
      IF UserSecLevelSave < ZSysopSecLevel THEN _
         IF (LEN(ZFirstName$) < 2 OR LEN(ZLastName$) < 2) THEN _
            GOTO 12500 _
         ELSE IF LEFT$(ZFirstName$,1)=" " OR LEFT$(ZLastName$,1)=" " THEN _
                 GOTO 12500
12550 ZActiveUserName$ = MID$(ZFirstName$ + " " + ZLastName$,1,31)
      ZWasZ$ = ZFirstName$
      RETURN
'
' *  CHECK FOR NAMES NOT ALLOWED
'
12555 GOSUB 13115
      IF ZWasQ = 0 THEN _
         RETURN
12556 ZWasZ$ = ZUserIn$(ZAnsIndex)
12557 CALL AllCaps (ZWasZ$)
      CALL RemNonAlf (ZWasZ$,31,91)
      RETURN
'
' *   SEARCH USER FILE ROUTINE
'
12598 TempHashValue$ = HashValue$
      TempIndivValue$ = ZIndivValue$
12600 ZSubParm = 3  ' LOCK MESSAGES
      GOSUB 13236
      CALL OpenMsg
      FIELD 1, 128 AS ZMsgRec$
      CALL GetMessageHdr
      ZSubParm = 5  ' LOCK USERS
      GOSUB 13236
12605 CALL OpenUser (ZHighestUserRecord)
      GOSUB 13100
      CALL FindUser (TempHashValue$,TempIndivValue$,ZStartHash,ZLenHash,_
                     ZStartIndiv,ZLenIndiv,ZHighestUserRecord,Found,_
                     ZUserFileIndex,ZWasSL)
      IF Found THEN _
         RETURN
      IF ZCurUserCount < (ZHighestUserRecord-1)*.95 THEN _
         RETURN
      ZOutTxt$ = "No room for new users in " + ZConfName$
      IF ZActiveUserFile$ <> ZMainUserFile$ THEN _
         ZUserFileIndex = 0 : _
         RETURN
      IF ZRememberNewUsers AND NOT ZSurviveNoUserRoom THEN _
         ZOutTxt$ = "Sorry, " + ZFirstName$ + ", " + ZOutTxt$ : _
         ZSubParm = 1 : _
         CALL TPut : _
         IF ZSubParm < 0 THEN _
            EXIT SUB
      ZUserFileIndex = 0
      IF ZSurviveNoUserRoom THEN _
          ZRememberNewUsers = ZFalse
      RETURN
'
' *  AUGMENT USER COUNT, LOCK 4 REC BLOCK IN USER, UNLOCK FILES
'
12630 CALL GetMessageHdr
      ZCurUserCount = ZCurUserCount + (ZWasSL = 0) * ZRememberNewUsers
12632 CALL UpdtMessageHdr
      ZSubParm = 2  ' UNLOCK MESSAGES AND FLUSH
      Flushed = ZTrue
      GOSUB 13236
      IF ZRememberNewUsers THEN _
         ZSubParm = 6 : _  ' LOCK USER BLOCK
         GOSUB 13236
      ZSubParm = 7  ' UNLOCK USERS
      GOSUB 13236
      RETURN
'
' *  GET PASSWORD FROM NEWUSER
'
12800 CALL NewPassword ("Enter PASSWORD you'll use to logon again",ZFalse)
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF UserSecLevelSave < ZSysopSecLevel THEN _
         IF ZUserIn$ = SPACE$(LEN(ZUserIn$)) THEN _
            GOTO 12800
      LSET ZPswd$ = ZWasZ$
      RETURN
'
' *  GET HASH VALUE FOR CURRENT USER TO LOOK UP IN THE USER'S FILE
'
12840 IF ZStartHash = 1 THEN _
         HashValue$ = ZActiveUserName$ : _
         RETURN
      WasX$ = WasA1$ + _
           ZPromptHash$
      CALL UntilRight (WasX$,HashValue$,2,ZLenHash)
      RETURN
'
' *  GET FIELD TO INDIVIDUATE ONE USER FROM ANOTHER (NAME FIELD IS DEFAULT)
'
12850 IF ZStartIndiv < 1 OR ZLenIndiv < 1 THEN _
         RETURN
      IF ZStartIndiv = 1 THEN _
         ZIndivValue$ = ZActiveUserName$ : _
         RETURN
      IF ZExitToDoors THEN _
         RETURN
      WasX$ = WasA1$ + _
           ZPromptIndiv$
      CALL UntilRight (WasX$,ZIndivValue$,2,ZLenIndiv)
      RETURN
'
' *  GET CITY AND STATE
'
12960 ZOutTxt$ = WasA1$ + _
                 ZUserLocation$
      IF NOT ZNewUser THEN _
         ZOutTxt$ = ZOutTxt$ + ZPressEnter$
      ZParseOff = ZTrue
      GOSUB 13115
      IF ZWasQ = 0 OR ZUserIn$ = SPACE$(LEN(ZUserIn$)) THEN _
         IF ZNewUser THEN _
            GOTO 12960 _
         ELSE RETURN
      CALL AllCaps (ZUserIn$)
      CALL QuickTPut1 ("Set to "+ZUserIn$)
      LSET ZCityState$ = ZUserIn$
      ZWasCI$ = ZUserIn$
      RETURN
'
' *  S - COMMAND FROM 5 - USER MAINTENANCE OPTIONS (SCAN USERS)
'
12962 WasX = 0
      ZFF = ZFalse
      ZMacroMin = 99
      ZOutTxt$ = "String to search"
      ZOutTxt$ = ZOutTxt$ + _
           ZPressEnter$
      CALL TGet
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         GOTO 11001
      CALL AllCaps (ZUserIn$)
      WasWK$ = ZUserIn$
      IF ScanFunction$ = "L" THEN _
         WasWK$ = "," + _
               STR$(VAL(WasWK$)) + _
               ","
12963 GET 5,WasI
      GOSUB 12966
      WasX = INSTR(ScanField$,WasWK$)
      IF WasX > 0 THEN _
         GOTO 11015
12965 WasI = WasI + 1
      IF WasI > ZHighestUserRecord THEN _
         LSET ZUserRecord$ = UserRecordHold$ : _
         GOTO 11001
      WasX = 0
      GOTO 12963
12966 ZFF = INSTR("NCPLH",ScanFunction$)
12967 ON ZFF GOTO 12968,12969,12970,12972,12971
      GOTO 11001
'
' *  N - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR NAME)
'
12968 ScanField$ = ZUserName$
      RETURN
'
' *  C - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR CITY/ST)
'
12969 ScanField$ = ZCityState$
      RETURN
'
' *  P - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR PASSWORD)
'
12970 ScanField$ = ZPswd$
      RETURN
'
' *  H - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR HASH ID)
'
12971 IF ZStartHash > 0 AND ZLenHash > 0 THEN _
         ScanField$ = MID$(ZUserRecord$,ZStartHash,ZLenHash)
      RETURN
'
' *  L - COMMAND FROM 5 - USER MAINTENANCE SCAN FUNCTION (SEARCH FOR LEVEL)
'
12972 ScanField$ = "," + _
                    STR$(CVI(ZSecLevel$)) + _
                    ","
      RETURN
13100 FIELD 5,31 AS ZUserName$, _
              15 AS ZPswd$, _
               2 AS ZSecLevel$, _
              14 AS ZUserOption$,  _
              24 AS ZCityState$, _
               1 AS MachineType$, _
               1 AS ZDropTimes$, _
               1 AS ZBankTime$,_
               4 AS ZTodayDl$, _
               4 AS ZTodayBytes$, _
               4 AS ZDlBytes$, _
               4 AS ZULBytes$, _
              14 AS ZLastDateTimeOn$, _
               3 AS ZListNewDate$, _
               2 AS ZUserDnlds$, _
               2 AS ZUserUplds$, _
               2 AS ZElapsedTime$
      FIELD 5,128 AS ZUserRecord$
      RETURN
13110 ZTurboKey = -ZTurboKeyUser
13115 CALL PopCmdStack
13190 IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
13200 GOSUB 13204
      ZSubParm = 1
13202 CALL TGet
13204 IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
13230 ZSubParm = 6  ' LOCK USER BLOCK
      GOTO 13236
13232 ZSubParm = 8  ' UNLOCK USER BLOCK
      GOTO 13236
13236 CALL FileLock
      IF Flushed THEN _
         FIELD 1,128 AS ZMsgRec$ : _
         Flushed = ZFalse
      IF ZSubParm = -1 THEN _
         ZSubParm = -9 : _
         CALL FindFKey : _
         EXIT SUB
      RETURN
      END SUB
'
23000 '$SUBTITLE: 'GetMessageHdr -- subroutine get message header'
' $PAGE
'
' NAME   : GetMessageHdr
'
' PURPOSE: To retreive message header.  Formerly in RBBS-PC.BAS
'
' INPUTS : ZMsgRec$      MESSAGE RECORD WORKING WITH
'
' OUTPUTS: None
'
'
      SUB GetMessageHdr
      FIELD 1, 128 AS ZMsgRec$
      GET 1,1
      ZHighMsgNumber = VAL(LEFT$(ZMsgRec$,8))
      ZAutoAddSec   = CVI(MID$(ZMsgRec$,9,2))
      ZCallsToDate! = VAL(MID$(ZMsgRec$,11,10))
      ZMsgSecCats$ = LEFT$("U",-(MID$(ZMsgRec$,21,1) <> "/")) + _
                     LEFT$("R",-(MID$(ZMsgRec$,22,1) <> "/")) + _
                     LEFT$("P",-(MID$(ZMsgRec$,23,1) <> "/")) + "EH"
      IF ZUserSecLevel >= ZSecKillAny THEN _
          ZMsgSecCats$ = "URPEH"
      IF ZMsgSecCats$ = "EH" THEN _
         ZMsgSecCats$ = "UEH"
      ZCurUserCount = VAL(MID$(ZMsgRec$,57,5))
      ZFirstMsgRecord = VAL(MID$(ZMsgRec$,68,7))
      ZNextMsgRec = VAL(MID$(ZMsgRec$,75,7))
      ZHighestMsgRecord = VAL(MID$(ZMsgRec$,82,7))
      Temp = VAL(MID$(ZMsgRec$,127))
      IF ZActiveMessageFile$ = ZOrigMsgFile$ THEN _
         ZMaxNodes = Temp
      IF ZNextMsgRec <= Temp THEN _
         ZNextMsgRec = Temp + 1
      END SUB
'
23100 '$SUBTITLE: 'FixMessageHdr -- subroutine to fix message header'
' $PAGE
'
' NAME   : FixMessageHdr
'
' PURPOSE: To fix message header.  Formerly in RBBS-PC.BAS
'
' INPUTS : ZMsgRec$      MESSAGE RECORD WORKING WITH
'
' OUTPUTS: None
'
'
      SUB FixMessageHdr
      FIELD 1, 128 AS ZMsgRec$
23105 GET 1,ZNextMsgRec
      IF MID$(ZMsgRec$,61,1) = ":" THEN _
         CALL CheckInt (MID$(ZMsgRec$,117,4)) : _
         IF ZErrCode = 0 AND (ZTestedIntValue > 1) AND (ZTestedIntValue < 100) THEN _
            WasY = ZTestedIntValue : _
            CALL CheckInt (MID$(ZMsgRec$,2,4)) : _
            IF ZErrCode = 0 AND ZTestedIntValue > ZHighMsgNumber THEN _
               ZHighMsgNumber = ZTestedIntValue : _
               ZNextMsgRec = ZNextMsgRec + WasY : _
               CALL QuickTPut1 ("Fixing Msg Header") : _
               MsgCorrected = ZTrue : _
               GOTO 23105
      END SUB
'
24000 '$SUBTITLE: 'UpdtMessageHdr -- subroutine to update message header'
' $PAGE
'
' NAME   : UpdtMessageHdr
'
' PURPOSE: To update message header.  Formerly in RBBS-PC.BAS
'
' INPUTS : ZMsgRec$      MESSAGE RECORD WORKING WITH
'
' OUTPUTS: None
'
'
      SUB UpdtMessageHdr
      FIELD 1, 128 AS ZMsgRec$
      MID$(ZMsgRec$,1,8) = STR$(ZHighMsgNumber)
      MID$(ZMsgRec$,11,10) = STR$(ZCallsToDate!)
      MID$(ZMsgRec$,57,5) = STR$(ZCurUserCount)
      MID$(ZMsgRec$,68,7) = STR$(ZFirstMsgRecord)
      MID$(ZMsgRec$,75,7) = STR$(ZNextMsgRec)
      MID$(ZMsgRec$,82,7) = STR$(ZHighestMsgRecord)
      PUT 1,1
      END SUB
'
42849 '$SUBTITLE: 'EchoSet -- subroutine to allow user to set echo pref'
' $PAGE
'
' NAME   : EchoSet
'
' PURPOSE: To allow user to set echo preference.  Formerly in RBBS-PC.BAS
'
' INPUTS : ZEchoer$     USERS CURRENT ECHO PREFERENCE
'
' OUTPUTS: None
'
'
      SUB EchoSet
      CALL ReportEcho
42851 ZOutTxt$ = "Change to R)BBS, C)aller's software" + _
           MID$(", I)ntermediate host",1,-20 * (ZHostEchoOn$ <> "")) + _
           ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         EXIT SUB
42852 ZWasZ$ = LEFT$(ZUserIn$(ZAnsIndex),1)
      CALL AllCaps (ZWasZ$)
      IF INSTR("ICR",ZWasZ$) = 0 THEN _
         GOTO 42851
      ZEchoer$ = ZWasZ$
      CALL SetEcho (ZEchoer$)
      CALL ReportEcho
      END SUB
'
65000 ' ****  S - COMMAND FROM THE UTILITIES MENU (STATISTICS) ****
      SUB Statistics (Login)
      ActionFlag = ZTrue
      IF ZActiveMessageFile$ = ZPrevBast$ THEN _
         ActionFlag = ZFalse
      CALL SkipLine (1)
      CALL QuickTPut1 (ZFGF$ + "RBBS-PC " + ZFGE$ + ZVersionID$ + ZFGF$ + _
                      " Node " + ZFGE$ + ZNodeID$ + ZFG7$ + ZVersionID2$)
      ZOutTxt$ = ""
      IF NOT ZConfMode THEN _
         ZOutTxt$ = ZFG1$ + "Caller Number ..... " + ZFGE$ + STR$(ZCallsToDate!) + "  " + ZCrLf$
      IF ZActiveMessages > 0 THEN _
         ZOutTxt$ = ZOutTxt$ + ZFG1$ + "Active Messages ... " + ZFGE$ + STR$(ZActiveMessages) + ZCrLf$
      ZOutTxt$ = ZOutTxt$ + ZFG1$ + "Next Msg Number ... " + ZFGE$ + STR$(ZHighMsgNumber + 1) + ZCrLf$
      IF ZLastMsgRead > 0 THEN _
         ZOutTxt$ = ZOutTxt$ + ZFG1$ + "Last Msg You Read . " + ZFGE$ + STR$(ZLastMsgRead) + ZCrLf$
      IF NOT ZTimeBankInActive AND ZMaxBank > 0 THEN _
         ZOutTxt$ = ZOutTxt$ + ZFG1$ + "Banked Time ....... " + ZFGE$ + STR$(ZGlobalBankTime) + ZFG1$ + " mins" + ZCrLf$
      ZOutTxt$ = ZOutTxt$ + ZFG1$ + "Dropped Carriers... " + ZFGE$ + _
              STR$(ZDropTimes) + ZFG1$ + "  Reset at: " + ZFGE$ + STR$(ZDropCarSecChng) + ZCrLf$
      IF ZLastMsgRead = 0 THEN _
         ZOutTxt$ = ZOutTxt$ + ZFGE$ + "NO Messages Read Yet! " + ZCrLf$
      ZSubParm = 1
      CALL TPut
      IF ZRemindFileXfers AND NOT ZNewUser THEN _
         CALL QuickTPut1 (ZFGB$ + "Files Downloaded .. " + ZFGF$ + _
                  STR$(ZDnlds) + SPACE$(6-LEN(STR$(ZDnlds))) + ZEmphasizeOff$) : _
         CALL QuickTPut1 (ZFGB$ + "Files Uploaded .... " + _
                  ZFGF$ + STR$(ZUplds) + SPACE$(6-LEN(STR$(ZUplds))) + _
                  ZEmphasizeOff$)
      CALL SkipLine(1)
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZWasZ$ = ZUpldDriveFile$
      CALL FindFree
      CALL QuickTPut1 (ZFG4$ + "Upload Disk has" + ZFG7$ + ZFreeSpace$)
      IF ZDOSversion$ <> "" THEN _
         ZOutTxt$ = ZFG4$ + "Running under " + ZFG4$ + "DOS Version " + ZDOSversion$ _
      ELSE _
         ZOutTxt$ = ZFG4$ + "Running under " + ZFG4$ + "OS/2 Version " + ZOS2version$
      IF ZDVversion$ <> "" THEN _
         ZOutTxt$ = ZOutTxt$ + ZFG4$ + " and " + ZFG4$ + "DESQview Version " + _
                    ZDVversion$ + ZEmphasizeOff$ _
      ELSE _
         ZOutTxt$ = ZOutTxt$ + ZEmphasizeOff$
      CALL QuickTPut1 (ZOutTxt$)
      Temp$ = LTRIM$(STR$(ZBaudTest!)) + ZFG4$ + MID$(ZBaudParity$,INSTR(ZBaudParity$," B"))
      IF ZKeepInitBaud THEN _
         ZOutTxt$ = ZFG4$ + "Host Operating at " + ZFGB$ + ZModemInitBaud$ + ZFG4$ + _
                    " BPS, Line Speed " + ZFGB$ + Temp$ + ZEmphasizeOff$ _
      ELSE _
         ZOutTxt$ = ZFG4$ + "Connected at " + ZFGB$ + Temp$ + ZEmphasizeOff$
      CALL QuickTPut1 (ZOutTxt$)
      IF (NOT ZSysop) AND (ZUserSecLevel < ZSecKillAny) THEN _
         IF ZDoMailCheck THEN _
            CALL SkipLine (1) : _
            CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue) : _
         EXIT SUB
      IF ZMenuIndex = 4 AND ZGlobalSysOp THEN
         UserWork = (ZHighestUserRecord * .95) + 1
         IF ZMsgsCanGrow THEN _
            ZWasY$ = " open" _
         ELSE _
            ZWasY$ = STR$(ZHighestMsgRecord + 1 - ZMaxNodes - ZNextMsgRec)
         ZOutTxt$ = ZFG4$ + "USERS: used" + ZFGB$ + STR$(ZCurUserCount - 1)
         ZOutTxt$ = ZOutTxt$ + ZFG4$ + " avl" + ZFGB$ + STR$(UserWork - ZCurUserCount)
         IF ZActiveMessages < 1 THEN
            MParm = 15
            CALL MsgSys (MParm,ActionFlag,GetOut,LogonMailNew,UtilMarginChange,MsgSec,UserCanReadMsg)
         END IF
         ZOutTxt$ = ZOutTxt$ + ZFG4$ + " MSGS: used" + ZFGB$ + STR$(ZActiveMessages) + ZFG4$ + " avl"
         ZOutTxt$ = ZOutTxt$ + ZFGB$ + STR$(ZMaxMsgs - ZActiveMessages)
         ZOutTxt$ = ZOutTxt$ + ZFG4$ + " MSG REC: used" + ZFGB$ + STR$(ZNextMsgRec - 1) + ZFG4$ + " avl"
         ZOutTxt$ = ZOutTxt$ + ZFGB$ + ZWasY$ + ZEmphasizeOff$
         ZSubParm = 5
         CALL TPut
         ZTurboBase = ZFalse
         ZPrevBase$ = ""
      END IF
      CALL SkipLine (1)
      IF ZDoMailCheck AND Login OR (ZMenuIndex = 4 AND NOT ZExpertUser) THEN _
         CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
      IF ZSubParm < 0 THEN _
         EXIT SUB
      END SUB
'
65002 SUB ShowUsrProfile
      CALL SkipLine(1)
      WasX$ = DATE$
      CALL TRIM(WasX$)
      CALL QuickTPut1 (ZFGE$ + " User Profile as of " + ZFGF$ + WasX$ + _
              ZFGE$ + " at " + ZFGF$ + ZTime$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " User Name :  " + ZFGB$ + ZActiveUserName$ + _
              STRING$((34 - (LEN(ZActiveUserName$) + 13)),32) + _
              ZFG1$ + " City/State:  " + ZFGB$ + ZCityState$
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Security  : " + ZFGB$ + STR$(ZUserSecSave) + _
              STRING$((35 - (LEN(STR$(ZUserSecSave)) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " Protocol  :  " + ZFGB$ + ZUserXferDefault$
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Times On  : " + ZFGB$ + STR$(ZTimesLoggedOn) + _
              STRING$((35 - (LEN(STR$(ZTimesLoggedOn)) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " Read Msg. : " + ZFGB$ + STR$(ZLastMsgRead)
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Last On   :  " + ZFGB$ + ZLastDateTimeOnSave$ + _
              STRING$((34 - (LEN(ZLastDateTimeOnSave$) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " Graphics  :  " + ZFGB$ + _
                 MID$("None AsciiColor",ZWasGR * 5 + 1,5)
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Downloads : " + ZFGB$ + STR$(ZDnlds) + _
              STRING$((35 - (LEN(STR$(ZDnlds)) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " User Mode :  " + ZFGB$ + _
                 MID$("NoviceExpert",1 - 6 * ZExpertUser,6)
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Uploads   : " + ZFGB$ + STR$(ZUplds) + _
              STRING$((35 - (LEN(STR$(ZUplds)) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " Upper Case:  " + ZFGB$ + _
                 MID$("and lowerONLY",1 - 9 * ZUpperCase,9)
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Dl-Bytes  : " + ZFGB$ + STR$(ZDLBytes!) + _
              STRING$((35 - (LEN(STR$(ZDLBytes!)) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " Line Feeds:  " + ZFGB$ + _
                 FNOFFON$(ZLineFeeds)
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Ul-Bytes  : " + ZFGB$ + STR$(ZULBytes!) + _
              STRING$((35 - (LEN(STR$(ZULBytes!)) + 13)),32)
      IF ZFF = 35 THEN _
         WasX$ = WasX$ + ZFG1$ + " Nulls     :  " + ZFGB$ + _
                 FNOFFON$(ZNulls)
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      IF ZRestrictByDate AND ZDaysInRegPeriod > 0 THEN _
        IF ZUserSecLevel > ZTempExpiredSec THEN _
           WasX$ = ZFG1$ + " Expiration:  " + ZFGB$ + ZExpirationDate$ : _
           CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      WasX$ = ZFG1$ + " Dropped Carriers: " + ZFGB$ + LTRIM$(STR$(ZDropTimes)) : _
      CALL QuickTPut1 (WasX$ + ZEmphasizeOff$)
      CALL SkipLine(1)
      CALL Toggle (-8)
      CALL Toggle (-5)
      CALL Toggle (-10)
      CALL Toggle (-2)
      CALL Toggle (-4)
'      CALL Toggle (-11)
      CALL SkipLine(1)
      END SUB
'
65030 ' $SUBTITLE: 'GetLC - subroutine to retrieve Last User on RBBS'
' $PAGE
'
'  NAME    --     GetLC
'
'                 PARAMETER                    MEANING
'
'  INPUTS  --     ZActiveMessageFile$          ACTIVE MESSAGE FILE
'                 ZMsgRec$                     CURRENT MESSAGE RECORD
'
'
'  OUTPUTS --     ZLastCaller$                 LAST CALLER ON THE BBS
'
'  PURPOSE --     To retrieve the last user on RBBS for display on the
'                 MENU0 screen
'
      SUB GetLC
      ZLastCaller$ = " "
      ZActiveMessageFile$ = ZOrigMsgFile$
      CALL OpenMsg
      FIELD 1, 128 AS ZMsgRec$
      GET 1,ZNodeRecIndex
      IF MID$(ZMsgRec$,55,2) = "-1" AND NOT ZSysop THEN _
         ZLastCaller$ = "SysOp" _
      ELSE _
         ZLastCaller$ = MID$(ZMsgRec$,1,26)
      CALL TrimTrail (ZLastCaller$," ")
      IF MID$(ZMsgRec$,101,2) <> " 0" THEN _
         LCT$ = MID$(ZMsgRec$,93,22) : _
         CALL TrimTrail (LCT$," ") : _
         ZLastCaller$ = ZLastCaller$ + " from " + LCT$
      END SUB
'
65045 ' $SUBTITLE: 'ReadColorDef - subroutine to retrieve Colors for RBBS'
' $PAGE
'
'  NAME    --     ReadColorDef
'
'                 PARAMETER                    MEANING
'
'  INPUTS  --     ZColorDef$                   EXTERNAL COLOR FILE
'
'
'  OUTPUTS --     Global Color Variables
'
'  PURPOSE --     To read the COLORxxx.DEF file to set the colors that
'                 RBBS will use for display.
'
      SUB ReadColorDef
      ZErrCode = 0
      CALL OpenWork (2,ZColorDef$,ZFalse)
      IF ZErrCode > 0 THEN _
         ZErrCode = 0 : _
         CALL SkipLine(1) : _
         ZOutTxt$ = "Color Config. file " + ZColorDef$ + _
                    " missing or unavail." + ZCrLf$ : _
         CALL PScrn (ZOutTxt$) : _
         BEEP : _
         CALL DelayTime(2) : _
         CALL UpdtCalr(ZOutTxt$,2) : _
         EXIT SUB
      CALL ReadDir (2,1)
      ZFG1Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG2Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG3Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG4Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG5Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG6Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG7Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG8Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFG9Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGADef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGBDef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGCDef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGDDef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGEDef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGFDef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZFGGDef$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG0Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG1Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG2Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG3Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG4Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG5Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG6Def$ = ZEscape$ + ZOutTxt$
      CALL ReadDir (2,1)
      ZBG7Def$ = ZEscape$ + ZOutTxt$
      CLOSE 2
      IF ZErrCode > 0 THEN _
         CALL SkipLine(1) : _
         ZOutTxt$ = "Color Config. file " + ZColorDef$ + _
                    " improper format" + ZCrLf$ : _
         CALL PScrn (ZOutTxt$) : _
         BEEP : _
         CALL DelayTime(2) : _
         CALL UpdtCalr(ZOutTxt$,2) : _
         ZErrCode = 0
      END SUB
