unit rusnglob;

{

rusnglob.pas - constants, types, and global variables for rusnews

}

{$I rusn-def.pas}

interface

{$ifdef mouse}

uses mouse;

{$endif}

const

  newsreadername='rusnews';
  newsreaderversion='v1.21';

{$ifdef tiny}
  maxarts=60;
  maxkills=50;
  maxlpp=25;
  maxcols=80;
  maxjoined=120;
{$else}
  maxarts=400;
  maxkills=150;
  maxlpp=50;
  maxcols=132;
  maxjoined=150;
{$endif}

  minlpp=8;
  mincols=32;

  eightbitclean=true;

  selheaderlines=1;
  headerbufsize=6144;
  headertlsize=256;

{$ifndef mouse}
  hasmouse=false;
{$endif}

  impossibleart=65535;
    {note: a word value, needs to change to maxlongint}

type
  subjstringt=string[70];
  fnstringt=string[14];
  datet=longint;  {year * 16384 + month * 1024 + dayofmonth * 32 + gmthour}
  fromstringt=string[20];
  groupstringt=string[40];
  killstringt=string[75];
  fnarray=array[1..maxarts] of fnstringt;
  fromarray=array[1..maxarts] of fromstringt;
  datearray=array[1..maxarts] of datet;
  headerbuft=array[1..headerbufsize] of char;
  headerlinet=record
      first: char;
      offset: integer;
    end;
  headertrackedlinest=array[1..headertlsize] of headerlinet;
  killsarr=array[1..maxkills] of killstringt;
  killsarrp=^killsarr;
  hashedt=array[1..2] of word;
  hashedarr=array[1..maxarts] of hashedt;
  ifacetype=(ifacewaffle, ifaceuupc, ifaceuufree, ifaceunknown);

{$ifdef mouse}
  mevent=record
           event, btnstatus, horiz, vert: word;
         end;
{$endif}

var
  oldfilemode: byte;
  groupdir: string;
  userid: string;
  shadow: integer;
  numarts: integer;
  numjoined: integer;

{high nybble of indents used for auto-selected articles etc.}

  indents: array[1..maxarts] of byte;
  sizeink: array[1..maxarts] of byte;
  basesubjs: array[1..maxarts] of subjstringt;
  joinedgroups: array[1..maxjoined] of groupstringt;
  filenamesp: ^fnarray;
  fromsp: ^fromarray;
  datesp: ^datearray;
  hmessageidsp: ^hashedarr;
  hreferencesp: array[1..4] of ^hashedarr;
  highestart: word;
  highestread: word;
  wafenv: string;
  spooldir,temporarydir,userdir,configdir,outboxdir: string;
  uucpname,fqdn,smarthost,organ,timezone,backbone: string;
  newsname: string;
  netmail: string;
  netnews: string;
  replyto: string;
  home: string;
  joinfn,killfn,antikillfn: string;
  joinf,killf,antikillf: text;
  optfn: string;
  alreadyread: word;
  currgroup: string;
  headerinmem: string;
  headerbuf: headerbuft;
  headertrackedlines: headertrackedlinest;
  headerbytesinmem: integer;
  currart: integer;
  donegroup: boolean;
  browsedir: integer;
  browseonlysel: boolean;
  alreadyingroup: boolean;
  startingart: word;
  readpagesback: integer;
  readunfiltered: boolean;
  searchinheaders: boolean;
  searchinbody: boolean;
  searchtext: string;
  nextwhilereading: boolean;
  editor: string;
  editoroptions: string;
  vspeller: string;
  vspelleroptions: string;
  killsubjsp,killfromsp: killsarrp;
  killtextp: killsarrp;
  antikillsubjsp,antikillfromsp: killsarrp;
  antikilltextp: killsarrp;
  haskillfile: boolean;
  hasantikillfile: boolean;
  killfileinmem: boolean;
  antikillfileinmem: boolean;
  numkills: integer;
  numantikills: integer;
  numsubjks,numfromks: integer;
  numsubjaks,numfromaks: integer;
  nonglobalkills: boolean;
  nonglobalantikills: boolean;
  fullname: string;
  iface: string;
  xiface: ifacetype;
  ifaceversion: string;
  uupcusr: string;
  uupcsys: string;
  console: boolean;
  port: integer;
  trusted: boolean;
  maymail: boolean;
  maypost: boolean;
  minutestorun: integer;
  forumsetl: string;
  mailfrom: string;
  newsfrom: string;
  lpp: integer;
  sellpp: integer;
  cols: integer;
  lowcolor: byte;
  highcolor: byte;
  oldtextattr: byte;
  checkdeletionsgroup: string;
  lastfilen: string;
  comspec: string;
  fileresult: integer;  {takes the place of IOresult with safereset/rewrite}

{keyboard mapping}

  browsemap: array[char] of char;
  selmap: array[char] of char;
  mainmap: array[char] of char;

{$ifdef timeout}
  minstart: integer;
{$endif}

{$ifdef mouse}
  hasmouse: boolean;
  mousevent: mevent;
  themouse: resetrec;
{$endif}

{ from here are are rc-file/command-line configuration variables }

  subjectscaseinsensitive: boolean;
  subjectlength: byte;
  makespacelikex: boolean;
  hideheaders: string;
  showheaders: string;
  highlightheaders: string;
  nomailfrom: boolean;
  nomailheaders: string;
  nonewsheaders: string;
  wanderingnumbers: boolean;
  antikillreferences: boolean;
  showsubjectkills: boolean;
  showfromkills: boolean;
  showsubjectantikills: boolean;
  showfromantikills: boolean;
  autoantikill: boolean;
  warnautoantikill: boolean;
  editaftervspell: boolean;
  caseinsensitivekill: boolean;
  caseinsensitiveantikill: boolean;
  substringsubjectkill: boolean;
  substringfromkill: boolean;
  substringsubjectantikill: boolean;
  substringfromantikill: boolean;
  quiet: boolean;
  ignoreenvironment: boolean;
  confirmnext: boolean;
  confirmquit: boolean;
  missingsubjectisok: boolean;
  tildehome: boolean;
  antikillthisnewsreader: boolean;  {not of great use to many, I'm sure}
  clearscreenbetweengroups: boolean;
  detectvideo: boolean;
  antikillevenkilled: boolean;
  mailprefix: string;
  ignoremouse: boolean;
  usebiosforscreen: boolean;
  hideformfeeds: boolean;
  pathuserid: string;
  customstatic: string;
  haltonunknowngroups: boolean;
  mousecharsheader: string;
  justdots: boolean;
  nofilemode: boolean;
  quitmessage: string;
  outputseparator: string;
  newscmdline: string;
  mailcmdline: string;
  mailagent: boolean;
  outgoingmail: string;
  outgoingnews: string;
  highlightsearchhits: boolean;
  colors: string;

{$ifdef charset}
  uselocalcharset: boolean;
{$endif}

  rmailsingle: boolean;
  idleminutes: integer;
  swap: string;

implementation

end.
