unit rusnproc;

{

rusnproc.pas - rusnews procedures

}

{$I rusn-def.pas}

interface

uses dos,crt,rusnglob,rusnfunc,rusnio,genericf,rusnmous,rusntime,exec;

procedure shutdown(exitcode: integer);
procedure warn(warning: string);
procedure warn3(w1,w2,w3: string);
procedure warnerr(prg: string; doserr: integer);
procedure execp(cmd,cmdline: string);
procedure shellout;
procedure unfoldergroup(var group: string);
procedure pickagroup(var possgroup: string);
procedure updatejoin(highestnum: word);
procedure updatejoinunsubscribe;
procedure addnewmailgroup(newgroup: string);
procedure execviacomspec(cmdline: string);
procedure verboses(s: string);
procedure verbosess(s1,s2: string);
procedure addalias(fromheader: string);

implementation

procedure shutdown;

begin
  if joinfn<>'' then
    close(joinf);
  if haskillfile then
    close(killf);
  if hasantikillfile then
    close(antikillf);

  mousehide;
  mousereset;

  xgotoxy(1,lpp);
  xwriteln;

  if console then
    begin
      textattr := oldtextattr;
      xwriteln;  {so it uses these new (original) colors for sure}
    end;

  if quitmessage<>'' then
    xwritelns(quitmessage);

  halt(exitcode);
end;

procedure warn;

var
  wastec: char;

begin
  xclreolxy(1,lpp);
  xwritess(warning,' - press any key ');
  wastec := xreadkey;
  xclreolxy(1,lpp);
end;

procedure warn3;

begin
  xwriteln;
  xwriteln;
  xclreolxy(1,lpp-2);
  xwrites(w1);
  xclreolxy(1,lpp-1);
  xwrites(w2);
  warn(w3);
  xclreolxy(1,lpp-2);
  xclreolxy(1,lpp-1);
end;

procedure warnerr;

var
  errstr: string;

begin
  errstr := itoa(doserr); 
  if doserr=2 then errstr := '2 (file not found)'
  else if doserr=3 then errstr := '3 (path not found)'
  else if doserr=5 then errstr := '5 (access denied)'
  else if doserr=6 then errstr := '6 (invalid handle)'
  else if doserr=8 then errstr := '8 (not enough memory)'
  else if doserr=10 then errstr := '10 (invalid environment)'
  else if doserr=11 then errstr := '11 (invalid format)'
  else if doserr=18 then errstr := '18 (no more files)';

  warn('warning: '+prg+' failed (error '+errstr+')');
end;

procedure execp;

var
  path: string;
  success: boolean;
  ncmd: string;
  nbase: string;
  npath: string;
  el: string;
  at: integer;

function indir(cmd,dir: string): boolean;

var
  fileinfo: searchrec;

begin
  findfirst(dir+'\'+cmd,archive,fileinfo);
  indir := (doserror=0);
end;

procedure execswappable(pgm, cmdline: string);

var
  exstat: integer;

begin
  if swap='' then
    exstat := do_exec(pgm, cmdline, 1, $ffff, false)
  else
    dos.exec(pgm, cmdline);
end;

begin
  success := false;

  ncmd := crepl(cmd,'/','\');
  nbase := ncmd;

{strip path from nbase}

  repeat
    at := pos(':',nbase);
    if at<>0 then
      nbase := copy(nbase,at+1,255);
  until at=0;

  repeat
    at := pos('\',nbase);
    if at<>0 then
      nbase := copy(nbase,at+1,255);
  until at=0;

{chop off path.  if trailing \, chop, unless root or drive:root (then add .)}

  npath := '';
  if nbase<>ncmd then
    begin
      success := true;  {so as to not look further than given path}
      npath := copy(ncmd,1,length(ncmd)-length(nbase));
      if npath='\' then
        npath := npath+'.';
      if pos(':\',npath)<>0 then
        if copy(npath,length(npath)-1,2)=':\' then
          npath := npath+'.';
      if copy(npath,length(npath),1)='\' then
        npath := copy(npath,1,length(npath)-1);
    end;

{if an explicit path, use it -- otherwise, just try '.'}

  if npath='' then
    npath := '.';

{if no extension, try com then exe}

  if pos('.',nbase)=0 then
    begin
      if indir(nbase+'.com',npath) then
        begin
          success := true;
          execswappable(npath+'\'+nbase+'.com',cmdline);
        end
      else if indir(nbase+'.exe',npath) then
        begin
          success := true;
          execswappable(npath+'\'+nbase+'.exe',cmdline);
        end
    end
  else if indir(nbase,npath) then
    begin
      success := true;
      execswappable(npath+'\'+nbase,cmdline);
    end;

  if not success then
    begin

{not found in explicit path (or ., if no explicit path).  try $PATH}

      path := getenv('PATH');
      while not success and (path<>'') do
        begin
          if copy(path,length(path),255)<>';' then
            path := path+';';
          at := pos(';',path);
          el := copy(path,1,at-1);
          path := copy(path,at+1,255);
          if pos('.',nbase)=0 then
            begin
              if indir(nbase+'.com',el) then
                begin
                  success := true;
                  execswappable(el+'\'+nbase+'.com',cmdline);
                end
              else if indir(nbase+'.exe',el) then
                begin
                  success := true;
                  execswappable(el+'\'+nbase+'.exe',cmdline);
                end;
            end
          else
            begin
              if indir(nbase,el) then
                begin
                  success := true;
                  execswappable(el+'\'+nbase,cmdline);
                end;
            end;
        end;
    end;

{$ifdef timeout}
  resetidle;
{$endif}

end;

procedure shellout;

var
  doserr: integer;
  wastec: char;

begin
  if console and trusted then
    begin
      xgotoxy(1,lpp);
      xwriteln;
      xwriteln;
      xwriteln;
      xwritelns('use `EXIT'' to return to rusnews');

      if swap='' then
        xwritelns('be careful - you probably don''t have a lot of memory left')
      else
        xwritelns('be careful - may not have much memory available');

      xwriteln;
      if comspec='' then
        begin
          warn('could not find what shell to run - no COMSPEC variable');
        end
      else
        begin
          mousehide;
          execp(comspec,'');
          mouseshow;
          doserr := doserror;
          xgotoxy(1,lpp);
          xwriteln;
          xwriteln;
          xwriteln;
          if doserr<>0 then
            xwrites('(error) press any key to return to rusnews ')
          else
            xwrites('press any key to return to rusnews ');
          wastec := xreadkey;
          xwrites(^M);
          xclreol;
          if doserr<>0 then
            warnerr('shell',doserr);
        end
    end;
end;

procedure unfoldergroup;

begin
  if length(group)>0 then
    if group[1]='=' then
      begin
        if length(group)=1 then
          group := mailprefix
        else
          group := mailprefix+'.'+copy(group,2,255);

{ prevent possible security hole }

        if (numoccur('\',unslash(group))<>0) or
         (numoccur(':',group)<>0) or (pos('..',group)<>0) then
          group := mailprefix;
      end;
end;

procedure pickagroup;

const
  baseprompt =
   '<j>ump, <a>ll, <1>-<9> pages, <#>, <f>aqs, <h>eader <b>ody <e>ither, <+>';

var
  prompt: string;
  howto: char;

begin
  xclreolxy(1,lpp);
  if possgroup='' then
    begin
      xwrites('Goto group (or initials): ');
      possgroup := currgroup;

{ changed true to false - it was a pain having to hit ^U to cancel this }

      xreadlnsp(possgroup,cols-30,false);

{mail folder support}

      unfoldergroup(possgroup);

    end;

  if (possgroup='') then
    xclreolxy(1,lpp)
  else
    if not joinedtogroup(possgroup) then
      begin
{}{}     {should add to join file, asking where first}
        warn('could not find a group to match');
        possgroup := '';
      end
    else
      begin
        xclreolxy(1,lpp-1);
        xwritelnss('found group: ',possgroup);

        if not quiet then
          begin
            xclreolxy(1,lpp-5);
        xwritelns(
        '<j>ump to last position; <a>ll articles; <#> pick start article');
            xclreolxy(1,lpp-4);
        xwritelns(
        '<f>requently asked questions; <h>eader,<b>ody,<e>ither searching');
            xclreolxy(1,lpp-3);
        xwritelns(
        '<+> no filtering due to <s>een, <k>ill, etc.');
            xclreolxy(1,lpp-2);
          end;

        repeat

          prompt := '';
          if readunfiltered then
            prompt := prompt+'+';
          if searchinheaders and searchinbody then
            prompt := prompt+'e'
          else if searchinheaders then
            prompt := prompt+'h'
          else if searchinbody then
            prompt := prompt+'b';

          if prompt='' then
            prompt := baseprompt
          else
            prompt := baseprompt+' '+prompt;

          howto := onekeydef(prompt,'ja123456789#hbe+f','j');

          if howto='+' then
            readunfiltered := not readunfiltered;
          if howto='h' then
            searchinheaders := not searchinheaders;
          if howto='b' then
            searchinbody := not searchinbody;
          if howto='e' then  {I think this is the best way to toggle this}
            begin
              searchinheaders := not (searchinheaders or searchinbody);
              searchinbody := searchinheaders;
            end;

        until (howto<>'+') and
         (howto<>'e') and
         (howto<>'h') and
         (howto<>'b');

        startingart := impossibleart;

        if howto='#' then
          begin
            xclreolxy(1,lpp);
            xwrites('Start at article number (blank to ignore) ');
            xreadlnsp(prompt,cols-30,false);
            if prompt<>'' then
              begin
                startingart := atow(prompt);
                if startingart<>0 then
                  dec(startingart);  {we really start one above startingart}
              end;
          end;

        if howto='f' then  {set some temporary flags}
          begin
            searchinheaders := false;
            searchinbody := false;
          end;

        if searchinheaders or searchinbody then
          begin
            xclreolxy(1,lpp);
            xwrites('Search for: ');
            xreadlns(searchtext,cols-30,true);
            if searchtext='' then
              searchtext := newsreadername;
          end;

        if howto='f' then  {now reset them to what we want}
          begin
            searchinheaders := true;
            searchinbody := false;
            searchtext := '<FAQ>';  {magic cookie picked up later}
            readunfiltered := true;
            startingart := 0;
          end;

        if howto='a' then
          startingart := 0;

        if (howto>='1') and (howto<='9') then
          readpagesback := ord(howto)-ord('0');

        xclreolxy(1,lpp);
      end;
end;

procedure updatejoin;

var
  oldcurrgroup: string;
  s: string;
  tempf: text;

begin
  oldcurrgroup := currgroup;
  if checkdeletionsgroup<>'' then
    begin
      if checkdeletionsgroup=currgroup then
        begin

{ make sure the number we write is not past the current state of the disk }
{ set alreadyread to 0 to make sure it gets updated }

          highestnum := min(highestnum,
           highestartin(getgroupdir(currgroup)));
          alreadyread := 0;
        end
      else
        warn('checkdeletionsgroup not current group!');

      currgroup := checkdeletionsgroup;
      checkdeletionsgroup := '';
    end;

  if highestnum>alreadyread then
    begin
      if quiet then
        xwritelns('Updating join file...')
      else
        xwritelnsss('Updating join file for ',currgroup,'...');
      assign(tempf,temporarydir+'\'+userid);
      reset(joinf);
      rewrite(tempf);
      while not eof(joinf) do
        begin
          readln(joinf,s);
          if getfirstw(s)=currgroup then
            writeln(tempf,currgroup,' ',highestnum)
          else
            writeln(tempf,s);
        end;
      close(joinf);
      close(tempf);

      reset(tempf);
      rewrite(joinf);
      while not eof(tempf) do
        begin
          readln(tempf,s);
          writeln(joinf,s);
        end;
      close(tempf);
      close(joinf);

      erase(tempf);

      reset(joinf);
    end;
  currgroup := oldcurrgroup;
end;

procedure updatejoinunsubscribe;

var
  s: string;
  firstw: string;
  tempf: text;

begin
  xwritelns('Updating join file...');
  assign(tempf,temporarydir+'\'+userid);
  reset(joinf);
  rewrite(tempf);
  numjoined := 0;
  while not eof(joinf) do
    begin
      readln(joinf,s);
      firstw := getfirstw(s);
      if firstw<>currgroup then
        begin
          if numjoined<maxjoined then
            begin
              inc(numjoined);
              joinedgroups[numjoined] := firstw;
            end;
          writeln(tempf,s);
        end;
    end;
  close(joinf);
  close(tempf);

  reset(tempf);
  rewrite(joinf);
  while not eof(tempf) do
    begin
      readln(tempf,s);
      writeln(joinf,s);
    end;
  close(tempf);
  close(joinf);

  erase(tempf);

  reset(joinf);
end;

procedure addnewmailgroup;

var
  added: boolean;
  seenmailbutnotnew: boolean;
  s: string;
  firstw: string;
  tempf: text;

begin
  added := false;

  seenmailbutnotnew := false;

  xwritelns('Updating join file...');
  assign(tempf,temporarydir+'\'+userid);
  reset(joinf);
  rewrite(tempf);

  numjoined := 0;
  while not eof(joinf) do
    begin
      readln(joinf,s);
      firstw := getfirstw(s);

      if firstw=mailprefix then
        seenmailbutnotnew := true;

{insert the new group alphabetically in the mail groups, or after}
{the last one if it's the biggest alphabetically of them all}

      if (seenmailbutnotnew and not ismailgroup(firstw)) or
       (ismailgroup(firstw) and (firstw>newgroup)) then
        begin
          if numjoined<maxjoined then
            begin
              inc(numjoined);
              joinedgroups[numjoined] := newgroup;
            end;
          writeln(tempf,newgroup,' 0');
          seenmailbutnotnew := false;
          added := true;
        end;

      if numjoined<maxjoined then
        begin
          inc(numjoined);
          joinedgroups[numjoined] := firstw;
        end;
      writeln(tempf,s);
    end;

  if seenmailbutnotnew and not added then
    begin
      if numjoined<maxjoined then
        begin
          inc(numjoined);
          joinedgroups[numjoined] := newgroup;
        end;
      writeln(tempf,newgroup,' 0');
    end;

  close(joinf);
  close(tempf);

  reset(tempf);
  rewrite(joinf);
  while not eof(tempf) do
    begin
      readln(tempf,s);
      writeln(joinf,s);
    end;
  close(tempf);
  close(joinf);

  erase(tempf);

  reset(joinf);
end;

procedure execviacomspec;

begin
  execp(comspec,'/c '+cmdline);
end;

procedure verboses;

begin
  if not quiet then
    xwritelns(s);
end;

procedure verbosess(s1,s2: string);

begin
  if not quiet then
    xwritelnss(s1,s2);
end;

procedure addalias;

{caller must refresh}

var
  aliasaddr: string;
  aliasname: string;
  aliasdest: char;
  aliasfn: string;
  aliasf: text;

begin
  xclreolxy(1,lpp);

  aliasaddr := getfromaddr(fromheader);

  xwrites('Address to add to aliases: ');
  xreadlnsp(aliasaddr,50,true);

  xclreolxy(1,lpp);

  if (aliasaddr<>'') then
    begin
      xwrites('Alias to use for that address: ');
      aliasname := lower(getfirstw(getfromname(fromheader)));
      xreadlns(aliasname,40,true);
      xclreolxy(1,lpp);

      if aliasname<>'' then
        begin
          aliasdest := 'p';
          if trusted then
            begin
              aliasdest := onekeydef(
               '<p>ersonal or <s>ystem-wide alias <q>uit','psq','p');
            end;

{ in case of future expansion -- untrusted users ask p or q }

          if not trusted then
            if aliasdest='s' then
              aliasdest := 'p';

          aliasfn := '';

          if aliasdest='p' then
            aliasfn := home+'\aliases'
          else if aliasdest='s' then
            begin
              if (xiface=ifacewaffle) or (xiface=ifaceuufree) then
                aliasfn := configdir+'\system\'+'aliases'
              else if xiface=ifaceuupc then
                aliasfn := unslash(getconfig('aliases'));
            end;

          if aliasfn<>'' then
            begin
              assign(aliasf,aliasfn);
{$I-}
              append(aliasf);
{$I+}
              if ioresult<>0 then
                rewrite(aliasf);

              writeln(aliasf,aliasname,' ',aliasaddr);
              close(aliasf);
            end;

          xclreolxy(1,lpp);

        end;
    end;
end;

end.
