unit rusnselb;

{

rusnselb.pas - rusnews selectandbrowse, viewarts, browseart and friends

}

{$I rusn-def.pas}

interface

uses rusnglob,genericf,rusnfunc,rusnio,rusnproc,rusnkill,
  rusnmous,rusnfile,rusnart,rusncrea

{$ifdef charset}
,rusnchar
{$endif}
 
;

procedure selectandbrowse;

implementation

var
  moreselecting: boolean;
  skipsection: boolean;
  starbeside: integer;
  selected: array[1..maxarts] of boolean;
  numselected: integer;
  topline,botline: integer;

procedure setselected(artnum: integer; b: boolean);

begin
  if selected[artnum]<>b then
    begin
      if b then
        inc(numselected)
      else
        dec(numselected);
      selected[artnum] := b;
    end;
end;

procedure selrefreshbotline;

var
  percent: integer;

begin
  if numarts>600 then
    percent := (10*botline) div (numarts div 10)
  else if numarts>300 then
    percent := (20*botline) div (numarts div 5)
  else
    percent := (100*botline) div numarts;
  if percent>100 then
    percent := 100;   {handle roundoffs more gracefully!}

  xclreolxy(1,sellpp+selheaderlines+3);

  xwritesss('?=help  ',time,'   ');
  xwritei(percent);
  xwrites('% through this group   ');
  xwritei(numarts-botline);
  xwrites(' more   ');
  xwritei(numselected);
  xwritelns(' selected');

{
  xwritelnsssisis('?=help  ',time,'   ',percent,'% through this group   ',
   numarts-botline,' more on later screen(s)');
}

  xclreol;
  xgotoxy(1,sellpp+selheaderlines+4);

end;




procedure browseart(artnum: integer; numleft: integer;
 var willupdatej: boolean);

var
  nonactedleft: boolean;
  lastlineshown: integer;
  artfrom: string;
  artsubject: string;
  artmessageid: string;
  artnewsgroups: string;
  ff: boolean;
  numlefts: string[30];
  totlines: integer;

procedure newbrowsescreen;

begin
  xclrscr;
end;

procedure morelines(linestoshow: integer);

var
  s: string;
  ff: boolean;
  brandnewlinesshown: integer;

begin
  if arteof then
    donebrowse := true
  else
    begin
      nonactedleft := true;
      ff := false;
      brandnewlinesshown := 0;
      while not arteof and (brandnewlinesshown<linestoshow) and not ff do
        begin
          getartl(s,cols-1,true);
          ff := (pos(^L,s)<>0);
          showartl(s);
          inc(brandnewlinesshown);
          inc(lastlineshown);
        end;
    end;
end;

procedure rewindtopline(newtopline: integer);

const
  twirl='/-\|';

var
  s: string;
  skippedlines: integer;
  toggle: integer;
{
  ff: boolean;
  brandnewlinesshown: integer;
}

begin
  toggle := 1;
  newbrowsescreen;
  nonactedleft := true;
  artreset;
  lastlineshown := 0;
  skippedlines := min(0,newtopline);
  while skippedlines<newtopline do
    begin
      getartl(s,cols-1,true);
      inc(skippedlines);
      inc(lastlineshown);
      if (skippedlines and 31)=0 then
        begin
          xwritess(copy(twirl,toggle,1),#8);
          toggle := 1+(toggle mod 4);
        end;
    end;

  xwritess(' ',#8);

  morelines(lpp-1);

{
  ff := false;
  brandnewlinesshown := 0;
  while (brandnewlinesshown<lpp) and not arteof and not ff do
    begin
      getartl(s,cols-1,true);
      ff := (pos(^L,s)<>0);
      showartl(s);
      inc(brandnewlinesshown);
      inc(lastlineshown);
    end;
}

end;

procedure browserefresh;

begin
  rewindtopline(lastlineshown-lpp+1);
end;

procedure showlastline;

var
  wastes: string;

begin
  if totlines<0 then
    begin
      xwrites('searching for bottom line...');
      totlines := 0;
      artreset;
      while not arteof do
        begin
          inc(totlines);
          getartl(wastes,cols-1,true);
        end;
    end;
  rewindtopline(totlines-lpp+1);
end;

procedure browsehelppage;

var
  ch: char;

begin
  xclrscr;
  writexy(1,1,newsreadername+' '+newsreaderversion+
   ' - newsreader-under-development');
  writexy(1,2,'russell@alpha3.ersys.edmonton.ab.ca (941120)');
  writexy(1,4,'space,d,CR - forward 1 page, 1/2 page, 1 line');
  writexy(1,5,'u - back 1 page             = back to selection screen');
  writexy(1,6,'^,$ - top, bottom line    TAB skip this Subject: group');
  writexy(1,7,'n,p - next, previous selected article (or next group)');
  writexy(1,8,'b,a - back,ahead through selected OR unselected');
  writexy(1,9,'r - reply to author (in mail)    / search   . search again');
  writexy(1,10,'f - followup (in netnews) (possibly not yet)');
  writexy(1,11,'k - kill by subject or author (will not display again)');
  writexy(1,12,'K - antikill by subject or author (for auto-selection)');
  writexy(1,13,'^R - reread kill and antikill files from disk');

  if trusted then
  writexy(1,14,'                            A - add alias')
  else
  writexy(1,14,'e - edit article on disk    A - add alias');

  writexy(1,15,'D - rot13-decode article  s w - save/write article to disk');
  writexy(1,16,'h - toggle full header display  ^L - refresh screen');
  writexy(1,17,'! - shell escape        N - next group (no update)');
  writexy(1,19,'? - help                Q - quit (no update)');
  writexy(1,21,'file:');
  writexy(7,21,artfn);
  writexy(1,23,'press any key to return ');
  ch := xreadkey;
  browserefresh;
end;

procedure browseback;

begin
  donebrowse := true;
  browsedir := -1;
  browseonlysel := false;
end;

procedure browseahead;

begin
  donebrowse := true;
  browseonlysel := false;
end;

procedure editart;

var
  doserr: integer;

begin
  if trusted then
    begin
      artclose;
      mousehide;
      execp(editor,editoroptions+' '+artfn);
      mouseshow;
      doserr := doserrorno;
      if doserr<>0 then
        warnerr(editor,doserr);
      artreset;
      browserefresh;
    end;
end;

procedure xreplytoart;

var
  subject: string;
  inreplyto: string;
  replyaddr: string;
  artreplyto: string;
  newreplyaddr: string;
  replyname: string;
  defaultreply: boolean;
  author: string;
  originalfrom: string;
  ccaddr: string;

begin
  artclose;
  subject := artsubject;
  subject := 'Re: '+nore(subject);
  inreplyto := artmessageid;

  artreplyto := getheaderline(artfn,'reply-to:');
  
  replyaddr := artreplyto;
  if replyaddr='' then
    replyaddr := artfrom;
  if replyaddr='' then
    replyaddr := mailfrom;

  author := getfromaddr(replyaddr);

{handle case where Reply-To: is same as From:, but without name - keep it}
  if getfromname(replyaddr)='' then
    if upper(author)=upper(getfromaddr(artfrom)) then
      replyaddr := artfrom;

  if (replyaddr='poster') or (replyaddr='sender') then
    replyaddr := artfrom;

  if (pos('!',replyaddr)=0) and (pos('@',replyaddr)=0) then
    begin
      warn('invalid Reply-To:  - using From:');
      replyaddr := artfrom;
    end;

  replyname := getfromname(replyaddr);
  replyaddr := getfromaddr(replyaddr);

{use `warn' to avoid overwriting an address in the sig, say}

  if upper(replyaddr)<>upper(getfromaddr(artfrom)) then
    warn('default is Reply-To:, not From: (they were different)');

  xclreolxy(1,lpp);
  xwrites('Reply To: ');
  newreplyaddr := replyaddr;
  xreadlns(newreplyaddr,cols-15,true);
  if newreplyaddr='' then
    newreplyaddr := replyaddr;
  defaultreply := (newreplyaddr=replyaddr);
  if not defaultreply then
    begin
      replyaddr := newreplyaddr;
      replyname := '';
    end;

{get the address (if possible) from aliases and user/*/forward files}

  replyaddr := expandmail(replyaddr);

  xclreolxy(1,lpp);

  xwrites('CC: ');
  xreadlns(ccaddr,cols-10,false);
  ccaddr := expandmail(ccaddr);
  xclreolxy(1,lpp);

  if replyaddr<>getfromaddr(artfrom) then
    originalfrom := artfrom
  else
    originalfrom := '';

  editanddeliver(subject,inreplyto,replyaddr,replyname,ccaddr,originalfrom,
   author,defaultreply);

  artreset;

{leave refresh to caller}

end;

procedure replytoart;

begin
  if maymail then
    xreplytoart
  else
    warn('you may not mail -- check your configuration');
end;

procedure mailart;

begin
  warn('using `r''eply instead');
  replytoart;
  browserefresh;
end;

procedure browsecopytofolder;

var
  newgroup: string;
  newgroupdir: string;
  oldlastline: integer;

begin
  if ismailgroup(currgroup) then
    begin
      xclreolxy(1,lpp);
      xwrites('Folder: ');
      xreadlns(newgroup,max(cols-10,70),false);
      xclreolxy(1,lpp);
      if (newgroup<>'') and (numoccur('\',unslash(newgroup))=0) and
       (numoccur(':',newgroup)=0) and (pos('..',newgroup)=0) then
        begin
          if newgroup[1]<>'=' then
            newgroup := '='+newgroup;
          unfoldergroup(newgroup);
          if not joinedtogroup(newgroup) then
            addnewmailgroup(newgroup);
          newgroupdir := getgroupdir(newgroup);
          mkhier(newgroupdir);
          
          oldlastline := lastlineshown;

          artclose;
          copyfile(artfn,getuniqfile(newgroupdir));

          artreset;
          lastlineshown := oldlastline;

        end;
      browserefresh;
    end;
end;

procedure browsemovetofolder;

var
  newgroup: string;
  newgroupdir: string;

begin
  if ismailgroup(currgroup) then
    begin
      xclreolxy(1,lpp);
      xwrites('Folder: ');
      xreadlns(newgroup,max(cols-10,70),false);
      xclreolxy(1,lpp);
      if (newgroup<>'') and (numoccur('\',unslash(newgroup))=0) and
       (numoccur(':',newgroup)=0) and (pos('..',newgroup)=0) then
        begin
          if newgroup[1]<>'=' then
            newgroup := '='+newgroup;
          unfoldergroup(newgroup);
          if not joinedtogroup(newgroup) then
            addnewmailgroup(newgroup);

          newgroupdir := getgroupdir(newgroup);
          mkhier(newgroupdir);
          
          artclose;
          movefile(artfn,getuniqfile(newgroupdir));

{ if #3 is the highest-numbered, and you move #3, it'd mess up your }
{ join file.  perhaps it just should just re-enter the group somehow? }
{ or go through the data structures, removing any evidence of this }
{ article (harder when there's more than one!) }

          if (artfn=getuniqfile(newgroupdir)) and willupdatej then
            begin
              warn('join file will not be updated for this group');
              willupdatej := false;
            end;

          moreselecting := true;
          donebrowse := true;

        end
      else
        begin
          browserefresh;
        end;
    end;
end;

{$ifdef maildelete}

procedure browsedeletemail;

begin
  if ismailgroup(currgroup) then
    begin
      if atow(filenamesp^[currart])=highestart then
        begin
          warn('Cannot delete last article');
        end
      else
        begin
          close(artf);
          erase(artf);

          setselected(artnum,false);
          artopen := false;
          donebrowse := true;
        end;
    end
  else
    begin
      browserefresh;
    end;
end;
{$endif}

procedure followtoart(newfollowupto: string);

var
  followupto: string;
  newsgroups: string;
  originalnewsgroups: string;
  originalauthor: string;
  shouldmail: boolean;
  shouldfollow: boolean;
  replyfollow: char;
  subject: string;
  messageid: string;
  references: string;
  inreplyto: string;
  author: string;
  refline: string;
  ref1, ref2: string;

begin
  xclreolxy(1,lpp);
  xwrites('Follow...');

  artclose;
  followupto := getheaderline(artfn,'followup-to:');
  newsgroups := artnewsgroups;
  originalnewsgroups := newsgroups;

  shouldfollow := true;
  shouldmail := (followupto='poster') or (followupto='sender') or 
   (pos('@',followupto)<>0) or (pos('!',followupto)<>0) or
   (pos('%',followupto)<>0);

{followups redirected to /dev/null - but there are some local groups}
{with no . -- but there shouldn't be, since crossposting is a pain then}

  if pos('.',followupto)=0 then
    begin
      ;
    end;

  if shouldmail or ismailgroup(currgroup) then
    begin
      followupto := newsgroups;
      xclreolxy(1,lpp-2);
      xclreolxy(1,lpp-1);
      if ismailgroup(currgroup) then
        xwritelns('this is probably a private mail folder.')
      else
        xwritelns('author seemed to want replies by mail only.');
      replyfollow := 
       onekey('<r>eply by mail, <f>ollowup anyway, <q>uit','rfq');
      shouldmail := (replyfollow='r');
      shouldfollow := (replyfollow='f');
    end;

{}{} {don't let untrusted users post yet}
  if not trusted then
    shouldmail := true;

  if not maypost then
    shouldmail := true;

  if shouldmail then
    begin
      artreset; {replytoart closes it immediately}
      replytoart;
    end
  else if shouldfollow then
    begin

{ don't propogate errors in the Newsgroups: line if you can help it }

      newsgroups := unspace(newsgroups);
      followupto := unspace(followupto);

{ignore Followup-To: when following up to a new group explicitly}

      if newfollowupto<>'' then
        followupto := '';

      if followupto='' then
        followupto := newsgroups
      else
        begin

{ give the user a warning, to avoid blind Followup-To: misc.test,talk.bizarre }
          if followupto<>newsgroups then
            warn('followups have been changed');
        end;

{ always warn again if there's a .test group in user's post }

      if pos('.test,',followupto+',')<>0 then
        begin
          warn3('there is a .test group on this post -- it may result in',
           'you getting a lot of automated mail from around the world.',
           'remove it unless you _really_ know what you are doing.');
        end;

{}{}{} {should warn user if there are unknown groups that might be errors}

{}{}{} {should do each group individually!}

      if newfollowupto<>'' then
        if newfollowupto<>'poster' then
          if pos(','+newfollowupto+',',','+followupto+',')=0 then
            followupto := followupto+','+newfollowupto;

{currgroup isn't necessarily even in the followupto list, so don't warn}
{about moderation when people post followups to, say,}
{news.announce.newgroups where followups are always redirected to news.groups}

{}{}{} {should check if _any_ group in the list is moderated, and give warning}
      if pos(','+currgroup+',',','+followupto+',')<>0 then
        if ismoderated(currgroup) then
          warn('this group is moderated');

{}{}{} {should check if _any_ of the groups is marked as /solo => strip it out}
      if groupbattr(currgroup,'/solo') and (pos(',',followupto)<>0) then
        begin
          warn('warning: /solo group - crosspost removed');
          followupto := currgroup;
        end;

{ warn on 5 or more groups, suggest followupto of first group }
{ but don't overwrite previous :follow direction! }

      if (numoccur(',',followupto)>3) and (newfollowupto='') then
        begin

  warn('massive crossposting--edit or delete the Followup-To: line');
  newfollowupto := copy(followupto,1,pos(',',followupto)-1);

        end;

      subject := artsubject;
      subject := 'Re: '+nore(subject);
      messageid := artmessageid;
      references := getheaderline(artfn,'references:');

{Andrew system non-compliance, looks like}

      inreplyto := getheaderline(artfn,'in-reply-to:');
      if pos('>',inreplyto)<>0 then
        inreplyto := copy(inreplyto,1,pos('>',inreplyto));

      if length(references)+length(inreplyto)<250 then
        if copy(inreplyto,1,1)='<' then
          if pos(inreplyto,references)=0 then
            references := references+' '+inreplyto;

      author := getheaderline(artfn,'reply-to:');

      if (author='poster') or (author='sender') then
        author := '';

      if (author<>'') and (pos('!',author)=0) and (pos('@',author)=0) then
        begin
          warn('invalid Reply-To:  - using From:');
          author := '';
        end;

      if author='' then
        author := getheaderline(artfn,'from:');

{handle case where Reply-To: is same as From:, but without name - keep the}
{name if you can}

      if getfromname(author)='' then
        if upper(author)=upper(getfromaddr(artfrom)) then
          if getfromname(artfrom)<>'' then
            author := getfromaddr(author)+' ('+getfromname(artfrom)+')';

      originalauthor := '';
      if getfromaddr(author)<>getfromaddr(artfrom) then
        originalauthor := artfrom;


{ special-casing in getheaderline() makes sure we get the last few }
{ references always.  well, except on >255 char References: lines }

      ref1 := '';
      ref2 := '';

      refline := references;
      ref1 := chopfirstw(refline);
      if refline<>'' then
        begin
          ref2 := chopfirstw(refline);
        end;
      while numoccur('>',refline)>0 do
        begin
          ref1 := ref2;
          ref2 := chopfirstw(refline);
        end;

      refline := '';
      if ref1<>'' then
        refline := refline+ref1+' ';
      if ref2<>'' then
        refline := refline+ref2+' ';

      refline := refline+messageid;

      createpost(followupto,originalnewsgroups,newfollowupto,subject,
       refline,author,originalauthor);

      editandinjnews(followupto,originalnewsgroups,author);

    end;
  artreset;
  browserefresh;
end;

procedure follow;

var
  newfollowupto: string;

begin
  if not (trusted and maypost) then
    begin
      warn('you do not have access to post this way');
      browserefresh;
    end
  else
    begin
      newfollowupto := currgroup;
      xclreolxy(1,lpp);
      xwrites('Followup-To: ');
      xreadlnsp(newfollowupto,max(cols-10,70),true);

{possibly expand the group}
{explicitly does not expand to a mail folder -- that wouldn't make sense}
{neither expand the magic word `poster'}

{}{}{} {should expand _each_ group separately}

      if newfollowupto<>'poster' then
        if numoccur(',',newfollowupto)=0 then
          if joinedtogroup(newfollowupto) then
            ;

      followtoart(newfollowupto);

{followtoart does a browserefresh}

    end;

end;

procedure cancel;

var
  yn: char;
  newsubj: string;

begin
  if not (trusted and maypost) then
    begin
      warn('you do not have access to cancel posts');
    end
  else
    begin
      xclreolxy(1,lpp-8);
      xclreolxy(1,lpp-7);
      xwritelnss('          you are: ',newsfrom);
      xclreolxy(1,lpp-6);
      xwritelnss('this article from: ',artfrom);
      xclreolxy(1,lpp-5);
      xclreolxy(1,lpp-4);
      if newsfrom=artfrom then
        xwritelns('(looks the same)')
      else
        xwritelns('NOT THE SAME!');
      xclreolxy(1,lpp-3);
      xclreolxy(1,lpp-2);
      xwritelns('cancel will remove this article from every system');
      xclreolxy(1,lpp-1);
      xwritelns('world-wide.  do not do this unless authorized.');
      xclreolxy(1,lpp);

      yn := onekeydef('are you SURE you are authorized <Y>/<n>',
       'Yn','n');

      if yn='Y' then
        begin
          newsubj := 'cmsg cancel '+artmessageid;
          createcancel(artnewsgroups,newsubj,artmessageid,artfrom);
          editandinjnews(artnewsgroups,'','');
        end;

    end;

{caller must refresh}

end;

procedure killart;

var
  subjectfromoops: char;
  i: integer;

begin
  subjectfromoops := onekeydef(
   'kill: this group: <s>ubject <f>rom; always <S>ubject <F>rom; <o>ops',
   'sfSFo','o');

  if subjectfromoops<>'o' then
    begin
      if (subjectfromoops='s') or (subjectfromoops='S') then
        begin
          xwrites(#13);
          xclreol;
          addtokill('Subject',basesubjs[artnum],(subjectfromoops='S'));

{too much checking here - won't hurt anything but the clock}
          for i := 1 to numarts do
            if selected[i] then
              if subjkilled(basesubjs[i]) then
                setselected(i,false);
        end
      else
        begin
          xwrites(#13);
          xclreol;
          addtokill('From',getfromaddr(artfrom),(subjectfromoops='F'));

{too much checking here - won't hurt anything but the clock}
          for i := 1 to numarts do
            if selected[i] then
              if fromkilled(fromsp^[i]) then
                setselected(i,false);
        end;
      donebrowse := true;
    end;

  selrefreshbotline;
end;

procedure antikillart;

var
  subjectfromoops: char;
  i: integer;

begin
  subjectfromoops := onekeydef(
   'antikill: this group: <s>ubject <f>rom; always <S>ubject <F>rom; <o>ops',
   'sfSFo','o');

  if subjectfromoops<>'o' then
    begin
      if (subjectfromoops='s') or (subjectfromoops='S') then
        begin
          xwrites(#13);
          xclreol;
          addtoantikill('Subject',basesubjs[artnum],(subjectfromoops='S'));

{too much checking here - won't hurt anything but the clock}

          for i := 1 to numarts do
            if subjantikilled(basesubjs[i]) then
              begin
                setselected(i,true);
                indents[i] := indents[i] or 128;
              end;
        end
      else
        begin
          xwrites(#13);
          xclreol;
          addtoantikill('From',getfromaddr(artfrom),(subjectfromoops='F'));

{too much checking here - won't hurt anything but the clock}

          for i := 1 to numarts do
            if fromantikilled(fromsp^[i]) then
              begin
                setselected(i,true);
                indents[i] := indents[i] or 128;
              end;
        end;
    end;

  selrefreshbotline;
end;

procedure toggleheaders;

begin
  showallheaders := not showallheaders;
  firstblankline := maxint;
  rewindtopline(0);
end;

procedure rereadkillfiles;

begin
  readinkill(false);
  readinantikill(false);
  browserefresh;
end;

procedure quitbrowsenoupdate;

var
  doit: boolean;

begin
  doit := true;
  if confirmquit then
    doit := (onekey('are you SURE you want to quit?  <y>/<n>','yn')='y');
  if doit then
    begin
      xwriteln;
      if willupdatej then
        xwritelnss('quitting without updating join file for ',currgroup);
      xwriteln;
      donebrowse := true;
      donegroup := true;
      if willupdatej then
        begin
          currgroup := '';
          alreadyingroup := true;
          willupdatej := false;
        end;
    end
  else
    browserefresh;
end;

procedure nextgroupnoupdate;

var
  doit: boolean;

begin
  doit := true;
  if confirmnext then
    doit := (onekey(
     'are you SURE you want to jump directly to the next group?  <y>/<n>',
     'yn')='y');
  if doit then
    begin
      if willupdatej then
        begin
          xwriteln;
          xwritelns('join file not updated');
          xwriteln;
          willupdatej := false;
        end;
      donebrowse := true;
      donegroup := true;
    end
  else
    browserefresh;
end;

{}{} {might want to start at top of screen for this?}

procedure browsesearchnext;

var
  s: string;
  foundatline: integer;
  oldlastline: integer;

begin
  if arteof then
    donebrowse := true
  else
    begin
      oldlastline := lastlineshown;
      foundatline := -1;
      while not arteof and (foundatline<0) do
        begin
          getartl(s,cols-1,true);
          inc(lastlineshown);

{doesn't catch strings split over when you have long, wrapped lines! }
{ but this is not a big problem when breaking at work boundaries }

          if pos(uppersearchstring,upper(s))<>0 then
            foundatline := lastlineshown;
        end;
      if foundatline<0 then
        begin
          warn('not found');
          lastlineshown := oldlastline;
          browserefresh;
        end
      else
        rewindtopline(foundatline-2);
    end;
end;

procedure browsesearch;

var
  newsearchstring: string;

begin
  xclreolxy(1,lpp);
  xwrites('/');
  xreadlns(newsearchstring,max(cols-4,76),false);
  if newsearchstring='' then
    begin
      if asearchstring then
        browsesearchnext
      else
        browserefresh;
    end
  else
    begin
      asearchstring := true;
      uppersearchstring := upper(newsearchstring);
      browsesearchnext;
    end;
end;

procedure browsesearchagain;

begin
  if asearchstring then
    browsesearchnext;
end;

procedure searchdigest;

var
  s: string;
  foundatline: integer;
  oldlastline: integer;

begin
  if arteof then
    donebrowse := true
  else
    begin
      oldlastline := lastlineshown;
      foundatline := -1;
      while not arteof and (foundatline<0) do
        begin
          getartl(s,cols-1,true);
          inc(lastlineshown);
          if pos('--------',s)=1 then
            foundatline := lastlineshown;
        end;
      if foundatline<0 then
        begin
          warn('no more digest markers found');
          lastlineshown := oldlastline;
          browserefresh;
        end
      else
        rewindtopline(foundatline-2);
    end;
end;

procedure browsecommand;

var
  commandline: string;

begin
  xclreolxy(1,lpp);
  xwrites(':');
  xreadlns(commandline,max(cols-4,76),false);
  if commandline='' then
    browserefresh
  else
    begin
      if partialmatch(commandline,'help','h') then
        browsehelppage
      else if partialmatch(commandline,'?','?') then
        browsehelppage
      else if partialmatch(commandline,'post','p') then
        begin post; browserefresh; end
      else if partialmatch(commandline,'mail','m') then
        begin mail; browserefresh; end
      else if partialmatch(commandline,'follow','f') then
        follow
      else if partialmatch(commandline,'cancel','can') then
        begin cancel; browserefresh; end
      else if partialmatch(commandline,'quit','q') then
        quitbrowsenoupdate
      else
        begin warn('unrecognized command'); browserefresh; end
    end;
end;

procedure geteopkey;

var
  ch: char;
  needakey: boolean;
  dataline: string[80];

begin
  repeat
    needakey := false;
    if hasmouse then
      dataline := '--'+time+'--?=help =<>npu^$'' --'+numlefts+'--'
    else
      dataline := '--'+time+'--?=help--'+numlefts+'--';
    if arteof then
      dataline := dataline+'(Bottom)--';
    if length(dataline)+length(currgroup)>(cols-6) then
      dataline := '--'+
       copy(currgroup,length(currgroup)-((cols-6)-length(dataline)),255)+
       dataline
    else
      dataline := '--'+currgroup+dataline;
    xwritess(dataline,' ');
    ch := xreadkey;
    xwrites(^M);
    xclreol;
    ch := browsemap[ch];

    case ch of
      '?': browsehelppage;
      'n': donebrowse := true;
      'p': begin donebrowse := true; browsedir := -1; end;
      'b': browseback;
      'a': browseahead;
      'u': rewindtopline(lastlineshown-lpp-(lpp div 2));
      '<': rewindtopline(lastlineshown-lpp-(lpp div 2));
      ^B : rewindtopline(lastlineshown-lpp-(lpp div 2));
      '^': rewindtopline(0);
      '$': showlastline;
      #13: morelines(1);
      ' ': morelines(lpp-3);
      '>': morelines(lpp-3);
      ^F : morelines(lpp-3);
      'd': morelines(lpp div 2);
      'w': begin writeart; needakey := true; browserefresh; end;
      's': begin saveart; needakey := true; browserefresh; end;
      'r': begin replytoart; needakey := true; browserefresh; end;
      'm': begin mailart; needakey := true; end;
      'C': begin browsecopytofolder; needakey := true; end;
      'M': begin browsemovetofolder; needakey := true; end;
      'f': begin followtoart(''); needakey := true; end;
      'k': begin killart; needakey := true; browserefresh; end;
      'K': begin antikillart; needakey := true; browserefresh; end;
      'e': begin editart; needakey := true; end;
      'D': begin rot13ing := not rot13ing; browserefresh; end;
      'h': toggleheaders;
      ^L : browserefresh;
      ^R : begin rereadkillfiles; needakey := true; end;
{$ifdef maildelete}
      ^D : begin browsedeletemail; needakey := true; end;
{$endif}
      'Q': quitbrowsenoupdate;
      'N': nextgroupnoupdate;
      '!': begin shellout; browserefresh; end;
      '=': begin moreselecting := true; donebrowse := true; end;
      ^I : begin skipsection := true; donebrowse := true; end;
      '/': browsesearch;
      '.': browsesearchagain;
      ':': browsecommand;
      'A': begin addalias(artfrom); browserefresh; end;
      ^G : searchdigest;
      else needakey := true;
    end; {case}
  until donebrowse or not needakey;
end;

begin

  rot13ing := false;
  showallheaders := false;

  numlefts := itoa(numleft)+' more';
  if numleft=0 then
    numlefts := 'LAST';

  if not willupdatej then
    numlefts := numlefts+' (no update)';

  newbrowsescreen;
  nonactedleft := false;
  lastlineshown := 0;

  totlines := -1;
  firstblankline := maxint;
  asearchstring := false;
  uppersearchstring := '';

{ searchstring vars look redundant, but it's quicker to check a boolean }
{ than to do a string compare, I'm sure }

  artfn := groupdir+'\'+filenamesp^[artnum];

{don't get from fromsp^[] - need full name _and_ address for kill file}
  artfrom := getheaderline(artfn,'from:');

  artsubject := getheaderline(artfn,'subject:');
  artmessageid := getheaderline(artfn,'message-id:');
  artnewsgroups := getheaderline(artfn,'newsgroups:');

{$ifdef charset}
  if (uselocalcharset) then
    setreadencoding(
     getheaderline(artfn,'content-type:'),
     getheaderline(artfn,'content-transfer-encoding:'));
{$endif}
  
  assign(artf,artfn);

  donebrowse := false;  {artreset could change this}

  browserefresh;  {does an artreset itself}

  while not donebrowse do
    begin

{if we've already read off the end of the article, it's time for a new one}
      if arteof and not nonactedleft then
        donebrowse := true
      else
        begin

{otherwise indicate all has been seen and get a key}

          nonactedleft := false;
          geteopkey;
        end;
    end;

  artclose;
end;

procedure viewarts(lowest,highest: integer; updatehighestread: boolean);

var
  numleft: integer;
  i: integer;
  willupdatej: boolean;
  currsubj: subjstringt;

begin

  willupdatej := updatehighestread;

  currart := lowest;
  donegroup := false;
  browsedir := 1;
  browseonlysel := true;
  while not moreselecting and not donegroup do
    begin

      if skipsection then
        begin

          currsubj := basesubjs[currart];
          while (currart<=highest) and subjseq(currsubj,basesubjs[currart]) do
            inc(currart);

{short-circuit}

           while (currart<=highest) and not selected[currart] do
             inc(currart);
        end

      else

        if browseonlysel then
          while (currart>=lowest) and (currart<=highest) and
           not selected[currart] do
            inc(currart,browsedir);


      skipsection := false;
      browseonlysel := true;

      if currart>highest then
        donegroup := true;
      if currart<lowest then
        browsedir := 1;
      if (currart>=lowest) and (currart<=highest) then
        begin
          browsedir := 1;

{using k/b/a can mess this up any nice and simple way, so do it this way}
{will still show LAST when you're past the last selected one - so what}

          numleft := 0;
          for i := currart+1 to highest do
            if selected[i] then
              inc(numleft);

          browseart(currart,numleft,willupdatej);
          if (atow(filenamesp^[currart])>highestread) and willupdatej then
            highestread := atow(filenamesp^[currart]);
        end;

{ handle case of going to non-selected-also articles on extremes (first/last) }

{ allow `n' etc. to indicate finished reading, but not `a',`p',`b' }

      if ((browsedir>0) or (currart>lowest)) and
       (browseonlysel or (browsedir<0) or (currart<highest)) and
       not skipsection then
        inc(currart,browsedir);

    end;

{willupdatej can change to false part way through}

  if not willupdatej then
    highestread := 0;

end;

procedure selectandbrowse;

var
  i: integer;
  donepagesel: boolean;
  donegroupsel: boolean;
  selsubjs: array[1..maxlpp] of string;
  inkey,lastinkey: char;
  highestlegalsellet: char;
  highestlegalseldig: char;

function isselchar(ch: char): boolean;

begin
  isselchar :=
   ((ch<=highestlegalsellet) and (islower(ch))) or
   ((ch<=highestlegalseldig) and (isdigit(ch)));
end;

function selcharnum(ch: char): integer;

begin
  if isdigit(ch) then
    selcharnum := ord(ch)-ord('0')+26
  else
    selcharnum := ord(ch)-ord('a');
end;

procedure writetotalselln(lineno: integer; c: char);

var
  ycoord: integer;
  printsubj: string;
  i: integer;

begin
  if selected[lineno] then
    xhighvideo
  else
    xlowvideo;

  ycoord := lineno-topline+1+selheaderlines+1;

{other code keeps lineno-topline<36}

  if lineno-topline<26 then
    writexy(1,ycoord,chr(ord('a')+lineno-topline))
  else
    writexy(1,ycoord,chr(ord('0')+lineno-topline-26));

  xwrites(c);
  xwrites(nonastychar(copy(fromsp^[lineno],1,20)));

{$ifdef testsort}
  writexy(3,ycoord,'               ');
  writexy(3,ycoord,filenamesp^[lineno]);
{$endif}

  xgotoxy(24,ycoord);
  if sizeink[lineno]=255 then
    xwrites('huge')
  else
    xwriteiw(sizeink[lineno],4);

  printsubj := '';
  for i := 1 to (indents[lineno] and $f) do
    printsubj := printsubj+'>';
  printsubj := printsubj+selsubjs[lineno-topline+1];
  printsubj := nonastychar(printsubj);
  if printsubj='' then
    writexy(29,ycoord,'-')
  else
    writexy(29,ycoord,copy(printsubj,1,50));
  xlowvideo;
  xgotoxy(1,sellpp+selheaderlines+4);
end;

procedure clearstar;

begin
  if starbeside<>0 then
    begin
      writexy(2,starbeside-topline+1+selheaderlines+1,' ');
      starbeside := 0;
    end;
end;

procedure writeselln(lineno: integer);

begin
  clearstar;
  writetotalselln(lineno,' ');
end;

procedure writesellnstar(lineno: integer);

begin
  clearstar;
  writetotalselln(lineno,'*');
  starbeside := lineno;
end;

procedure selrefresh;

var
  i: integer;
  prevsubj: subjstringt;

begin
  prevsubj := '';
  xclrscr;
  xgotoxy(1,1);
  if hasmouse then
    begin
      xwritess(currgroup,' ');
      xwrites(mousecharsheader);
      xwrites('  Articles: ');
      xwritei(numarts);
      xclreol;
    end
  else
    xwritessis(currgroup,' Articles: ',numarts,'                      ');
  botline := topline-1;
  for i := topline to min(topline+sellpp-1,numarts) do
    begin
      if subjseq(basesubjs[i],prevsubj) then
        selsubjs[i-topline+1] := ''
      else
        selsubjs[i-topline+1] := basesubjs[i];
      prevsubj := basesubjs[i];
      writeselln(i);
      botline := i;
    end;

  selrefreshbotline;

{there will always be at least one letter, but not always any digits}

  highestlegalsellet := 'z';
  highestlegalseldig := chr(ord('0')-1);  {i.e., none are legal}

  if botline-topline<26 then
    highestlegalsellet := chr(ord('a')+botline-topline)
  else
    highestlegalseldig := chr(ord('0')+botline-topline-26);
end;

procedure togglekey(inkey: char);

var
  artnum: integer;

begin
  artnum := topline+selcharnum(inkey);
  if artnum<=botline then
    begin
      setselected(artnum,not selected[artnum]);
      if hasmouse and selected[artnum] then
        writesellnstar(artnum)
      else
        writeselln(artnum)
    end;

  selrefreshbotline;
end;

procedure selreversepage;

var
  artnum: integer;

begin
  for artnum := topline to botline do
    begin
      setselected(artnum,not selected[artnum]);
      writeselln(artnum);
    end;

  selrefreshbotline;
end;

procedure selclearall;

var
  artnum: integer;

begin
  for artnum := 1 to numarts do
    setselected(artnum,false);

  selrefreshbotline;
end;

procedure dostar(inkey: char);

var
  artnum: integer;
  currsubj: subjstringt;

begin
  artnum := topline+selcharnum(inkey);
  currsubj := basesubjs[artnum];
  inc(artnum);  {don't toggle it again!}
  while (artnum<=numarts) and subjseq(currsubj,basesubjs[artnum]) do
    begin
      if ((indents[artnum] and 128)=0) or not selected[artnum] then
        begin
          setselected(artnum,not selected[artnum]);
          if artnum<=botline then
            writeselln(artnum);
        end;
      inc(artnum);
    end;

  selrefreshbotline;
end;

procedure dodash(inkey: char);

var
  inkeyint: integer;
  artnum: integer;
  newkey: char;
  newkeyint: integer;

begin
  inkeyint := selcharnum(inkey);
  xclreolxy(1,lpp);
  xwritess(inkey,'-');
  newkey := xreadkeyextended(0,0,
   2+selheaderlines,(botline-topline)+2+selheaderlines);
  newkey := selmap[newkey];
  if isselchar(newkey) then
    begin
      newkeyint := selcharnum(newkey);
      if (newkeyint<botline-topline+1) and (newkeyint>=inkeyint) then
        for artnum := topline+inkeyint+1 to topline+newkeyint do {+1=togl once}
          begin
            if ((indents[artnum] and 128)=0) or not selected[artnum] then
              begin
                setselected(artnum,not selected[artnum]);
                writeselln(artnum);
              end;
          end;
    end;
  xclreolxy(1,lpp);

  selrefreshbotline;
end;

procedure backpage;

begin
  if (topline<>1) or (botline<>numarts) then
    begin
      if topline=1 then
        topline := numarts-((numarts-1) mod sellpp)
      else
        dec(topline,sellpp);
      selrefresh;
    end;
end;

procedure forwardpage;

begin
  if (topline<>1) or (botline<>numarts) then
    begin
      if botline=numarts then
        topline := 1
      else
        inc(topline,sellpp);
      selrefresh;
    end;
end;

procedure firstpage;

begin
  if topline<>1 then
    begin
      topline := 1;
      selrefresh;
    end;
end;

procedure lastpage;

begin
  if botline<>numarts then
    begin
      topline := numarts-((numarts-1) mod sellpp);
      selrefresh;
    end;
end;

procedure browseandreturn;

var
  anyselected: boolean;
  currart: integer;

begin
  anyselected := false;
  for currart := topline to botline do
    if selected[currart] then
      anyselected := true;

  if anyselected then
    begin
      viewarts(topline,botline,false);
{ if hit `=', don't reset selected[] }
      if not moreselecting then
        for currart := topline to botline do
          if selected[currart] then
            setselected(currart,false);
      if currgroup<>'' then
        selrefresh;
    end;

  moreselecting := false;
end;

procedure savewritehighlightedarts(fullheaders: boolean);

var
  thisallforgetit: char;
  lowart, highart: integer;
  anyselected: boolean;
  currart: integer;
  outfilen: string;
  outfile: text;
  illegal: boolean;
  doit: boolean;
  appendoverwriteforgetit: char;
  infn: string;
  inf: text;
  firstart: boolean;
  s: string;

{$ifdef charset}
  yn: char;
  foundblank: boolean;
  saveusinglocal: boolean;
{$endif}

begin
  thisallforgetit := 'a';

{don't ask unless there's more than one page}
  if (topline<>1) or (botline<>numarts) then
    thisallforgetit := onekeydef('<t>his page, <a>ll pages, <f>orget it',
     'taf','f');

  if thisallforgetit='t' then
    begin
      lowart := topline;
      highart := botline;
    end
  else
    begin
      lowart := 1;
      highart := numarts;
    end;

  anyselected := false;
  for currart := lowart to highart do
    if selected[currart] then
      anyselected := true;

  if not anyselected and (thisallforgetit<>'f') then
    begin
      warn('none selected');
      thisallforgetit := 'f';
    end;

  if thisallforgetit<>'f' then
    begin

      xclreolxy(1,lpp);
      xwrites('file name (blank to abort): ');
      outfilen := lastfilen;
      xreadlns(outfilen,cols-30,true);

      outfilen := ltrim(trim(outfilen));

      if outfilen<>'' then
        lastfilen := outfilen;

      if tildehome then
        if copy(outfilen,1,2)='~/' then
          outfilen := home+copy(outfilen,2,255);

      outfilen := unslash(outfilen);

      illegal := illegalfn(outfilen);
      doit := (outfilen<>'');

      if doit and not trusted then
        begin
          illegal := suspiciousfn(outfilen);
        end;

      if doit and illegal then
        begin
          warn('unable to use that filename');
        end;

      if doit and not illegal then
        begin
          if not trusted then
            outfilen := home+'\'+outfilen;

          appendoverwriteforgetit := 'o';

          if fexists(outfilen) then
            begin
              xclreolxy(1,lpp);
              appendoverwriteforgetit :=
               onekeydef('<O>verwrite <a>ppend <f>orget it','Oaf','f');
            end;

          if appendoverwriteforgetit<>'f' then
            begin


{$ifdef charset}
              saveusinglocal := false;
              if uselocalcharset then
                begin
                  yn := onekey('Use local charset <y>/<n>','yn');
                  saveusinglocal := (yn = 'y');
                end;
{$endif}

              assign(outfile,outfilen);

              if appendoverwriteforgetit='a' then
                begin
                  append(outfile);
                  writeln(outfile);
                  writeln(outfile,outputseparator);
                  writeln(outfile);
                end
              else
                begin
                  rewrite(outfile);
                end;

              firstart := true;

              for currart := lowart to highart do
                if selected[currart] then
                  begin
                    xclreolxy(1,lpp);
                    xwritesss('Working on ',filenamesp^[currart],'...');

                    infn := groupdir+'\'+filenamesp^[currart];

{$ifdef charset}
                    if (uselocalcharset and saveusinglocal) then
                      setreadencoding(
                       getheaderline(infn,'content-type:'),
                       getheaderline(infn,'content-transfer-encoding:'));
{$endif}

                    safereset(inf,infn);

                    if fileresult<>0 then
                      warn('could not open '+infn)
                    else
                      begin

                        if not firstart then
                          begin
                            writeln(outfile);
                            writeln(outfile,outputseparator);
                            writeln(outfile);
                          end;
                        firstart := false;

{$ifdef charset}
                        foundblank:= false;
{$endif}

                        while not eof(inf) do
                          begin

              {need to check fullheaders here!}

{}{}{}   {while not eoln read(inf,s); write(outf,s); readln(inf);writeln;}

                            readln(inf,s);

{$ifdef charset}
                            if foundblank and saveusinglocal then
                               linetolocal(s)
                            else
                               foundblank:= (s = '');
{$endif}

                            writeln(outfile,s);
                          end;
                        close(inf);
                      end;
                end;

              close(outfile);

            end;  {appendoverwriteforgetit}

        end;  {doit and not illegal}

    end;  {thisallforgetit}

  selrefresh;

end;

procedure writehighlightedarts;

begin
  savewritehighlightedarts(false);
end;

procedure savehighlightedarts;

begin
  savewritehighlightedarts(true);
end;

procedure unsubscribe;

var
  doit: boolean;
  nextgroup: string;

begin
  doit :=
   (onekey('are you SURE you want to unsubscribe?  <y>/<n>','yn')='y');
  if doit then
    begin
      nextgroup := getnextgroup;  {empty string is ok, too}
      xclreolxy(1,lpp);
      updatejoinunsubscribe;
      selclearall;
      currgroup := nextgroup;
      alreadyingroup := true;
      donegroupsel := true;
    end
  else
    selrefresh;
end;

procedure gotonewgroup;

var
  possgroup: string;

begin
  possgroup := '';
  pickagroup(possgroup);
  xclreolxy(1,lpp);
  if possgroup='' then
    begin
      selrefresh;
    end
  else
    begin
      selclearall;
      currgroup := possgroup;
      alreadyingroup := true;
      donegroupsel := true;
    end;
end;

procedure selprevgroup;

var
  prevgroup: string;
  foundgroup: string;

begin
  selclearall;
  prevgroup := '..invalid..';
  foundgroup := prevgroup;
  reset(joinf);
  repeat
    prevgroup := foundgroup;
    readln(joinf,foundgroup);
    foundgroup := getfirstw(foundgroup);
  until foundgroup=currgroup;
{}{should check eof - I guess}
  if prevgroup<>'..invalid..' then
    begin
      currgroup := prevgroup;
      donegroupsel := true;
      alreadyingroup := true;
    end;
{}{need more error checking here...}
{}{also, it just goes back 1 group - not to the one with something to read!}
end;

procedure selsearch;

var
  searchstring: string;
  i: integer;

begin
  xclreolxy(1,lpp);
  xwrites('=');
  xreadlns(searchstring,max(cols-4,76),false);
  if searchstring<>'' then
    begin
      searchstring := upper(searchstring);
      for i := 1 to numarts do
        if pos(searchstring,upper(fromsp^[i]))<>0 then
          setselected(i,true)
        else if pos(searchstring,upper(basesubjs[i]))<>0 then
          setselected(i,true);
    end;
  selrefresh;
end;

procedure selquit;

var
  doit: boolean;
  i: integer;

begin
  doit := true;
  if confirmquit then
    doit := (onekey('are you SURE you want to quit?  <y>/<n>','yn')='y');
  if doit then
    begin
      alreadyingroup := true;
      currgroup := '';
      donegroupsel := true;
      for i := 1 to numarts do
        setselected(i,false);
    end
  else
    selrefresh;
end;

procedure selhelppage;

var
  ch: char;

begin
  xclrscr;
  writexy(1,1,newsreadername+' '+newsreaderversion+
   ' - newsreader-under-development');
  writexy(1,2,'russell@alpha3.ersys.edmonton.ab.ca (941120)');
  writexy(1,4,'letter,digit - toggle whether or not to read that article');
  writexy(1,5,'c-f - highlight c through and including f');
  writexy(1,6,'g*  - highlight g and all with same subject');
  writexy(1,7,'space, enter - go to next screen (or start browsing at end)');
  writexy(1,8,'N   - go to next group (but browse first)');
  writexy(1,9,'X   - like N, but mark _all_ articles as read after');
  writexy(1,10,'P   - go to previous group      = select matching');
  writexy(1,11,'@   - reverse all selections on this page');
  writexy(1,12,'~   - clear all selections (all pages)');
  writexy(1,13,'^L  - refresh screen    ^R - reread kill and antikill files');
  writexy(1,14,'<   - go back a page (wraps)      ^ - first page');
  writexy(1,15,'>   - go forward a page (wraps)   $ - last page');
  writexy(1,16,'Z   - browse articles on this page (will not mark as read)');
  writexy(1,17,'W S - write/save selected articles (this or all pages)');
  writexy(1,18,'G   - goto group; can shorten each word (eg. c.b.waf)');
  writexy(1,19,'!   - shell escape       + - select antikilled articles');
  writexy(1,20,'U   - unsubscribe from this group');
  writexy(1,21,'?   - help               Q - quit');
  writexy(1,23,'press any key to return ');
  ch := xreadkey;
  selrefresh;
end;

procedure selcommand;

var
  commandline: string;

begin
  xclreolxy(1,lpp);
  xwrites(':');
  xreadlns(commandline,max(cols-4,76),false);
  if commandline='' then
    selrefresh
  else
    begin
      if partialmatch(commandline,'help','h') then
        selhelppage
      else if partialmatch(commandline,'?','?') then
        selhelppage
      else if partialmatch(commandline,'post','p') then
        begin post; selrefresh; end
      else if partialmatch(commandline,'mail','m') then
        begin mail; selrefresh; end
      else if partialmatch(commandline,'quit','q') then
        selquit
      else
        begin warn('unrecognized command'); selrefresh; end
    end;
end;

procedure selcatch;

begin
  donegroupsel := true;
  highestread := highestart;
end;

procedure selspace;

var
  artnum: integer;
  anyselected: boolean;

begin
  if makespacelikex and (botline=numarts) then
    begin
      anyselected := false;
      for artnum := 1 to numarts do
        if selected[artnum] then
          anyselected := true;
      if anyselected then
        selcatch
      else
        donepagesel := true;
    end
  else
    donepagesel := true;
end;

procedure selantikill(veryfirsttime: boolean);

var
  i: integer;
  firstnew: integer;  {firstnew=maxint <=> no articles antikilled}

begin
  firstnew := maxint;
  for i := 1 to numarts do
    if ((indents[i] and 128)<>0) and not selected[i] then
      begin
        if i<firstnew then
          firstnew := i;
        setselected(i,true);
      end;

  if firstnew<=numarts then
    begin
      if (firstnew>sellpp) and warnautoantikill then
        begin
          if veryfirsttime then
            selrefresh;
          warn('at least one article antikilled');
        end;

{do we need this anymore with the selrefreshbotline?}

      if not veryfirsttime then
        selrefresh;

    end;

  selrefreshbotline;
end;

procedure rereadkillfiles;

begin
  readinkill(false);
  readinantikill(false);
  if autoantikill then
    selantikill(false);
  selrefresh;
end;




begin
  for i := 1 to numarts do
    selected[i] := false;
  numselected := 0;

  donegroupsel := (numarts=0);
  lastinkey := ' ';
  topline := 1;

  if not donegroupsel and autoantikill then
    selantikill(true);

  moreselecting := false;
  skipsection := false;
  starbeside := 0;

  while not moreselecting and not donegroupsel and (currgroup<>'') do
    begin
      donepagesel := false;
      selrefresh;
      while not donegroupsel and not donepagesel and (currgroup<>'') do
        begin
          inkey := xreadkeyextended(0,0,
           2+selheaderlines,(botline-topline)+2+selheaderlines);
          inkey := selmap[inkey];

          if isselchar(inkey) then
            togglekey(inkey)
          else if (inkey='*') and isselchar(lastinkey) then
            dostar(lastinkey)
          else if (inkey='-') and isselchar(lastinkey) then
            dodash(lastinkey)
          else
            case inkey of
              '?': selhelppage;
              '<': backpage;
              ^B : backpage;
              '>': forwardpage;
              ^F : forwardpage;
              '^': firstpage;
              '$': lastpage;
              ' ': selspace;
              #13: selspace;
              'Z': browseandreturn;
              'W': writehighlightedarts;
              'S': savehighlightedarts;
              'U': unsubscribe;
              'G': gotonewgroup;
              'N': donegroupsel := true;
              '@': selreversepage;
              '~': begin selclearall; selrefresh; end;
              'X': selcatch;
              'P': selprevgroup;
              ^L : selrefresh;
              ^R : rereadkillfiles;
              '!': begin shellout; selrefresh; end;
              '+': selantikill(false);
              '=': selsearch;
              ':': selcommand;
              'Q': selquit;
            end; {case}

          lastinkey := inkey;
        end;

      if botline<numarts then
        inc(topline,sellpp)
      else
        donegroupsel := true;

{moreselecting is always false here}

      if donegroupsel then
        viewarts(1,numarts,true);

      if moreselecting then
        donegroupsel := false;

      moreselecting := false;

    end;

end;

end.
