/* a2b.c via atob: version 4.0
 * stream filter to change printable ascii from "btoa" back into 8 bit bytes
 * if bad chars, or Csums do not match: exit(1) [and NO output]
 *
 *  Paul Rutter     Joe Orost      DosPort WildHack
 *  philabs!per     petsd!joe      Severely!Mangled
 */

#include <stdio.h>

#include "ext_refs.c"

#define reg register

#define streq(s0, s1)  (strcmp(s0, s1) == 0)

#define times85(x)  ((((((x<<2)+x)<<2)+x)<<2)+x)

void fatal(void);
void decode(reg c);
void byteout(reg c);

long int Ceor = 0;
long int Csum = 0;
long int Crot = 0;
long int word = 0;
long int bcount = 0;

void fatal() {
    error(1, __FILE__, __LINE__, "bad format or Csum to atob\n");
}

#define DE(c) ((c) - '!')

void decode(reg c)
{
  if (c == 'z') {
    if (bcount != 0) {
      fatal();
    } else {
      byteout(0);
      byteout(0);
      byteout(0);
      byteout(0);
    }
  } else if ((c >= '!') && (c < ('!' + 85))) {
    if (bcount == 0) {
      word = DE(c);
      ++bcount;
    } else if (bcount < 4) {
      word = times85(word);
      word += DE(c);
      ++bcount;
    } else {
      word = times85(word) + DE(c);
      byteout((int)((word >> 24) & 255));
      byteout((int)((word >> 16) & 255));
      byteout((int)((word >> 8) & 255));
      byteout((int)(word & 255));
      word = 0;
      bcount = 0;
    }
  } else {
    fatal();
  }
}

FILE *tmp_file;

void byteout(reg c)
{
  Ceor ^= c;
  Csum += c;
  Csum += 1;
  if ((Crot & 0x80000000L)) {
    Crot <<= 1;
    Crot += 1;
  } else {
    Crot <<= 1;
  }
  Crot += c;
  putc(c, tmp_file);
}

main(int argc, char *argv[])
{
  reg c;
  reg long int i;
  char tmp_name[100];
  char buf[100];
  long int n1, n2, oeor, osum, orot;
  int fs_h_si=0, fs_h_so=0;

#if 0
  if (argc != 1) 
    error(2, __FILE__, __LINE__, "bad args to %s\n", argv[0]);
  sprintf(tmp_name, "/usr/tmp/atob.%x", getpid());
#else
  /* Filter function suppressed until binary I/O is provided */
  switch (argc) {
  default:
    error(1, __FILE__, __LINE__, "bad args to %s\n"
    "Usage:\nA2B  [InFile.B2A]  OutFile.Bin\n"
    "A2B        : converts ASCII encoded files back to binary format\n"
    "InFile.B2A : name of existing, ASCII encoded binary, file to convert\n"
    "OutFile.Bin: name for the file to get the decoded binary format\n"
    , argv[0]);
    break;
  case 3:
    fs_h_si=fs_chng(stdin , argv[1], "r"   );
  /*break;*/
  case 2:
    fs_h_so=fs_chng(stdout, argv[argc-1], OPN_WR);
    if (fs_h_si < 0 || fs_h_so < 0) 
        error(3, __FILE__, __LINE__, "bad args to %s\n", argv[0]);
    break;
  }
  tmpnam(tmp_name);
#endif
  tmp_file = fopen(tmp_name, OPN_W_R);
  if (tmp_file == NULL) {
    fatal();
  }
#if 0
  /* HERE it will make clusters disappear from the drive */
  unlink(tmp_name); /* Make file disappear */
#endif
  /*search for header line*/
  for (;;) {
    if (fgets(buf, sizeof buf, stdin) == NULL) {
      fatal();
    }
    if (streq(buf, "xbtoa Begin\n")) {
      break;
    }
  }

  while ((c = getchar()) != EOF) {
    if (c == '\n') {
      continue;
    } else if (c == 'x') {
      break;
    } else {
      decode(c);
    }
  }
  if(scanf("btoa End N %ld %lx E %lx S %lx R %lx\n",
         &n1, &n2, &oeor, &osum, &orot) != 5) {
    fatal();
  }
  if ((n1 != n2) || (oeor != Ceor) || (osum != Csum) || (orot != Crot)) {
    fatal();
  } else {
    /*copy OK tmp file to stdout*/;
    fseek(tmp_file, 0L, 0);
    for (i = n1; --i >= 0;) {
      putchar(getc(tmp_file));
    }
  }
  fclose(tmp_file);  /* unlink()ing it while it was open dropped clusters */
  unlink(tmp_name);  /* HERE the temp file is not needed */
  switch (argc) {
  case 3:
    fs_h_si=fs_rest( stdin , fs_h_si); 
  /*break;*/
  case 2:
    fs_h_so=fs_rest( stdout, fs_h_so);
    if (fs_h_si < 0 || fs_h_so < 0) 
        error(4, __FILE__, __LINE__, "bad args to %s\n", argv[0]);
    break;  
  default: break;  
  }
  exit(0);
return 0; /* Silence the warning without void'ing the function */
}
