/*
**  ABSDISKC.C - Functions to read and write absolute disk sectors
**               (these will work with all versions of DOS 2-5).
**
**  Public domain code by Bob Stout
**
**  NOTE: These functions work by calling absdisk() from SNIPPETS file,
**        ABSDISK.ASM.
*/

#include <stddef.h>

#if defined(__ZTC__)
 #define GetDrive(d) dos_getdrive(&d)
#elif defined(__TURBOC__)
 #define GetDrive(d) ((d) = getdisk() + 1)
#else /* assume MSC */
 #define GetDrive(d) _dos_getdrive(&d)
#endif

int absdisk(unsigned char  function,
            unsigned short drive,
            size_t         number_of_sectors,
            size_t         starting_sector,
            void *         sector_buffer);

int AbsDiskRead(unsigned short drive,
                size_t         num_of_sectors,
                size_t         sector,
                void *ptr)
{
      if (!drive)
            GetDrive(drive);
      return absdisk(0x25, drive, num_of_sectors, (unsigned)sector, ptr);
}

int AbsDiskWrite(unsigned short drive,
                size_t         num_of_sectors,
                size_t         sector,
                void *ptr)
{
      if (!drive)
            GetDrive(drive);
      return absdisk(0x26, drive, num_of_sectors, (unsigned)sector, ptr);
}
