/* b2a.c via btoa: version 4.0
 * stream filter to change 8 bit bytes into printable ascii
 * computes the number of bytes, and three kinds of simple checksums
 * incoming bytes are collected into 32-bit words, then printed in base 85
 * exp(85,5) > exp(256,4) == exp(2,32) 
 * the ASCII characters used are between '!' and 'u'
 * 'z' encodes 32-bit zero; 'x' is used to mark the end of encoded data.
 *
 *  Paul Rutter     Joe Orost      DosPort WildHack
 *  philabs!per     petsd!joe      Severely!Mangled
 *
 *  WARNING: this version is not compatible with the original as sent out
 *  on the net.  The original encoded from ' ' to 't'; which cause problems
 *  with some mailers (stripping off trailing blanks).
 */
#include <stdio.h>
#include "ext_refs.c"

#define reg register
#define MAXPERLINE 78

void encode(reg c);
void wordout(reg long int word);
void charout(int c);

long int Ceor = 0;
long int Csum = 0;
long int Crot = 0;
long int ccount = 0;
long int bcount = 0;
long int word;

#define EN(c)   (int) ((c) + '!')

void encode(reg c)
{
  Ceor ^= c;
  Csum += c;
  Csum += 1;
  if ((Crot & 0x80000000L)) {
    Crot <<= 1;
    Crot += 1;
  } else {
    Crot <<= 1;
  }
  Crot += c;

  word <<= 8;                   /* Pack 4 characters into 32 bit word */
  word |= c;
  if (bcount == 3) {
    wordout(word);
    bcount = 0;
  } else {
    bcount += 1;
  }
}

void wordout(reg long int word)
{
  if (word == 0) {
    charout('z');
  } else {
    reg int tmp = 0;

    if(word < 0) {  /* Because some don't support unsigned long */
      tmp = 32;
      word = word - ((long)85 * 85 * 85 * 85 * 32);
    }
    if(word < 0) {
      tmp = 64;
      word = word - ((long)85 * 85 * 85 * 85 * 32);
    }
    charout(EN((word / ((long)85 * 85 * 85 * 85)) + tmp));
    word %= ((long)85 * 85 * 85 * 85);
    charout(EN(word / ((long)85 * 85 * 85)));
    word %= ((long)85 * 85 * 85);
    charout(EN(word / (85 * 85)));
    word %= (85 * 85);
    charout(EN(word / 85));
    word %= 85;
    charout(EN(word));
  }
}

void charout(int c)
{
  putchar(c);
  ccount += 1;
  if (ccount == MAXPERLINE) {
    putchar('\n');
    ccount = 0;
  }
}

main(int argc, char *argv[])
{
  reg c;
  reg long int n;
  int fs_h_si, fs_h_so;

#if 0
  if (argc != 1) {
    error(2, __FILE__, __LINE__, "bad args to %s\n", argv[0]);
  }
#else
  /* Filter function suppressed until binary I/O is provided */
  switch (argc) {
  default:
    error(1, __FILE__, __LINE__, "bad args to %s\n"
    "Usage:\nB2A  InFile.Bin  [OutFile.B2A]\n"
    "B2A        : converts Binary images to printing ASCII characters\n"
    "InFile.Bin : name of the existing, binary format, file to convert\n"
    "OutFile.B2A: name for the file to get the ASCII encoded format\n"
    , argv[0]);
    break;
  case 3:
    fs_h_so=fs_chng(stdout, argv[2], "w"   );
  /*break;*/
  case 2:
    fs_h_si=fs_chng(stdin , argv[1], OPN_RD);
    if (fs_h_si < 0 || fs_h_so < 0) 
        error(3, __FILE__, __LINE__, "bad args to %s\n", argv[0]);
    break;
  }
#endif
  printf("xbtoa Begin\n");
  n = 0;
  while ((c = getchar()) != EOF) {
    encode(c);
    n += 1;
  }
  while (bcount != 0) {
    encode(0);
  }
  /* n is written twice as crude cross check*/
  printf("\nxbtoa End N %ld %lx E %lx S %lx R %lx\n", n, n, Ceor, Csum, Crot);
  switch (argc) {
  case 3:
    fs_h_so=fs_rest( stdout, fs_h_so);
  /*break;*/
  case 2:
    fs_h_si=fs_rest( stdin , fs_h_si);
    if (fs_h_si < 0 || fs_h_so < 0)
        error(4, __FILE__, __LINE__, "bad args to %s\n", argv[0]);
    break;
  default: break;
  }
  exit(0);
return 0; /* Silence the warning without void'ing the function */
}

/* ext_refs.c
 * debugging, provide prototypes, single error exit,
 * redirect the first two arguments in place of stdin/out,
 * open files in binary mode (changed to OPN_??? to reflect that)
 * SEEKING: a method to turn this back into a filter, (binary stdin/out)
 *                                 DosPort WildHack
 *                                 Severely!Mangled
 */
#include <stdlib.h>
#include <string.h>
#include <io.h>

#define OPN_RD "rb"
#define OPN_WR "wb"
#define OPN_W_R "w+b"
#if 0
extern unsigned _stklen  = 1024 * 4;
extern unsigned _heaplen = 1024 * 0;
#endif
int error(int code, char *file, int line, char *msg,...);
int error(int code, char *file, int line, char *msg,...)
{
    va_list argptr;
    fprintf(stderr,"\n?Error(%d) %s # %d - ",code,file,line);
    va_start(argptr, msg);
    vfprintf(stderr, msg, argptr);
    va_end(argptr);
    fputc('\n',stderr);
    exit(code);
return 0;
}
int fs_chng(FILE *ChgStr, char *NewPath, char *OpenMode);
int fs_chng(FILE *ChgStr, char *NewPath, char *OpenMode)
{
    int   DupHndl=dup(fileno(ChgStr));    /* Save current handle info    */
    freopen(NewPath, OpenMode, ChgStr);   /* Redirect stream to new file */
    return DupHndl;                       
}
int fs_rest(FILE *RstStr, int DupHndl);
int fs_rest(FILE *RstStr, int DupHndl)
{
    int Err = fileno(RstStr);           /* Save the handle across fclose */
    fflush(RstStr); /*fclose(RstStr);*/ /* Close the redefined stream &  */
    Err=dup2(DupHndl,Err);              /* Restore the prior stream info */
    close(DupHndl);                     /* Discard the saved file handle */
    return Err;
}
