/*
     Module:      DelSrch (File Delete Search)
     Version:     1.01  19-Sep-1989
     Language:    ANSI C with MS-DOS extensions

     This module will search subdirectories for files to be deleted. It can
     query the user as to which files selected should be deleted.

     Written by Scott Robert Ladd. No rights reserved.
*/

#if defined(__TURBOC__)
    #include <dir.h>
#elif defined(LATTICE)
    #include <stdio.h>
#else
    #include <direct.h>
#endif
#include <dos.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include "filesrch.h"

#if defined(M_I86SM) || defined(M_I86MM) || defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__) || defined(SPTR)
    #define SMALL_DATA_PTRS
#endif

#define MAX_SPEC 128

/* global data */

static char * orig_spec;
static char   srch_attr;
static void (* file_func)(char * dir, FILE_DATA * fd);

static union  REGS  regs;
static struct SREGS sregs;

static unsigned old_dta_seg;
static unsigned old_dta_off;

/* local function prototypes */

static void sub_find_work(char * dir_spec);
static void set_dta(void * new_dta);
static void reset_dta(void);

/* actual program code! */

void sub_find(char * spec,
              char attr,
              char * dir,
              void (* handler)(char * dir, FILE_DATA * fd))
{
      char * start_dir;
      char * orig_dir;

      if (spec != NULL)
            orig_spec = strdup(spec);
      else  orig_spec = "*.*";

      srch_attr = attr;
      file_func = handler;

      if (dir != NULL)
      {
            orig_dir = malloc(MAX_SPEC);
            getcwd(orig_dir,MAX_SPEC);
            start_dir = strdup(dir);
      }
      else
      {
            orig_dir = NULL;
            start_dir = malloc(MAX_SPEC);
            getcwd(start_dir,MAX_SPEC);
      }

      sub_find_work(start_dir);

      if (orig_dir != NULL)
      {
            chdir(orig_dir);
            free(orig_dir);
      }

      free(start_dir);
}

static void sub_find_work(char * dir_spec)
{
      typedef struct dir_entry {
            char * direct;
            struct dir_entry * next;
      } DIR_ENTRY;

      DIR_ENTRY * first_dir, * temp_dir, * cur_dir;
      char * dir_buf, * work_dir;
      FILE_DATA file;
      int res;

      work_dir = malloc(MAX_SPEC);

      first_dir = malloc(sizeof(DIR_ENTRY));
      cur_dir = first_dir;
      cur_dir->next = NULL;

      chdir(dir_spec);
      getcwd(work_dir,64);

      res = find_first("*.*",(char)0xFF,&file);

      while (!res)
      {
            if (wild_match(file.name, orig_spec) && (file.attrib & srch_attr))
            {
                  file_func(work_dir,&file);
            }

            if (((file.attrib & 0x10) == 0x10) && (file.name[0] != '.'))
            {
                  cur_dir->direct = strdup(file.name);
                  cur_dir->next   = malloc(sizeof(DIR_ENTRY));
                  cur_dir         = cur_dir->next;
                  cur_dir->next   = NULL;
            }

            res = find_next(&file);
      }

      dir_buf = malloc(MAX_SPEC);
      cur_dir = first_dir;

      while (cur_dir->next != NULL)
      {
            chdir(work_dir);
            chdir(cur_dir->direct);

            getcwd(dir_buf,128);
            sub_find_work(dir_buf);

            temp_dir = cur_dir;
            cur_dir  = cur_dir->next;

            free(temp_dir->direct);
            free(temp_dir);
      }
}

int wild_match(char * name, char * tmpl)
{
      strupr(name);
      strupr(tmpl);

      while ((*name && *name != '.') || (*tmpl && *tmpl != '.'))
      {
            if ((*name != *tmpl) && (*tmpl != '?'))
            {
                  if (*tmpl != '*')
                        return 0;
                  else
                  {
                        while (*name && *name != '.')
                              name++;
                        while (*tmpl && *tmpl != '.')
                              tmpl++;
                        break;
                  }
            }
            else
            {
                  name++;
                  tmpl++;
            }
      }

      if (*name == '.')
            name++;

      if (*tmpl == '.')
            tmpl++;

      while (*name || *tmpl)
      {
            if ((*name != *tmpl) && (*tmpl != '?'))
            {
                  if (*tmpl != '*')
                        return 0;
                  else  return 1;
            }
            else
            {
                  name++;
                  tmpl++;
            }
      }

      return 1;
}

int find_first(char * spec, char attrib, FILE_DATA * fd)
{
      int res;

      set_dta(fd);

      regs.h.ah = 0x4E;
      regs.x.cx = (unsigned)attrib;

#if defined(SMALL_DATA_PTRS)
      regs.x.dx = (unsigned)spec;
 #if defined(LATTICE)
      res = intdos(&regs,&regs);
 #else
      intdos(&regs,&regs);
 #endif
#else
      segread(&sregs);
      sregs.ds  = FP_SEG(spec);
      regs.x.dx = FP_OFF(spec);
 #if defined(LATTICE)
      res = intdosx(&regs,&regs,&sregs);
 #else
      intdosx(&regs,&regs,&sregs);
 #endif
#endif

#if !defined(LATTICE)
      res = regs.x.cflag;
#endif

      reset_dta();

      return res;
}

int find_next(FILE_DATA * fd)
{
      int res;

      set_dta(fd);

      regs.h.ah = 0x4F;

#if defined(LATTICE)
      res = intdos(&regs,&regs);
#else
      intdos(&regs,&regs);
      res = regs.x.cflag;
#endif

      reset_dta();

      return res;
}

static void set_dta(void * new_dta)
{
      regs.h.ah = 0x2F;
      intdosx(&regs,&regs,&sregs);

      old_dta_seg = sregs.es;
      old_dta_off = regs.x.bx;

      regs.h.ah = 0x1A;

#ifdef SMALL_DATA_PTRS
      regs.x.dx = (unsigned)(new_dta);
      intdos(&regs,&regs);
#else
      sregs.ds  = FP_SEG(new_dta);
      regs.x.dx = FP_OFF(new_dta);
      intdosx(&regs,&regs,&sregs);
#endif
}

static void reset_dta(void)
{
      segread(&sregs);

      regs.h.ah = 0x1A;
      sregs.ds  = old_dta_seg;
      regs.x.dx = old_dta_off;

      intdosx(&regs,&regs,&sregs);
}
