/*
     Header:      DelSrch (File Delete Search)
     Version:     1.00  02-Apr-1989
     Language:    ANSI C with MS-DOS extensions

     This module will search subdirectories for files to be deleted. It can
     query the user as to which files selected should be deleted.

     Written by Scott Robert Ladd. No rights reserved.
*/

#if !defined(FILESRCH_H)
#define FILESRCH_H 1

#if defined(_MSC) || defined(_QC) || defined(__WATCOMC__)
    #pragma pack(1)
#endif

typedef
  struct
    {
    char     reserved[21];
    char     attrib;
    unsigned time;
    unsigned date;
    long     size;
    char     name[13];
    }
  FILE_DATA;

#if defined(_MSC) || defined(_QC) || defined(__WATCOMC__)
    #pragma pack()
#endif

/* attribute bit masks */

#define ATTR_READONLY   0x01 /* read only */
#define ATTR_HIDDEN     0x02 /* hidden */
#define ATTR_SYSTEM     0x04 /* system */
#define ATTR_VOLABEL    0x08 /* volume label */
#define ATTR_DIRECTORY  0x10 /* directory */
#define ATTR_ARCHIVE    0x20 /* archive */
#define ATTR_ALL        0x3F /* all files */

/* prototypes */

void sub_find(char * spec,
              char attrib,
              char * top_dir,
              void (* handler)(char * dir, FILE_DATA * fd));

int wild_match(char * name, char * tmpl);

int find_first(char * spec, char attrib, FILE_DATA * fd);

int find_next(FILE_DATA * fd);

#endif
