/*
** GETSTRNG.C -- Demonstation of dynamic memory allocation to
**               receive string of unknown length.
** Ron Sires 1/31/89, released to the public domain.
*/
 
#include <stdlib.h>
#include <stdio.h>
 
#define BLOCKSIZ    16
 
char *getstring(void)

/* Be sure to free the char * you get from getstring()!!)  */
{
    int   i, bufsize=BLOCKSIZ, newchar;
    char *buffer, *newbuf;
 
    /* Get initial BLOCKSIZ buffer to receive string.   */
    if ((buffer = (char *) malloc(BLOCKSIZ)) == NULL)
    {
        puts("No room in memory for string.");
        return NULL;
    }
    /* Get chars from keyboard and put them in buffer.  */
    for (i = 0; ((newchar = getchar()) != EOF) && (newchar != '\n')
      && (newchar != '\r'); /* No revision part */ )
    {
        buffer[i++] = (char) newchar;
        if (i >= bufsize - 1)
        {
            /* If buffer is full, resize it. */
            newbuf = (char *) realloc(buffer, bufsize + BLOCKSIZ);
            if (newbuf == NULL)
            {
                puts("Not enough room in memory for string.");
                buffer[i] = '\0';  /* Add terminator to partial string */
                return buffer;
            }
            buffer = newbuf;
            bufsize += BLOCKSIZ;
        }
    }
    buffer[i] = '\0';   /* Tack on a null-terminator. */
    return buffer;
}
