/*
**  GET_DIRS.C - build a linked list of directories on a drive
**
**  public domain by Mike Gillen
*/

struct dirs
{
      char path[MAXPATH];                /* directory name         */
      struct dirs *nxtdir, *prvdir;      /* next and prev pointers */
};

typedef struct dirs DIRS, *DIRPTR;
DIRPTR dfirst, dprev, dnow, dlast;

/*
** get_dirs() is called to find all of the directories on the current
** drive.  It in turn calls gdir() after creating the first structure
** that coresponds to the root directory.
*/

void get_dirs( void )
{
      char work_dir[MAXPATH];

      getcwd( work_dir, MAXPATH );
      chdir( "\\" );
      if( (dnow = (DIRPTR) malloc( sizeof( DIRS ) ) ) == NULL )
            mem_err( 52 );                /* memory error function */
      dfirst = dlast = dnow->prvdir = dprev = dnow;
      dnow->nxtdir = (DIRPTR) NULL;
      strcpy( dnow->path, " :\\" );
      dnow->path[0] = work_dir[0];
      gdir( 1 );
      dlast = dnow;
      dnow->nxtdir = dnow;
      dnow = dfirst;
      dnow->prvdir = dnow;
      chdir( work_dir );
} /* end get_dirs() */

/*
** gdir() uses recursion to find all of the directories on the current
** drive.  After building the linked list of directories, it returns
** to get_dirs().
*/

void gdir( int lev )
{
      struct ffblk dirinfo;

      if( findfirst( "*.*", &dirinfo, FA_DIREC | FA_HIDDEN ) )
      {
            chdir( ".." );
            return;
      }
      do
      {
            if( !( dirinfo.ff_attrib & FA_DIREC ) )
                  continue;
            if( dirinfo.ff_name[0] == '.' )     /* optional to skip . dirs */
                  continue;
            if( (dnow = (DIRPTR) malloc( sizeof( DIRS ) ) ) == NULL )
                  mem_err( 53 );                /* memory error function */
            dprev->nxtdir = dnow;
            dnow->prvdir = dprev;
            dnow->nxtdir = (DIRPTR) NULL;
            getcwd( dnow->path, MAXPATH );
            strcpy( dnow->path, dnow->path );
            if( dnow->path[ strlen( dnow->path ) - 1 ] != '\\' )
                  strcat( dnow->path, "\\" );
            strcat( dnow->path, dirinfo.ff_name );
            dprev = dnow;
            chdir( dnow->path );
            gdir( lev + 1 );  /* recursive call */
      }
      while( !findnext( &dirinfo ) );
      if( lev != 1 )
            chdir( ".." );
} /* end gdir() */
