/*********************************************************************/
/*                                                                   */
/*  This Program Written By Paul Edwards.                            */
/*  Dedicated to the public domain.                                  */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*  hexdump - dump a file.                                           */
/*                                                                   */
/*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

static void dodump(FILE *fp, int count);
static void skipb(FILE *fp, int start);

main(int argc, char **argv)
{
      FILE *fp;
      int start, count;

      if (argc < 2)
      {
            printf("hexdump - must pass name of file to dump\n");
            return (EXIT_FAILURE);
      }
      if (argc > 2)
            start = atoi(*(argv+2));
      else  start = -1;
      if (argc > 3)
            count = atoi(*(argv+3));
      else  count = -1;
      fp = fopen(*(argv+1),"rb");
      if (fp == NULL)
      {
            printf("unable to open file %s for input\n",*(argv+1));
            return (EXIT_FAILURE);
      }
      skipb(fp,start);
      dodump(fp,count);
      return (EXIT_SUCCESS);
}

static void dodump(FILE *fp, int count)
{
      int c,x=0,pos1,pos2;
      char prtln[100];

      while (((c = fgetc(fp)) != EOF) && (x != count))
      {
            if (x%16 == 0)
            {
                  memset(prtln,' ',sizeof prtln);
                  sprintf(prtln,"%0.6X   ",x);
                  pos1 = 8;
                  pos2 = 45;
            }
            sprintf(prtln+pos1,"%0.2X",c);
            if (isprint(c))
                  sprintf(prtln+pos2,"%c",c);
            else  sprintf(prtln+pos2,".");
            pos1+=2;
            *(prtln+pos1) = ' ';
            pos2++;
            if (x%4 == 3)
                  *(prtln+pos1++) = ' ';
            if (x%16 == 15)
                  printf("%s\n",prtln);
            x++;
      }
      if (x%16 != 15)
            printf("%s\n",prtln);
      return;
}

static void skipb(FILE *fp, int start)
{
      int x=0;

      if (start < 0)
            return;
      while (x < start)
      {
            fgetc(fp);
            x++;
      }
      return;
}
