/*
**  ISFILE.C - determine if a file handle is associated with a file
**
**  public domain by Bob Jarvis
**
**    Returns:    1 - handle is associated with a file
**                0 - handle is associated with a device
**               -1 - error
*/

#include <stdio.h>
#include <dos.h>

int isfile(int handle)
{
      union REGS regs;

      regs.x.ax = 0x4400;
      regs.x.bx = handle;

      intdos(&regs, &regs);

      if(regs.x.cflag == 0)               /* carry flag not set */
      {
            if((regs.x.dx & 0x80) == 0)
                  return 1;
            else  return 0;
      }
      else  return -1;                    /* error - return -1  */
}

int isFILE(FILE *fp)
{
      return isfile(fileno(fp));
}

#ifdef TEST

int main()
{
        if(isFILE(stdout))
                printf("stdout is associated with a file\n");
        else    printf("stdout is NOT associated with a file\n");
}

#endif /* TEST */
