/*
Program    : ISSUE
Author     : J.C. Weilandt II
Compiler   : Microsoft C 3.00
Library    : Microsoft, Greenleaf, Weilandt Software International
Date       : 12-28-85
Last Update: 12-29-85

Function   : ISSUE provides the capability of executing EXE and COM
             files against a user provided file mask.  ISSUE therefore
             provides file mask (eg *.*, ????????.*) support for
             modules that generally only operate on single files.

Syntax     : ISSUE command file_mask parms
                   command   - any EXE or COM file
                   file_mask - DOS ambiguous file specification
                   parms     - parameters to be included

Status     : FreeWare
*/

/*-------------------------------------------------------------------*/
/*   ISSUE -- This is a C Language routine that processes commands   */
/*            across a specified file mask.                          */
/*                                                                   */
/*  Author: J.C. Weilandt II  Date: 12-28-85  Update: 12-29-85       */
/*-------------------------------------------------------------------*/
#define LINT_ARGS 1                /* Enable Strong Type-Checking    */
#include <stdio.h>                 /* File Definitions, etc          */
#include <process.h>               /* Multi-tasking definitions      */
main(number,name)                  /* Initiate main function         */
  int number;                      /* Number of parms                */
  char *name[];                    /* Array of parameters            */
  {                                /* Open main function             */
    FILE *stream;                  /* Define a file pointer          */
    long position = 0;             /* Hold file position             */
    char dest[15];                 /* Destination file_name holder   */
    char odest[15];                /* Old File_Name holder           */
    char cstring[128];             /* Command String Holder          */
    unsigned attr = 0;             /* Attribute for file search      */
    int stat;                      /* DOS Search status code byte    */
    int error;                     /* Declare test integers          */
    char mstring[15];              /* System Mask Holder             */
    char pstring[50];              /* System Parameter Holder        */
    int count = 0;                 /* Count of files processed       */
    int pindex = 0;                /* Parameter string index         */
    int poffset = 0;               /* Parameter offset value         */
    clear();                       /* Clear the screen               */
    printf("              ===> Weilandt Software International <===");
    printf("\n");                  /* Jump down a line               */
    printf("              ===> Issue Command Processor -- 1985 <===");
    printf("\n\n");                /* Jump two lines down            */
    if (number < 2)                /* Q.Parameters passed ??         */
      {                            /*   Nope, open error procedure   */
        printf("Format is:  ISSUE command file_mask parms\n"); /* MS */
        printf("  command:  the command you want to execute\n"); /*  */
        printf("  file_mask: file mask (eg *.*, etc.)\n"); /* MSG    */
        printf("  parms  :  command parameters\n"); /* Message       */
        exit(12);                  /*   Terminate with error         */
      }                            /*   Terminate error procedure    */
    strcpy(odest," ");             /* Initial old destination        */
    strcpy(mstring,"*.*");         /* Load default mask              */
    strcpy(pstring," ");           /* Load default parameter         */
    if (number > 2)      strcpy(mstring,name[2]); /* Load mask       */
    if (number > 3)                /* Q. Do we have parameters ?     */
      {                            /*    Yes, open parameter process */
        pindex = 4;                /*    Load parameter index        */
        while (pindex <= number)   /*    Process all parameters      */
          {                        /*    Open inner loop             */
            poffset = pindex - 1;  /*    Parm block offset value     */
            strcat(pstring,name[poffset]); /* Move in parameter      */
            strcat(pstring," ");   /*    Space between parameters    */
            pindex++;              /*    Increment index value       */
          }                        /*    Terminate while process     */
      }                            /*    Terminate if process        */
    if ((stream = fopen("$$WSI$$$.$$$","a")) == NULL) /* Open file   */
      {                            /* If open failed do this         */
        printf("Temporary File Creation Failed -- Aborting"); /* MSG */
        exit(12);                  /* Terminate Procedure            */
      }                            /* Terminate Failure Logic        */
    stat = dosfirst(mstring,attr,dest); /* Read DOS Directory        */
    while (!stat)                  /* Q. Was the read successful ??  */
      {                            /*    Yes, open inner procedure   */
        fprintf(stream,"%s\n",dest); /*  Write file_name to output   */
        stat = dosnext(mstring,attr,dest); /* Read next Dir Entry    */
      }                            /*    Terminate inner procedure   */
    fclose(stream);                /* Close the output file          */
    if ((stream = fopen("$$WSI$$$.$$$","r")) == NULL) /* Open file   */
      {                            /* If open failed do this         */
        printf("Temporary File Open Has Failed -- Aborting"); /* MSG */
        exit(12);                  /* Terminate Procedure            */
      }                            /* Terminate Failure Logic        */
    while (!feof(stream))          /* Q. Not end-of-file yet ??      */
      {                            /*    Yes, open inner procedure   */
        fseek(stream,position,0);  /*    Position the file pointer   */
                                   /* => FSEEK and FTELL Processing  */
                                   /* => required because SPAWN      */
                                   /* => resets the file pointers    */
        fgets(dest,15,stream);     /*    Read next file entry        */
        position = ftell(stream);  /*    Get new file position       */
        ctrans(dest,'\n',' ');     /*    Translate newline to blank  */
        if (strcmp(dest,odest) == 0) break; /* Get out if done       */
        strcpy(odest,dest);        /*    Copy dest to odest          */
        printf("Executing ==> %s %s %s\n", name[1], dest, pstring);
        count++;                   /* Increment file counter         */
        strcpy(cstring,name[1]);   /* Start DOS Command String Build */
        strcat(cstring," ");       /* Put in a blank                 */
        strcat(cstring,dest);      /* Move in the filename           */
        strcat(cstring," ");       /* Put in a blank                 */
        strcat(cstring,pstring);   /* Move in the Parameters         */
        error = system(cstring);   /* Execute the Dos Command        */
      }                            /*    Terminate inner loop        */
    fclose(stream);                /* Close the input file           */
    system("erase $$WSI$$$.$$$");  /* Delete the input file          */
    printf("\nTotal Files Processed: %d\n", count); /* Final Message */
    exit(0);                       /* Set good RC                    */
  }
