/*-------------------------[ jmalloc.h ]------------------------*/
/*                 drop-in for malloc with diags                */
/*--------------------------------------------------------------*/

typedef struct mlist
{
    struct mlist *NextLink;         /* link to next struct */
    char *MAddr;                    /* address assigned    */
    unsigned MSize;                 /* size allocated      */
} MLINK;

/*--------------------------------------------------------------*/
/*--------------------[ public prototypes ]---------------------*/
/*--------------------------------------------------------------*/

#ifdef DBUG
void *JMalloc(unsigned size);
void *JCalloc(unsigned size, unsigned sizeach);
void j_free(void *AllocAddr, char *file, int line);
#define JFree(a) j_free(a, __FILE__, __LINE__)
int JMemcheck(void);
#else
#define JMalloc(a) malloc(a)
#define JCalloc((a), (b)) calloc((a), (b))
#define JFree(a) free(a)
#define JMemcheck(a)
#endif

/*--------------------------------------------------------------*/
/*---------------------[ public variables ]---------------------*/
/*--------------------------------------------------------------*/

extern MLINK *MalTop;
