/*
** This program was written to strip out all the Form Feeds in text
** files. I hate it when people waste my printer paper! I also like
** to post News Letters for my Users on my BBS, and imbedded Form
** Feeds screw things up bad when trying to view the News Letters
** (like FIDONEWS!) Hope you like it!
**
** KILL FORM FEEDS v1.1 by Jerry Gore (Public domain?)
** Version 1.2 by Erik VanRiper on 12/22/91 Public Domain!
**
** This is basically a complete re-write.
**
** Reads a text file and makes a duplicate with NO Form Feed
** characters! The duplicates name will default to temp.txt. Form
** Feed characters are replaced with a space (decimal 32).
**
** Usage: KILLFF FILE.TXT [TEMP.TXT]
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define BUFSIZE 32768

main(int argc, char *argv[])
{
   FILE *in, *out;              /* input and output files        */
   char name[80],               /* name of file to be fixed      */
        temp[80] = "temp.txt",  /* output file name              */
        *buf,                   /* buffer we will use to write   */
        *s;                     /* searching pointer             */
   unsigned int bad,            /* check to see if write ok      */
                num;            /* number of bytes read          */

   printf("\nKILL FORM FEEDS v1.1 by Jerry Gore");
   printf("\nRevised by Erik VanRiper (v1.2)\n\n");

   if(argc < 2)                              /* usage info       */
   {
      printf("Usage:\n\tKILLFF input_file [output_file]\n");
      return(0);                             /* return to OS     */
   }

   strcpy(name,argv[1]);                     /* input filename   */
   if(argc == 3) strcpy(temp,argv[2]);       /* outfile name     */

   if((buf = calloc(BUFSIZE, 1)) == NULL)/* malloc a large buffer  */
   {
      printf("\nOut of memory.  :-(\n");
      return(0);                             /* return to OS     */
   }
   if((in = fopen(name,"r")) == NULL)        /* Open in file     */
   {
      printf("\nCan't Open Input File %s!",name);
      free(buf);                             /* free memory      */
      return(0);                             /* return to OS     */
   }
   if((out = fopen(temp,"wt")) == NULL)      /* open out file    */
   {
      printf("\nCan't Open File %s",temp);
      fclose(in);                            /* close in file    */
      free(buf);                             /* free memory      */
      return(0);                             /* return to OS     */
   }

   printf("Input file: %s Output file: %s\n",name,temp);

   /* read in file while chars to read */

   num = fread(buf,sizeof(char *),BUFSIZE-1,in);
   buf[num] = '\0';
   while(num > 0)
   {
      while((s = strchr(buf, '\x0C')) != NULL) /* look for FF    */
         *s = '\x20';                        /* change to space  */

      bad=fwrite(buf,sizeof(char *),num,out); /* write out buf   */
      if(bad != num)                         /* error            */
      {
         printf("\nCan't Write to %s ", temp);
         fclose(in);                         /* close in file    */
         fclose(out);                        /* close out file   */
         free(buf);                          /* free memory      */
         return(0);                          /* return to OS     */
      }
      num = fread(buf,sizeof(char *),31999,in); /* read in more  */
   }
   fclose(in);                               /* close in file    */
   fclose(out);                              /* close out file   */
   free(buf);                                /* free memory      */
   printf("\nDone!");                        /* Finished         */
   return(1);                                /* return to OS     */
}
