/**************************** MEMLIST.C *************************
*       A Program to list memory-resident programs by name.     *
*       by Nigel Cort based on work on undocumented DOS calls.  *
*       See text for details (c) 1988 C Gazette. Use freely     *
*       but acknowledge source.                                 *
*       Usage: memlist                                          *
****************************************************************/

/* Verified for MSC, Turbo, Watcom, Zortech  */

#include <stdio.h>
#include <dos.h>
#include <ctype.h>

void get_dos_info();
unsigned int peek_w();
char peek_b();

union  REGS  inregs, outregs;
struct SREGS segments;

#define PSP peek_w(memseg, memofs + 1)
#define LEN peek_w(memseg, memofs + 3)

#ifndef MK_FP
#define MK_FP(segment,offset)  ((void far *) \
               (((unsigned long)(segment) << 16) + (unsigned)(offset)))
#endif
main()
{
    unsigned int dosinfoseg, dosinfoofs;
    int memseg, memofs;
    int header_byte,
        envirseg,
        envirofs,
        envirspace,
        c;

    get_dos_info (&dosinfoseg, &dosinfoofs);
                                         /* int 52h to get DOS info address */
                                         /* and corrects it to header chain */

    memofs = peek_w (dosinfoseg, dosinfoofs);
    memseg = peek_w (dosinfoseg, dosinfoofs + 2);

    do
    {
        header_byte = peek_b (memseg, memofs);
        printf ("%04X", memseg);
        printf (" - %04X ", memseg + LEN);
        if (PSP == 0)
            printf ("(%6ld bytes) free\n", LEN * 16L);
        else
        {
            printf ("(%6ld bytes)", LEN * 16L);
            if (PSP == memseg + 1)
                printf (" prog ");
            else
                printf (" data ");

            envirseg = peek_w (PSP, 0x2C);    /* Byte 2Ch in PSP points */
            if (envirseg == 0)                /* to program environment */
                puts ("No environment");
            else
            {
                envirofs = 0;
                envirspace = peek_w (envirseg - 1, 3) * 16;
                do
                    envirofs += 1;
                while (peek_w (envirseg, envirofs) != 0 &&  /* Read thru  */
                       envirofs <= envirspace);        /* environment for */
                envirofs += 4;                         /* two zero bytes  */
                if (envirofs >= envirspace)
                    puts ("No taskname in environment");
                else
                {
                    while (c = peek_b (envirseg, envirofs)) /* Print out  */
                    {                                  /* the name 1 char */
                        putc (toupper (c), stdout);    /* at a time.      */
                        envirofs += 1;
                    }
                    putc ('\n', stdout);
                }
            }
        }
        memseg += 1 + LEN;
    }
    while (header_byte != 'Z');                  /* Z marks end of chain */
    return (1);
}

/*  Gets the address of the DOS info list returned in ES:BX
    The address of the first memory block header is located
    four bytes before this info list. */

void get_dos_info (unsigned int *seg, unsigned int *ofs)
{
    inregs.h.ah = 0x52;
    int86x (0x21, &inregs, &outregs, &segments);
    *seg = segments.es;
    *ofs = outregs.x.bx - 4;
}

char peek_b (unsigned seg, unsigned ofs)  /* Returns a byte from memory */
{
    char far * fcp = MK_FP(seg, ofs);
    return (*fcp);
}

unsigned peek_w (unsigned seg, unsigned ofs)  /* Returns a word from memory */
{
    unsigned int far *fup = MK_FP (seg, ofs);
    return (*fup);
}
