/*      module:         mouse.c
 *      programmer:     Ray L. McVay
 *      started:        26oct86
 *      updated:        26oct86
 *
 *      Some handy mouse interface functions.
 */

#include <stdio.h>
#include <dos.h>

static union REGS reg;
static struct SREGS sreg;


int mstatus(void)
{
      reg.x.ax = 0;
      int86(0x33, &reg, &reg);
      if (reg.x.ax == 0xffff)
            return(reg.x.bx);
      else  return(0);
}


void mshow(void)
{
      reg.x.ax = 1;
      int86(0x33, &reg, &reg);
}


void mhide(void)
{
      reg.x.ax = 2;
      int86(0x33, &reg, &reg);
}


void mpos(int *mbt, int *mx, int *my)
{
      reg.x.ax = 3;
      int86(0x33, &reg, &reg);
      *mbt = reg.x.bx;
      *mx = reg.x.cx;
      *my = reg.x.dx;
}


void mput(int mx, int my)
{
      reg.x.ax = 4;
      reg.x.cx = mx;
      reg.x.dx = my;
      int86(0x33, &reg, &reg);
}


void mhlimit(int hmin, int hmax)
{
      reg.x.ax = 7;
      reg.x.cx = hmin;
      reg.x.dx = hmax;
      int86(0x33, &reg, &reg);
}


void mvlimit(int vmin, int vmax)
{
      reg.x.ax = 8;
      reg.x.cx = vmin;
      reg.x.dx = vmax;
      int86(0x33, &reg, &reg);
}


void mshape(int xhot, int yhot, int far shape[]) /* shape[32] */
{
      reg.x.ax = 9;
      reg.x.bx = xhot;
      reg.x.cx = yhot;
      reg.x.dx = FP_OFF(shape);
      sreg.es = FP_SEG(shape);
      int86x(0x33, &reg, &reg, &sreg);
}
