/*
**  by: Rob de Voer
*/

#include <dos.h>
#define MOUSE_INT        0x33

static union REGS mouse_regs;

/* static function for mouse-interrupt */
static void mouse_int(int fn)
{
      mouse_regs.x.ax = fn;
      int86(MOUSE_INT, &mouse_regs, &mouse_regs);
}

/* check if vector for mouse is installed. DRIVER present */
int ms_check(void)
{
      if ((long)getvect(MOUSE_INT))]
            return 1;
      else  return 0;
}

/* reset and check mouse. return -1 if MOUSE present, 0 if not.
   return number of buttons through butt */
int ms_reset(int *butt)
{
      mouse_int(0);
      *butt = mouse_regs.x.bx;
      return mouse_regs.x.ax;
}

/* enable mouse-cursor */
void ms_on(void)
{
      mouse_int(1);
}

/* disable mouse-cursor */
void ms_off(void)
{
      mouse_int(2);
}

/* read mouse position and button state */
void ms_stat(int *mx, int *my, int *mb)
{
      mouse_int(3);
      *mx = mouse_regs.x.cx;
      *my = mouse_regs.x.dx;
      *mb = mouse_regs.x.bx;
}
