/*
** some mouse routines
** by Uwe E. Schirm, May/June 1992
** placed in public domain
*/

#include <dos.h>

static union REGS r;
static struct SREGS s;

/*
** initialize mouse
*/

int m_init()
{
      r.x.ax = 0;
      int86(0x33, &r, &r);
      return(r.x.ax);
}

/*
** show mouse cursor
*/

void m_show()
{
      r.x.ax = 1;
      int86(0x33, &r, &r);
}

/*
** hide mouse cursor
*/

void m_hide()
{
      r.x.ax = 2;
      int86(0x33, &r, &r);
}

/*
** read mouse position and button status
*/

void m_read(int *row, int *col, int *but)
{
      r.x.ax = 3;
      int86(0x33, &r, &r);
      *but = r.x.bx;
      *col = r.x.cx;
      *row = r.x.dx;
}

/*
** set mouse to row/column
*/

void m_pos(int row, int col)
{
      r.x.ax = 4;
      r.x.cx = col;
      r.x.dx = row;
      int86(0x33, &r, &r);
}

/*
** read where and with which button mouse was pressed
*/

int m_press(int *row, int *col, int but)
{
      r.x.ax = 5;
      r.x.bx = but;
      int86(0x33, &r, &r);
      *col = r.x.cx;
      *row = r.x.dx;
      return(r.x.ax);
}

/*
** read where and with which button mouse was released
*/

int m_rel(int *row, int *col, int but)
{
      r.x.ax = 6;
      r.x.bx = but;
      int86(0x33, &r, &r);
      *col = r.x.cx;
      *row = r.x.dx;
      return(r.x.ax);
}

/*
** define horizontal range for mouse
*/

void m_col(int min, int max)
{
      r.x.ax = 7;
      r.x.cx = min;
      r.x.dx = max;
      int86(0x33, &r, &r);
}

/*
** define vertical range for mouse
*/

void m_row(int min, int max)
{
      r.x.ax = 8;
      r.x.cx = min;
      r.x.dx = max;
      int86(0x33, &r, &r);
}

/*
** show self defined cursor, works only in graphic mode
*/

void m_show_g()
{
      static unsigned int glove[] = {
            0xf3ff, 0xe1ff, 0xe1ff, 0xe1ff, 0xe1ff, 0xe049, 0xe000, 0x8000,
            0x0000, 0x0000, 0x07fc, 0x07f8, 0x9ff9, 0x8ff1, 0xc003, 0xe007,
            0x0c00, 0x1200, 0x1200, 0x1200, 0x1200, 0x13b6, 0x1249, 0x7249,
            0x9249, 0x9001, 0x9001, 0x8001, 0x4002, 0x4002, 0x2004, 0x1ff8 };

      /* first 16 = screenmask, last 16 = cursormask */

      segread(&sr);
      sr.es = sr.ds;
      regs.x.ax = 9;
      regs.x.bx = 4;           /* start hotspot */
      regs.x.cx = 0;           /* end hotspot   */
      regs.x.dx = (unsigned) glove;
      int86x(0x33, &r, &r, &s);
}

/*
** set cursor type, works only in text mode
*/

void m_show_t(int type, unsigned smask, unsigned cmask)
{
      r.x.ax = 10;
      r.x.bx = type;
      r.x.cx = smask;
      r.x.dx = cmask;
      int86(0x33, &r, &r);
}

/*
** read the motion counts
*/

void m_count(int *row, int *col)
{
      r.x.ax = 0b;
      int86(0x33, &r, &r);
      *col = r.x.cx;
      *row = r.x.dx;
}
