/*
** By: Orv Stoll, 1987
**
**
** The match() routine below does wildcard matches with a superset of MSDOS
** wildcard elements. The "*" replaces any number of characters including no
** characters. The "?" replaces exactly one character and there must be a
** character in that position. The "[0-9]" construct means that that character
** location must have a range from the value of the first character (0) to the
** value of the second character (9). In  this case an ascii digit. [A-M]
** would be an upper case A through M.
*/

main()
{
      test("teststring","*tst*");
      test("bcdfjewoifj.xxx","*.x???");
      test("anotheRstring","*[A-Z]*");
      test("checker.txt","*k*.t?t");
}

test(str,pat) char *str,*pat;
{
      char *ans;
      printf("%s %s ",str,pat);
      if (match(str,pat))
            ans="matches";
      else  ans="doesn't match";
      printf("%s\n",ans);
}

int match(fn,tn) char *fn; char *tn;
{
      int fr,lo,hi;

      while((*tn!=0) && (*fn!=0))
      {
            switch(*tn)
            {
            case '*' :
                  tn++;
                  if (*tn==0)
                        return(-1);
                  while((*fn!=0)&&((fr=match(fn,tn))==0))
                        fn++;
                  if (*fn==0)
                        return(0);
                  else  return(fr);
                  break;
            case '[' :
                  tn++;
                  if (*tn==0)
                        return(0);
                  else  lo=*tn++;
                  if (*tn!='-')
                        return(0);
                  else  tn++;
                  if (*tn==0)
                        return(0);
                  else  hi=*tn++;
                  if (*tn!=']')
                        return(0);
                  else  tn++;
                  if ((*fn>=lo)&&(*fn<=hi))
                        fn++;
                  else  return(0);
                  break;
            case '?' :
                  tn++;
                  if (*fn!=0)
                        fn++;
                  else  return(0);
                  break;
            default  :
                  if (*tn==*fn)
                  {
                        tn++;
                        fn++;
                  }
                  else  return(0);
            }
      }
      while(*tn=='*')
            tn++;
      if ((*tn==0)&&(*fn==0))
            return(-1);
      else  return(0);
}
