/*
**  Macros for managing direct video writes by Jerry Houston
*/

#if !defined(COLORMODE)
 #define COLORMODE  ((*(char _far *)0x0449) != 7)
 #define EXT_KBD    (*(char _far *)0x0496 & 16)
 #define ROWSIZE    (*(int _far *)0x044A)
 #define SCANLINES  ((int)*(char _far*)0x0461)
 #define SCRBUFF    ((unsigned _far *)((COLORMODE)?0xB8000000:0xB0000000))
 #define SCREENSEG  ((_segment)((COLORMODE)?0xB800:0xB000))
 #define SCREENSIZE ((*(int _far *)0x044C) >> 1)
 #define SCREENCOLS (*(int _far *)0x044A -1)
 #define SCREENROWS ((*(char _far *)0x0484)?*(char _far*)0x0484:24)
#endif

/*
     COLORMODE  = true/false, are we using color?
     EXT_KBD    = true/false, extended keyboard in use?
     ROWSIZE    = number of characters on a row.
     SCANLINES  = number of scan lines in a character.
     SCRBUFF    = returns B800:0000 if using color, B000:0000 if mono.
     SCREENSEG  = when you just need the segment portion.
     SCREENSIZE = number of (2-byte) cells required to save screen.
     SCREENCOLS = offset to the rightmost column, often 79.
     SCREENROWS = offset to the bottom line, usually 24.
*/
