/* program:    mousword.c
 * programmer: Ray L. McVay
 * date:       20 Oct 1988
 *
 * Demonstration of picking "words" off a text mode PC screen using a mouse.
 * Submitted to the C_ECHO and placed in the public domain, 7 Jun 1992.
 */

#include <stdio.h>
#include <stdlib.h>
#include "mouse.h"

char word[80];
int FAR *scrn = (int FAR *)0xb8000000L;   /* See VIO.H for a better way */

main()
{
      int done, b, x, y;

      mstatus(); /* reset */
      mshow();
      for (done = 0; !done; )
      {
            mpos(&b, &x, &y);
            if (b == 1)
            {
                  mhide();
                  getword(word, x/8, y/8);
                  do
                  {
                        mpos(&b, &x, &y);
                  } while (b);
                  if (*word)
                        printf("{%s}\n", word);
                  mshow();
            }
            else if (b > 1)
                  done = 1;
      }
      mstatus();
      exit(0);
}

getword(char *w, int x, int y)
{
      int txs, txe, ci;
    
      for (txs = x; (txs >= 0) && ((scrn[80 * y + txs] & 255) != 32); txs--)
            scrn[80 * y + txs] = (scrn[80 * y + txs] & 255) | 0x7000;
      for (txe = x; (txe < 80) && ((scrn[80 * y + txe] & 255) != 32); txe++)
            scrn[80 * y + txe] = (scrn[80 * y + txe] & 255) | 0x7000;
      for (ci = txs + 1; ci < txe; ci++)
            *w++ = scrn[80 * y + ci];
      *w = 0;
}
