/*
**  Save and restore a text screen
**  public domain by Jeff Dunlop
*/

#ifdef __TURBOC__
 #include <alloc.h>
#else
 #include <malloc.h>
 #define farcalloc(a,b) _fcalloc((a),(b))
 #define farfree(a) _ffree(a)
#endif
#include <string.h>

#define MAX_X 79 /* Actually, should be determined on program startup */

/*------------------------[ vlWinSave ]-------------------------*/
/*     Save the screen with passed coordinates to a buffer      */
/*--------------------------------------------------------------*/
/* input:                                                       */
/*      x1, y1 = upper left coordinates                         */
/*      x2, y2 = lower right coordinates, 0-based               */
/*      vid_ram = address of screen (or screen buffer)          */
/* return:                                                      */
/*      address of the buffer allocated and filled, or NULL     */
/*      on error                                                */
/* note:                                                        */
/*      vlWinRestore must be called to release the memory.      */
/*      These routines will work with video ram or virtual      */
/*      windows.                                                */
/*--------------------------------------------------------------*/

char far *vlWinSave(int x1, int y1, int x2, int y2, char far *vid_ram)
{
    int i;

    char far *win_ptr;

    if ( (win_ptr = farcalloc((x2 - x1 + 1) * (y2 - y1 + 1) * 2, 1)) == NULL )
        return NULL;

    for (i = y1; i <= y2; i++)
        f_memcpy(win_ptr + (x2 - x1 + 1) * 2 * (i - y1),
            vid_ram + 2 * (MAX_X + 1) * i + 2 * x1, (x2 - x1 + 1) * 2);
    return(win_ptr);
}

/*------------------------[ vlWinRestore ]----------------------*/
/*               Restore a previously saved screen              */
/*--------------------------------------------------------------*/
/* input:                                                       */
/*      x1, y1 = upper left coordinates                         */
/*      x2, y2 = lower right coordinates, 0-based               */
/*      win_ptr = address of screen saved with winsave          */
/*      vid_ram = address of video buffer                       */
/* note:                                                        */
/*      With care, it's possible to 'move' a window as long as  */
/*      the resulting width & length are the same.              */
/*--------------------------------------------------------------*/

void vlWinRestore(int x1, int y1, int x2, int y2, char far *win_ptr
                 char far *vid_ram)
{
    char far *temp_ptr = win_ptr;

    int win_wid = 2 * (x2 - x1 + 1),
        max_x_attr = 2 * (MAX_X + 1),
        i;

    vid_ram += 2 * ((MAX_X + 1) * y1 + x1);
    for (i = y1; i <= y2; i++)
    {
        f_memcpy(vid_ram, win_ptr, (unsigned)win_wid);
        win_ptr += win_wid;
        vid_ram += max_x_attr;
    }
    farfree(temp_ptr);
    return;
}

void f_memcpy(char far *dest, char far *src, size_t size)
{
    int i;

    movedata(FP_SEG(src), FP_OFF(src), FP_SEG(dest), FP_OFF(dest), size);
}
