/*
**   Get screen size (by  Bob Jarvis)
*/
 
#include <dos.h>
 
#ifndef __TURBOC__
 #define far _far
#endif
 
#ifndef MK_FP
 #define MK_FP(seg,offset) \
        ((void far *)(((unsigned long)(seg)<<16) | (unsigned)(offset)))
#endif
 
int get_screen_rows(void)
{
      char far *bios_crt_rows_ptr = MK_FP(0x0040, 0x0084);
 
      return(1 + *bios_crt_rows_ptr);
}
 
int get_screen_cols(void)
{
      int far *bios_crt_cols_ptr = MK_FP(0x0040, 0x004A);
 
      return(*bios_crt_cols_ptr);
}
 
#ifdef TEST
 
#include <stdio.h>
 
void main(void)
{
      printf("rows = %d  cols = %d\n",
            get_screen_rows(), get_screen_cols());
}
 
#endif
