/*
**  split() - Portable replacement for fnsplit(), _splitpath(), etc.
**
**  Splits a full DOS pathname into path, file, and extension specifications.
**  Works with forward or back slash path separators and network
**  file names, e.g. NET:LOONEY/BIN\WUMPUS.COM, Z:\MYDIR.NEW/NAME.EXT
**
**  Arguments: 1 - Full pathname to split
**             2 - Buffer for path
**             3 - Buffer for name
**             4 - Buffer for extension
**
**  Returns: Nothing
*/

#include <string.h>

#define NUL '\0'

void split(char *filepath, char *pathname, char *fname, char *ext)
{
      char ch, *ptr, *p;

      /* convert slashes to backslashes for searching         */

      for (ptr = filepath; *ptr; ++ptr)
            if ('/' == *ptr)
                  *ptr = '\\';

      /* find rightmost backslash or leftmost colon           */

      if (NULL == (ptr = strrchr(filepath, '\\')))
            ptr = (strchr(filepath, ':'));

      if (!ptr)
      {
            ptr = filepath;         /* obviously, no path   */
            *pathname = NUL;
      }
      else
      {
            ++ptr;                  /* skip the delimiter   */
            ch = *ptr;
            *ptr = NUL;
            strcpy(pathname, filepath);
            *ptr = ch;
      }

      if (NULL == (p = strrchr(ptr, '.')))
      {
            strcpy(fname, ptr);
            *ext = NUL;
      }
      else
      {
            *p = NUL;
            strcpy(fname, ptr);
            *p = '.';
            strcpy(ext, p);
      }
}

#ifdef TEST

#include <stdio.h>

int main(int argc, char *argv[])
{
      char pathname[FILENAME_MAX], fname[9], ext[5];

      while (--argc)
      {
            split(*++argv, pathname, fname, ext);
            printf("split(%s) returns:\n path = %s\n name = %s\n ext  = %s\n",
                  *argv, pathname, fname, ext);
      }
}
