/*----------------------------------------------------------------------*
* Program:     touch                                                    *
* Programmer:  Ray L. McVay                                             *
* Started:     8 Aug 91                                                 *
* Updated:                                                              *
*-----------------------------------------------------------------------*
* Simple touch program to test BC time stamping function.               *
* Public Domain                                                         *
*----------------------------------------------------------------------*/

#include <stdio.h>
#include <dos.h>
#include <io.h>

main(int argc, char **argv)
{
    struct date cd;
    struct time ct;
    struct ftime ft;
    FILE *f;

    if (argc > 1)
    {
       getdate(&cd);
       gettime(&ct);
       ft.ft_year = cd.da_year;
       ft.ft_month = cd.da_mon;
       ft.ft_day = cd.da_day;
       ft.ft_hour = ct.ti_hour;
       ft.ft_min = ct.ti_min;
       ft.ft_tsec = ct.ti_sec/2;

       if ((f = fopen(argv[1], "r+b")) != NULL)
           setftime(fileno(f), &ft);
       else if ((f = fopen(argv[1], "w")) != NULL)
           setftime(fileno(f), &ft);
       else
           perror("Can't open file");

       if (f)
           fclose(f);
    }

    return 0;
}
