/************************************************************************
 *	ASCII TABLE DISPLAY PROGRAM FOR USE WITH DESQVIEW		*
 *									*
 *    Copyright 1987, Phillip A. Kaufman. All rights, except those	*
 *    specifically granted herein are reserved by the author. The right	*
 *    to copy and distribute this material is granted without fee for	*
 *    any and all non-commercial use. This material specifically may	*
 *    not be distributed or sold for a fee nor incorporated in whole or	*
 *    in part into any other product that is distributed or sold for a	*
 *    fee without specific permission of the author. To obtain special	*
 *    permission or to report any difficulties with this material	*
 *    contact:								*
 *                      Phillip A. Kaufman				*
 *                      19987 Moran Lane				*
 *                      Saratoga, CA 95070				*
 *									*
 *    THIS MATERIAL IS DISTRIBUTES "as is" WITHOUT ANY EXPRESSED OR	*
 *    IMPLIED WARRANTY OR LIABILITY FOR DIRECT, INDIRECT OR		*
 *    CONSEQUENTIAL DAMAGES.						*
 ************************************************************************
 *									*
 *	Use: PgUp and PgDn to page the display - ESC to exit		*
 *									*
 *	Installation: Must be installed in Desqview environment.	*
 *		Requires a DV memory size of only 4k. Must set the	*
 *		window size to 18 high and 23 wide.			*
 *		Program does not generate colors so it will assume	*
 *		the window's colors or you can make a startup script	*
 *		to force colors.					*
 *									*
 *	Files:								*
 *		asciitbl.c	this source file ( for MSC 4.0; 	*
 *				  compile with small model and link     *
 *				  with stack of 150 bytes - IT IS	*
 *				  REALLY IMPORTANT to either use linker *
 *				  directive to set stack or to use	*
 *				  EXEMOD. Microsoft's default stack size*
 *				  is 2k and program will crash DV if	*
 *				  loaded into a 4k segment.)		*
 *		asciitbl.exe	compiled version of above - fits in 4k	*
 *				  with room to spare!			*
 *		at-pif.dvp	dv 2.0 pif file				*
 *		at-scrip.dvs	dv 2.0 startup script for colors	*
 ************************************************************************/

#include	<dos.h>
#define CASE case
#define COLS 23		/* number of columns must be odd */
			/* really not variable but convenient */
char hex[] = "0123456789ABCDEF";
int wind[] = {0,0x10,0x20,0x40,0x60,0x80,0xA0,0xC0,0xE0};
int wcnt = 0;
int first;

char head1[COLS/2] = "Dec Hex Chr";
char head2[COLS/2] = "Ctrl  Use  ";

char use[32][4] = {"NUL","SOH","STX","ETX","EOT","ENQ","ACK","BEL","BS ",
"HT ","LF ","VT ","FF ","CR ","SO ","SI ","DLE","DC1","DC2","DC3","DC4",
"NAK","SYN","ETB","CAN","EM ","SUB","ESC","FS ","GS ","RS ","US "};

char *ptr;
union REGS rg;			/* cpu regs		*/
struct SREGS segregs;
union {
	unsigned long l;	/* long form of address	*/
	char far *p;		/* pointer form of address */
} addr, scptr;

_setargv()		/* dummy since we use no command line args */
{
}
_setenvp()		/* dummy since we don't use environment variables */
{
}
_nullcheck()		/* disable null pointer checking */
{
}

main()
{
	register int i;

        /* Check for Desqview and use its buffer */
        rg.x.ax = 0x2B01;       	/* do date set as DV check */
        rg.x.cx = 0x4445;               /* "DESQ"an illegal date */
        rg.x.dx = 0x5351;
        int86(0x21,&rg,&rg);
        if (rg.h.al != 0xFF){		/* we are in desqview	*/
                rg.h.ah = 0xFE;		/* dv get buff addr	*/
		int86(0x10,&rg,&rg);
		segread(&segregs);
                addr.l=((unsigned long)segregs.es<<16)+(unsigned long)rg.x.di;
        }
	else {
		cputs ("\x07Program requires DESQview!\n");
		exit(1);
	}

	/* put up fixed part of header */
        scptr.p = addr.p;
	ptr = head1;
	for (i = 0; i < COLS/2; i++){	/* 1st half of 1st line */
		*scptr.p = *ptr++;
		scptr.p = scptr.p +2;
	}
	scptr.p = addr.p + COLS*2;
	for (i = 0; i < COLS; i++){	/* 2nd line */
		*scptr.p = 0xC4;
		scptr.p = scptr.p + 2;
	}
	
	doit();		/* put up first screen */
	
	while (1) {  	/* loop, wait for key then do it */
		rg.h.ah = 0x07;		/* kbd input, wait, no echo */
		int86(0x21,&rg,&rg);
        	if (rg.h.al == 0x1B) exit (0);	/* ESC */
		if (rg.h.al == 0){
			int86(0x21,&rg,&rg);
			if (rg.h.al == 0x49){ 		/* PgUp */
				wcnt = (wcnt == 0)? 8 : wcnt -1;
				doit();
			}
			else if (rg.h.al == 0x51){ 	/* PgDn */
				wcnt = (wcnt == 8)? 0 : wcnt + 1;
				doit();
			}
		}
	}
}

doit()
{
	register int i;
	char c;
	register int l20;
	first = wind[wcnt];
	l20 = (first < 0x20);
	
	/* do variable header lines */
        scptr.p = addr.p + COLS+1;	/* 2nd half of line 1 */
        ptr = (l20)? head2 : head1;
	for (i=0; i < COLS/2; i++){
		*scptr.p = *ptr++;
		scptr.p = scptr.p +2;
	}
	scptr.p = addr.p + COLS-1;	/* 1st line midpoint */
	*scptr.p = (l20)? ' ' : 0xB3;
	scptr.p = addr.p + (COLS*2) + (COLS -1) ; /*2nd line midpoint */
	*scptr.p = (l20)? 0xC4 : 0xC5;
	c = (l20)? ' ' : 0xB3;	/* center line */
	scptr.p = addr.p + (COLS*4) + (COLS -1);
	for (i = 0; i < 0x10; i++){
		*scptr.p = c;
		scptr.p = scptr.p + COLS*2;
	}
	
	scptr.p = addr.p + COLS*4;
	docol(0);	/* do 1st column */
		
	/* do 2nd col */
	scptr.p = addr.p + (COLS*4) + (COLS + 1);
	if (l20){
		docol(1);
	}
	else {
		first = first + 0x10;
		docol(0);
	}

	/* put the cursor outside the window */
	rg.h.ah = 0x2;
	rg.h.bh = 0;
	rg.x.dx = 0x154f;  /* row 24 col 79*/
	int86(0x10,&rg,&rg);
}

docol(type)
int type;
{
	int a, b, tcnt;
	register int i, pos;
	for ( i = first; i < first + 0x10; i++){
	    for ( pos = 0; pos < (COLS/2)-1; pos++){
	      if (type == 0){
		switch (pos) {
			CASE 0:
				a = i / 100;
		    	    	*scptr.p = (a == 0)? ' ': (a + 0x30);
    	    			break;
    	    		CASE 1:	/* 2nd decimal digit */
		    	    	b = (tcnt = i - a * 100) / 10;
    	    			*scptr.p = (a == 0 && b == 0)? ' ': (b + 0x30);
    	    			break;
    	    		CASE 2:	/* 3rd decimal digit */
		    	    	*scptr.p = (tcnt - b * 10 + 0x30);
		    	    	break;
			CASE 5:	/* 1st hex digit */
		    	    	*scptr.p = hex[ i >> 4];
				break;
			CASE 6:	/* 2nd hex digit */
		    	    	*scptr.p = hex[ i & 0xF];
		    	    	break;
			CASE 7:		/* blank to cover other format */
			CASE 8:
				*scptr.p = ' ';
				break;
			CASE 9:	/* character */
		    	    	*scptr.p = i;
				break;
		}
	     }
	     else {
	     	    	switch (pos){
			CASE 0:
			CASE 5:
			CASE 9:
				*scptr.p = ' ';
				break;
			CASE 1:
    	    			*scptr.p = '^';
    	    			break;
    	    		CASE 2:
	    	    		*scptr.p = i + 0x40;
	    	    		break;
	    	    	CASE 6:
	    	    		*scptr.p = use[i][0];
	    	    		break;
	    	    	CASE 7:
	    	    		*scptr.p = use[i][1];
	    	    		break;
	    	    	CASE 8:
	    	    		*scptr.p = use[i][2];
				break;
		}
	     }	
	     scptr.p = scptr.p + 2;
	   }
	   scptr.p = scptr.p + COLS + 3;
	}
        return;
}
