/*****************************************************************************\
*                                                                             *
*   CDD, a substitute for MESSDOS' CD command                                 *
*                                                                             *
*   (c) 1987 Wolfgang Siebeck                                                 *
*                                                                             *
*   usage: CDD [directory name | $environment variable]                       *
*   changes the directory like MSDOS CD should do                             *
*                                                                             *
*   CDD [no argument] gets the directory name from the environment            *
*   	variable HOME.                                                        *
*                                                                             *
*   CDD $[variable] gets the directory from variable                          *
*                                                                             *
*   CDD [d:]dirname changes the directory and - if given - the default drive  *
*                                                                             *
*   wildcards in dirname are supported !                                      *
*                                                                             *
*   (This is formatted for \t == "    ")                                      *
*                                                                             *
\*****************************************************************************/


extern char far **environ;
char *getenv();

#include <stdio.h>
#include <dir.h>
/*
#include <dos.h>
*/

main (argc,argv)
int argc;
char *argv[];

{

	char newdir[64], errtext[32];		/* here goes the directory		*/
	char *tmp;
	register int i;

	if (argc == 2) {					/* a directory name is given	*/
		strcpy(newdir,argv[1]);
	} else {
		strcpy(newdir,"$HOME");			/* if no argument given, lets	*/
	}									/* go to $HOME					*/

	if (newdir[0] == '$') {
		moveleft (newdir,1,0);			/* get rid of the $-sign and	*/
		for (i=0;						/* remember ? all UPPERcase !	*/
			(newdir[i] = toupper(newdir[i])) != '\0';
			i++);
		tmp = getenv (newdir);			/* fetch newdir from environment*/
		if (tmp == NULL) {
			strcpy (errtext,"$");
			strcat (errtext, newdir);
			strcat (errtext," undefined.");
			puts (errtext);
			_exit();
		}
		strcpy(newdir,tmp);
	}

	newchdir (newdir);					/* now do the extended chdir	*/
}

/*
**	newchdir extends chdir. the default drive is changed
**	when given in dirname
*/		

newchdir(dirname)
char dirname[];

{

	int drive, newdrive;
	char testchar;
	char errtext[64];

	testchar = dirname[1];
	if (testchar == ':') {				/* is a drive included ? 			*/
		testchar = toupper(dirname[0]); /* yes ! 							*/
		newdrive = (int)(testchar-'A');	/* here we want to go ... 			*/
		drive = getdisk();				/* and here we are !				*/
		if (newdrive != drive) { 		/* we have to change the drive ...	*/
			setdisk (newdrive);			/* done !							*/
		}
	}

	if (chdir(dirname)) {
		if (wildchdir (dirname)) {
			strcpy(errtext, "\"");
			strcat(errtext,dirname);
			strcat(errtext, "\": no such directory");
			puts (errtext); 			/* WHOOPS!					*/
										/* to save space, was : perror ("cdd") 	*/

			if (newdrive != drive) { 	/* we changed the drive ...			*/
				setdisk (drive);		/* now come back !					*/
			}

			_exit();
		}
	}


}	

/*
**	now the incarnation :
**	try to find a directory with wildcards (tough!)
*/

int wildchdir (dirname)
char dirname[];

{
	struct ffblk ff;

	int done;
	int bad = -1;
	char drive[MAXDRIVE];
	char dir[MAXDIR];
	char file[MAXFILE];
	char ext[MAXEXT];
	char newpath[64];

	fnsplit(dirname, drive, dir, file, ext); 		/* watch this! 			*/
													/* we need it later 	*/
	done = findfirst(dirname, &ff, 0x10);
	if (done)										/* that's easy !		*/
		return (bad);
	if (ff.ff_attrib & 0x10) {				/*   vv-- we need one more arg!	*/
		fnmerge(newpath, drive, dir, ff.ff_name, ""); /* here it is !		*/
		if (ff.ff_name[0] != '.')					/* that would be stupid */
			bad = chdir (newpath);
	}

	if (bad) {
		while ((!done) && (bad)) {
			done = findnext (&ff);
			if (ff.ff_attrib & 0x10) {				/* never cd to a file!	*/
				fnmerge(newpath, drive, dir, ff.ff_name, "");
				if (ff.ff_name[0] != '.')
					bad = chdir (newpath);
			}
		}
	}
	return (bad);

}

/*
**	some kind of MID$ in BASIC
**	moveleft ("moveleft",3,1) gives "meleft"
**	moveleft ("$TMPDIR",1,0) gives "TMPDIR"
*/

moveleft (st,from,to)
char *st;
int from;
int to;

{
 	for (;(st[to] = st[from]) != '\0'; from++,to++);
}

/*
**	a workaround-the-bug
*/

char *getenv(s)
char *s;

{
	char *p, *e;
	char **env;

	env = environ;
	while(1) {
		e = *env++;
		if (e == (char *) 0)
			break;
		for (p = s; *p == *e; p++, e++) ;
		if  (*p == 0 && *e == '=')
			return (char *)++e;
		while (*e)
			e++;
		e++;
	}
	return ((char *) e);

}
