/* This is file COLORS.C */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "graphics.h"

extern int _GrCurMode;

typedef struct {
  unsigned char n;
  unsigned char state; /* 0=free, 1=shared, 2=writable */
  unsigned char r;
  unsigned char g;
  unsigned char b;
} Color;

static Color color[256];

static int initted=0;

static init_colormap()
{
  initted = 1;
  bzero(color, sizeof(color));
  GrAllocColor(0, 0, 0);
  GrAllocColor(255, 255, 255);
}

GrBlack()
{
  if (!initted)
    init_colormap();
  return 0;
}

GrWhite()
{
  if (!initted)
    init_colormap();
  return 1;
}

GrAllocColor(int r, int g, int b)
{
  int n;
  if (!initted)
    init_colormap();
  for (n=0; n<256; n++)
  {
    if ((color[n].state == 1)
      && (color[n].r == r)
      && (color[n].g == g)
      && (color[n].b == b))
    {
      color[n].n++;
      return n;
    }
  }
  for (n=0; n<256; n++)
  {
    if (color[n].state == 0)
    {
      color[n].n = 1;
      color[n].state = 1;
      GrSetColor(n, r, g, b);
      return n;
    }
  }
  return -1;
}

int GrAllocCell()
{
  int n;
  if (!initted)
    init_colormap();
  for (n=0; n<256; n++)
  {
    if (color[n].state == 0)
    {
      color[n].n = 1;
      color[n].state = 2;
      return n;
    }
  }
  return -1;
}

void GrSetColor(int n, int r, int g, int b)
{
  if (!initted)
    init_colormap();
  color[n].r = r;
  color[n].g = g;
  color[n].b = b;
  _GrSetColor(n, r, g, b);
}

void GrQueryColor(int n, int *r, int *g, int *b)
{
  if (!initted)
    init_colormap();
  *r = color[n].r;
  *g = color[n].g;
  *b = color[n].b;
}

void GrFreeColor(int n)
{
  if (color[n].n > 0)
  {
    color[n].n --;
    if (color[n].n == 0)
      color[n].state = 0;
  }
}

void GrRefreshColors()
{
  int i;
  if (_GrCurMode < GR_320_200_graphics)
    return;
  if (!initted)
    init_colormap();
  for (i=0; i<256; i++)
    if (color[i].state)
      GrSetColor(i, color[i].r, color[i].g, color[i].b);
}
