/* This is file GRAPHICS.C */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "sys/registers.h"

unsigned _GrMaxX;
unsigned _GrMaxY;
unsigned _GrSizeX;
unsigned _GrSizeY;

GrPlot(x, y, c)
{
  register unsigned char *a;
  if ((x<0) || (x>_GrMaxX) || (y<0) || (y>_GrMaxY))
    return;
  a = (unsigned char *)(0xd0000000+((x+y*_GrSizeX)&0xfffff));
  if (c & 0x100)
    *a ^= c;
  else
    *a = c;
}

GrPixel(x, y)
{
  if ((x<0) || (x>_GrMaxX) || (y<0) || (y>_GrMaxY))
    return 0;
  return *(unsigned char *)(0xd0000000+((x+y*_GrSizeX)&0xfffff));
}

GrPlot3d(x, y, c)
{
  register unsigned char *a;
  if ((x<0) || (x>_GrMaxX) || (y<0) || (y>_GrMaxY))
    return;
  a = (unsigned char *)(0xd0000000+((x+y*_GrSizeX)&0xfffff));
  if ((*a < c) || (c<0xc0))
    *a = c;
}

GrMaxX()
{
  return _GrMaxX;
}

GrMaxY()
{
  return _GrMaxY;
}

GrSizeX()
{
  return _GrSizeX;
}

GrSizeY()
{
  return _GrSizeY;
}
