/* This is file TEXT.C */
/*
** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "sys/registers.h"

static unsigned char *font=0;

#define CHARHEIGHT 16

GrTextXY(int x, int y, char *text, int fg, int bg)
{
  REGISTERS reg;
  unsigned char *fp;
  int r, c, bits;
  if (font == 0)
  {
    reg.ax = 0x1130;
    reg.bx = 0x0600;
    int10(&reg);
    font = (unsigned char *)reg.bp;
  }
  while (*text)
  {
    fp = font + CHARHEIGHT * *(unsigned char *)text;
    for (r=0; r<CHARHEIGHT; r++)
    {
      bits = *fp++;
      for (c=0; c<8; c++)
        if (bits & (0x80>>c))
          GrPlot(x+c, y+r, fg);
        else
          GrPlot(x+c, y+r, bg);
    }
    text++;
    x += 8;
  }
}
