code    Segment Para
        Assume cs:code, ds:code
        org     100h
park    proc far
        jmp     init
x1Coff  dw      0                  ; All of the old INT vectors and
x1Cseg  dw      0                  ;   scratch data space
x13off  dw      0
x13seg  dw      0
parked  dw      0
count   dw      0
value   dw      0
flag    dw      0
oldax   dw      0
oldip   dw      0
oldcs   dw      0
oldflgs dw      0

        even                       ; Start the assembler off on an even foot

x1Cint: push    ax                 ; Start of the patched INT1C handler
        push    bx
        push    cx
        push    dx
        push    ds
        mov     ax,cs              ; Set code=data segments
        mov     ds,ax              ;
        xor     ax,ax              ; Clear AX
        cmp     parked,ax          ; Compare PARKED to 0
        jne     x1Cext             ; Exit if already PARKED
        dec     word ptr count     ; Reduce time until PARK
        cmp     count,ax           ; Is it time to PARK?
        jne     x1Cext             ; Exit if not time
        cmp     flag,1             ; Has disk been used recently?
        je      x1Cext             ; Exit if so
        cli                        ; Block any interrupts
        mov     ax,1               ; Okay, we're going to PARK the drives
        mov     parked,ax          ; Set PARKED flag
        mov     flag,ax            ; Set FLAG (we're suppose to do something)
        mov     ax,value           ; Reset counter to magic number * PARAMETER
        mov     count,ax
        pop     ds
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        mov     cs:oldax,ax        ; Prepare to call to 'old'
        pop     ax      ;ip        ;   INT13 handler
        mov     cs:oldip,ax
        pop     ax      ;cs
        mov     cs:oldcs,ax
        pop     ax      ;flags
        mov     cs:oldflgs,ax
        mov     ax,offset parks
        pushf                      ; Generate a return to the PARKER ??
        push    cs
        push    ax
        mov     ax,cs:oldax
        sti
        jmp     dword ptr cs:[x1Coff]    ; Call the 'old' INT1C handler
x1Cext: pop     ds                       ; Set up to leave the new
        pop     dx                       ;   INT1C handler
        pop     cx
        pop     bx
        pop     ax
x1Cou1: jmp     dword ptr cs:[x1Coff]    ; Leave the new INT1C handler

parks:  sti
        push    ax
        push    cx
        push    dx
        push    ds
        mov     ax,cs
        mov     ds,ax

;       Do the BIOS's dirty work so this code will work!

        mov     al,020h       ; Write something to 8259A interrupt
        out     020h,al       ;   controller chip

        mov     ah,08         ; Get disktable parameters
        mov     dx,80h
        int     13h
        mov     dx,80h        ; Set N heads to 8, drive to 0
        inc     ch            ;   and set to ?next? cylinder
        jnc     p1
        add     cl,40h        ; Add 40 to cylinder count if
p1:     mov     ax,0c01h      ;   N cylinders > 256
        int     13h           ; Seek to sector to PARK drive

        mov     ah,08         ; Get disktable parameters
        mov     dx,81h
        int     13h
        mov     dx,81h        ; Set N heads to 8, drive to 1
        inc     ch            ;   and set to ?next? cylinder
        jnc     p2
        add     cl,40h        ; Add 40 to cylinder count if
p2:     mov     ax,0c01h      ;   N cylinders > 256
        int     13h           ; Seek to sector to PARK drive

        xor     ax,ax
        mov     flag,ax       ; We've done something, so clear 
        pop     ds            ;   something to do flag
        pop     dx
        pop     cx
        mov     ax,cs:oldflgs         ; Save the current registers
        push    ax
        popf
        pop     ax
        jmp     dword ptr cs:[oldip]  ; Jump off to handle the disk I/O

x13int: push    ax            ; Start of the patched INT13 handler
        push    ds
        sti
        mov     ax,cs
        mov     ds,ax
        cmp     flag,1        ; Are we waiting to park the drives ?
        je      x13in1        ; If so, and the disk is being used,
        mov     ax,value      ;   reset the timer and PARKED flags
        mov     count,ax
        xor     ax,ax
        mov     parked,ax
x13in1: pop     ds
        pop     ax
        jmp     dword ptr cs:[x13off]
        dw      0
table   dw      0             ; Just a label to tell where to cut the
                              ;   program for the TSR interrupt to DOS

init:   xor     ax,ax                   ; Clear AX
        mov     parked,ax               ; Clear PARKED flag
        mov     bx,80h                  ; Set up for DOS call
        mov     al,[bx]                 ; Read in PARAMETER from DTA
        cmp     al,0
        jne     init1
        int     21h                     ; DO NOTHING exit if 0 length
init1:  inc     bx                      ; Check for SPACE
        mov     al,[bx]
        cmp     al,32
        je      init1                   ; If SPACE, loop
        cmp     al,13                   ; Check for CR
        jne     init3                   ; If CR, DO NOTHING exit
init2:  xor     ax,ax
        int     21h
init3:  cmp     al,49                   ; Exit if below PARAMETER is
        jb      init2                   ;   below 1 or above 9
        cmp     al,57
        ja      init2
        lea     dx,mess                 ; Tell world we're installing...
        mov     cx,ax
        mov     ah,09                   ; Reset the disk table vectors
        int     21h                     ;   to be sure of the old values
        mov     ax,cx                   ; Recover PARAMETER saved in CX
        xor     ah,ah                   ; Clear AH
        mov     bx,0fh
        and     ax,bx                   ; Set AX to 0F AND PARAMETER
        mov     dx,2182                 ; Enter some magic number of ticks
                                        ; 1091 = Compaq Deskpro 8086 @ 7.2MHz
                                        ;  443 hex
                                        ; 10910 = about 10:1 over above
                                        ;  2A9E hex
        mul     dx                      ; Get count for wait loop
        mov     value,ax                ; Save the value
        mov     count,ax                ; Update counter
        cli                             ; Okay, no interrupts while we play
        push    es                      ;   with DOS and the machines brains
        xor     ax,ax                   ; Move into place all the new
        mov     es,ax                   ;   INT vectors
        mov     bx,76
        mov     ax,es:[bx]
        mov     x13off,ax
        mov     ax,offset x13int
        mov     es:[bx],ax
        inc     bx
        inc     bx
        mov     ax,es:[bx]
        mov     x13seg,ax
        mov     ax,cs
        mov     es:[bx],ax
        xor     ax,ax
        mov     flag,ax
        mov     es,ax
        mov     bx,112
        mov     ax,es:[bx]
        mov     x1Coff,ax
        mov     ax,offset x1Cint
        mov     es:[bx],ax
        inc     bx
        inc     bx
        mov     ax,es:[bx]
        mov     x1Cseg,ax
        mov     ax,cs
        mov     es:[bx],ax
        pop     es
        sti                         ; Okay, we're done setting the new vectors
        mov     dx,offset table     ; Set the length to keep in memory
        int     27h                 ; Terminate the program STAY RESIDENT !

mess    db      ' -------- Installing TIMEPARK Utility -------- ',13,10,'$'
park    endp
code    ends
        end park
