#ifdef XIcon
/*
 * File: rximage.r -- dumpimage, loadimage
 *
 * dumpimage -- write an image to a disk file.  Return 0 on failure.
 * Currently only accepts .xpm and .xbm format specifications.
 * PM version accepts .bmp formats
 */
#ifndef PresentationManager
int dumpimage(w,filename,x,y,width,height)
wbp w;
char *filename;
unsigned int x, y, height, width;
   {
   int status;
   STDLOCALS(w);

   /*
    * If an XPM (or other color) filetype is not specified, default to write
    *  an XBM file.
    */
   if (strcmp(".xpm", filename + strlen(filename) - 4) &&
      strcmp(".xpm.Z", filename + strlen(filename) - 6)) {

      /*
       * write a bitmap from a "color" window (presumed to have only BW in it).
       * BlackPixel ^ WhitePixel will have a 1 in the first bit in which
       * they are different, so this bit is the plane we want to copy.
       */
      if (DefaultDepth(stddpy,wd->screen) != 1) {
         unsigned long bw =
            BlackPixel(stddpy,wd->screen) ^ WhitePixel(stddpy,wd->screen);
	 Pixmap p1 = XCreatePixmap(stddpy, DefaultRootWindow(stddpy),
				   width, height, 1);
	 XGCValues xgc;
	 GC thinGC;
	 int i;
	 /*
	  * pick out the bitplane on which Black and White differ
	  */
	 for(i=0;!((1<<i) & bw);i++);
	 bw &= (1<<i);
	 /*
	  * Construct a 1-bit-deep GC for use in copying the plane.
	  */
	 xgc.foreground = BlackPixel(stddpy,wd->screen);
	 xgc.background = WhitePixel(stddpy,wd->screen);
	 thinGC = XCreateGC(stddpy,p1,GCForeground|GCBackground,&xgc);

	 if (i>DefaultDepth(stddpy,wd->screen)) return 0;
	 XCopyPlane(stddpy,stdpix,p1,thinGC,x,y,width,height,0,0,bw);
	 status= XWriteBitmapFile(stddpy, filename, p1, width, height, -1, -1);

	 XSync(stddpy, False);
	 XFreePixmap(stddpy, p1);
	 XFreeGC(stddpy,thinGC);
	 if (status != BitmapSuccess) return 0;
         }
      else {
	 if(x || y) {
	    Pixmap p1 = XCreatePixmap(stddpy, DefaultRootWindow(stddpy), width,
				      height, DefaultDepth(stddpy,wd->screen));

	    XCopyArea(stddpy, stdpix, p1, stdgc, x, y, width, height, 0, 0);
	    XSync(stddpy, False);

	    status = XWriteBitmapFile(stddpy, filename, p1, width, height, -1, -1);

	    XSync(stddpy, False);
	    XFreePixmap(stddpy, p1);

	    if (status != BitmapSuccess) return 0;

	  }
	 else if (XWriteBitmapFile(stddpy, filename, stdpix,
				   width, height, -1, -1) != BitmapSuccess)
	    return 0;

       }
    }
   else {
      /*
       * Could optimize by calling XpmWriteFileFromPixmap directly on the
       * stdpix...
       */
      Pixmap p1 = XCreatePixmap(stddpy, DefaultRootWindow(stddpy), width,
			       height, DefaultDepth(stddpy,wd->screen));

      XCopyArea(stddpy, stdpix, p1, stdgc, x, y, width, height, 0, 0);
      XSync(stddpy, False);

#ifdef XpmFormat
      status = XpmWriteFileFromPixmap(stddpy, filename, p1,
				      (Pixmap) NULL, NULL);
#endif					/* XpmFormat */
      XSync(stddpy, False);
      XFreePixmap(stddpy, p1);

#ifdef XpmFormat
      if (status != XpmSuccess)
#endif					/* XpmFormat */
	 return 0;
      }
   return 1;
   }

/*
 * Load an image, in any format we can figure out.
 */
Pixmap loadimage(w, filename, height, width, atorigin, status)
wbp w;
char *filename;
unsigned int *height, *width;
int atorigin;
int *status;
   {
   Pixmap p1, p2 = (Pixmap) NULL;
   int xhot, yhot, i, j;
   XImage *theImage;
   XGCValues gcv;
   static unsigned long *thePixels;
   static unsigned int nPixels;
   int gcmask = GCFont | GCForeground | GCBackground;
   int isxbm;
   STDLOCALS(w);

   if (!strcmp(".xbm", filename + strlen(filename) - 4))
      isxbm = 1;
   else if (!strcmp(".xpm", filename + strlen(filename) - 4) ||
	    !strcmp(".xpm.Z", filename + strlen(filename) - 6))
      isxbm = 0;
   else {
      /*
       * Not sure what kind of file this is, make a guess
       * For example, the format might be on the first line of the file,
       * so open it up and read some.
       */
      FILE *ftemp = fopen(filename,"r");
      char s[6];
      int  i;

      if (!ftemp) {
	 return (Pixmap) NULL;
         }
      if ((long)fread(s,1,6,ftemp) < (long)6) {
	 fclose(ftemp);
	 return (Pixmap) NULL;
         }
      fclose(ftemp);
      /* check s for XPM string */
      isxbm = 1;         /* default to xbm */
      for (i = 0; i <= 3; i++)
	 if (!strncmp(&s[i], "XPM", 3))
	    isxbm = 0;
      }

   if (isxbm) {    /* isxbm = 1 => .xbm file */
      if (XReadBitmapFile(stddpy, DefaultRootWindow(stddpy), filename,
			  width, height, &p1, &xhot, &yhot) != BitmapSuccess)
	 return (Pixmap) NULL;
      else *status = 0;
      p2 = XCreatePixmap(stddpy, DefaultRootWindow(stddpy), *width, *height,
			 DefaultDepth(stddpy,DefaultScreen(stddpy)));
      }
   else {				/* isxbm == 0 => .xpm file */
#ifndef XpmFormat
      return NULL;
#else					/* XpmFormat */
      XpmAttributes a;
      Pixmap dummy;
      a.npixels = 0;
      a.colormap = wd->cmap;
      a.valuemask = XpmReturnPixels | XpmColormap;
      
      *status = XpmReadFileToPixmap(stddpy, DefaultRootWindow(stddpy),
			    filename, &p2, &dummy, &a);

      if (*status == XpmColorFailed && go_virtual(w)) {
	 /* try again with a virtual colormap */
	 a.npixels = 0;
	 a.colormap = wd->cmap;
	 a.valuemask = XpmReturnPixels | XpmColormap;
         *status = XpmReadFileToPixmap(stddpy, DefaultRootWindow(stddpy),
			               filename, &p2, &dummy, &a);
	 }

      if (*status != XpmSuccess) {
         if (*status == XpmColorFailed)
	    *status = 1;
	 else
	    return (Pixmap) NULL;
         }
      else *status = 0;
      *height = a.height;
      *width = a.width;

      /*
       * if the loaded image is to cover an entire window, free up colors
       * currently in use by the window
       */
      if (atorigin && *width >= ws->pixwidth && *height >= ws->pixheight)
	 free_colors(w);

      /*
       * OK, now register all the allocated colors with the display
       * and window in which we are residing.
       */
      for (i = 0; i < a.npixels; i++) {
	 for (j = 2; j < DMAXCOLORS; j++)
	    if (wd->colors[j].refcount == 0) break;
	 if (j == DMAXCOLORS) {
	    return (Pixmap) NULL;
	    }
	 if (j == wd->numColors) wd->numColors++;
         else if (j > wd->numColors) {
	    wd->numColors = j+1;
	    }
	 wd->colors[j].refcount = 1;
	 strcpy(wd->colors[j].name, "");
	 /*
	  * Store their allocated pixel with (r,g,b) of (0,0,0) black.
	  */
	 wd->colors[j].r = wd->colors[0].r;
	 wd->colors[j].g = wd->colors[0].g;
	 wd->colors[j].b = wd->colors[0].b;
	 wd->colors[j].c = a.pixels[i];
	 if (ws->numColors == WMAXCOLORS)
	    ;
	 else
	    ws->theColors[ws->numColors++] = j;
         }
#endif					/* XpmFormat */
      }

   if (p2 == (Pixmap) NULL) {
      return (Pixmap) NULL;
      }

   if (stdgc == NULL) {
      gcv.foreground = wc->fg->c;
      gcv.background = wc->bg->c;
      gcv.font       = wc->font->fsp->fid;
      wc->gc = XCreateGC(stddpy, p2, gcmask, &gcv);
      stdgc = wc->gc;
      }

   if (isxbm) {
      XCopyPlane(stddpy, p1, p2, stdgc, 0, 0, *width, *height, 0, 0, 1);
      XSync(stddpy, False);
      XFreePixmap(stddpy, p1);
      }
   return p2;
   }
#else					/* PresentationManager */

/* -----------------------------------------------------------------------
   Name - dumpimage
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
int dumpimage(wbinding *wb, char *filename, int x, int y, int width,
              int height)
{
  FILE *fp;
  BITMAPINFOHEADER2 bmp;
  PBITMAPINFOHEADER2 pbmp2;
  BITMAPARRAYFILEHEADER2 afhdr;
  PBITMAPINFO2 pbmi;
  int result = 0;
  PBYTE tdata, data;
  ULONG ctblsize, datasize;
  PBYTE ptr, cloc;
  int lshift, rshift, i, j, startbit, startbyte;
  BYTE emask;
  ULONG bytewidth, twidth;
  LONG tmp;
  STDLOCALS(wb);

  /* see if we can open the file - binary mode */
  if (fp = fopen(filename, "wb")) {
    /* initialize the header */
    memset(&afhdr, 0, sizeof(BITMAPARRAYFILEHEADER2));
    pbmp2 = &(afhdr.bfh2.bmp2);

    /* get the info about the source bitmap */
    bmp.cbFix = sizeof(BITMAPINFOHEADER2);
    GpiQueryBitmapInfoHeader(ws->hBitmap, &bmp);

    /* make the info table */
    ctblsize = sizeof(RGB2) * (1 << (bmp.cPlanes * bmp.cBitCount));
    pbmi = (PBITMAPINFO2)calloc(sizeof(BITMAPINFO2) + ctblsize, 1);
    pbmi->cbFix = bmp.cbFix;
    /* convert it to one plane if different */
    pbmi->cBitCount = bmp.cBitCount * bmp.cPlanes;
    pbmi->cPlanes = 1;

    /* allocate space for the data */
    twidth = (pbmi->cBitCount * bmp.cx + 31) / 32 * 4;
    datasize = twidth * height;
    tdata = (PBYTE)calloc(datasize, 1);
    /* query the data from the bitmap */
    GpiQueryBitmapBits(stdbit, ws->bitHeight - y - height, height,
                       tdata, pbmi);
    /* write the header */
    afhdr.usType = BFT_BITMAPARRAY;
    afhdr.cbSize = sizeof(BITMAPARRAYFILEHEADER2);
    afhdr.bfh2.usType = BFT_BMAP;
    afhdr.bfh2.cbSize = sizeof(BITMAPFILEHEADER2);
    afhdr.bfh2.offBits = afhdr.cbSize + ctblsize;
    *pbmp2 = *((PBITMAPINFOHEADER2)pbmi);
    pbmp2->cbImage = (pbmi->cBitCount * width + 31) / 32 * 4 * height;
    pbmp2->cx = width;
    pbmp2->cy = height;
    fwrite((void *)&afhdr, 1, sizeof(BITMAPARRAYFILEHEADER2), fp);
    /* write the color table */
    fwrite((void *)pbmi->argbColor, 1, ctblsize, fp);

    /* write the bitmap data */
    if (width != bmp.cx) {
      /* allocate space for the new bitmap */
      bytewidth = (pbmi->cBitCount * width + 31) / 32 * 4;
      datasize = bytewidth * height;
      data = (PBYTE)calloc(datasize, 1);

      startbit = x * pbmi->cBitCount;
      startbyte = startbit / 8;
      emask = (BYTE)(0xFF << (8 - ((width * pbmi->cBitCount) % 8)));
      /* figure out how much we need to shift the data so that we can
         make the first pel start at a byte boundary (and thus all
         subsequent bytes also..) */
      lshift = startbit % 8;
      rshift = 8 - lshift;

      for (i = 0; i < height; i++) {
        cloc = data + bytewidth * i;
        ptr = tdata + startbyte + twidth * i;
        /* assemble the bytes */
        for (j = 0; j < bytewidth; j++, ptr++, cloc++)
          *cloc = (lshift) ? ((*ptr << lshift) | (*(ptr + 1) >> rshift)) : *ptr;
        /* if width didn't fall on byte bounds, have to knock some data off */
        *cloc = ((*ptr << lshift) & emask);
        } /* End of for - process the scan lines */
      } /* End of if - width is different than scanned width - have to shift */
    else {
      data = tdata;
      tdata = NULL;
      } /* End of else - width is the same as source bitmap */

    /* finally do the write in one big sum */
    fwrite((void *)data, 1, datasize, fp);
    /* put the file away */
    fclose(fp);
    /* get rid of temp structures */
    free(pbmi);
    free(data);
    free(tdata);
    result = 1;
    } /* End of if - could open the file for writing - binary */
  return result;
} /* End of dumpimage */



/* -----------------------------------------------------------------------
   Name - LoadColorTable
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
static PBITMAPINFO2 LoadColorTable(FILE *fp, PBITMAPINFOHEADER2 pbmp, int oflag)
{
  RGB2 *ctbl;
  RGB *tctbl;
  PBITMAPINFO2 pbmi;
  ULONG cbits, ctblsize, nclrs;
  int i;
  
  cbits = pbmp->cPlanes * pbmp->cBitCount;
  nclrs = 1 << cbits;
  ctblsize = (cbits < 24) ? sizeof(RGB2) * nclrs : 0;
  pbmi = (PBITMAPINFO2)calloc(sizeof(BITMAPINFO2) + ctblsize, 1);
  pbmi->cx = pbmp->cx;
  pbmi->cy = pbmp->cy;
  pbmi->cbFix = sizeof(BITMAPINFOHEADER2);
  pbmi->cPlanes = pbmp->cPlanes;
  pbmi->cBitCount = pbmp->cBitCount;
  ctbl = pbmi->argbColor;
  /* if we are true color, we are done */
  if (cbits < 24) {
    /* if we are not the old form, just read in the table.. */
    if (!oflag) 
      return (!fread(ctbl, 1, ctblsize, fp)) ? (free(pbmi), NULL) : pbmi;
    else {
      /* figure the size of table on disk */
      ctblsize = sizeof(RGB) * nclrs;
      tctbl = calloc(ctblsize, 1);
      /* read the old format table in */
      if (!fread(tctbl, 1, ctblsize, fp)) return (free(pbmi), free(tctbl), NULL);
      /* run through the colors, moving them to new format */
      for (i = 0; i < nclrs; i++)
        memcpy(&ctbl[i], &tctbl[i], sizeof(RGB));
      free(tctbl);
      } /* End of else - old format - yuck... */
    } /* End of if - true color */
  return pbmi;
} /* End of LoadColorTable */


/* -----------------------------------------------------------------------
   Name - loadimage
   Purpose -
   Parameters -
   Returns -
   Side Effects -
   ----------------------------------------------------------------------- */
HBITMAP loadimage(wbinding *wb, char *filename, int *width, int *height)
{
  FILE *fp;
  HBITMAP hbm = NULLHANDLE;
  PBITMAPINFOHEADER2 pbmp2;
  BITMAPINFOHEADER2 bmp2;
  PBITMAPINFOHEADER pbmp;
  PBITMAPINFO2 pbmi;
  PBYTE data;
  BITMAPFILEHEADER2 fhdr;
  BITMAPARRAYFILEHEADER2 afhdr;
  ULONG offset, defoffset;
  int found;
  int oldformat = 0;
  STDLOCALS(wb);

  /* zero out the header */
  memset(&bmp2, 0, sizeof(BITMAPINFOHEADER2));
  bmp2.cbFix = sizeof(BITMAPINFOHEADER2);
  /* try to open the file */
  if (fp = fopen(filename, "rb")) {
    /* read the header to figure out what we are dealing with */
    if (!fread((void *)&fhdr, 1, sizeof(BITMAPFILEHEADER2), fp)) 
      return (fclose(fp), NULLHANDLE);
    /* check for a single bitmap in this file */
    if (fhdr.usType == BFT_BMAP) {
      if (fhdr.cbSize == sizeof(BITMAPFILEHEADER2)) 
        pbmp2 = &(fhdr.bmp2);
      else if (fhdr.cbSize == sizeof(BITMAPFILEHEADER)) {
        oldformat = 1;
        pbmp = (PBITMAPINFOHEADER)&(fhdr.bmp2);
        /* reset the file pointer to right after this structure, since we overread */
        fseek(fp, fhdr.cbSize, SEEK_SET);
        } /* End of elseif - old 1.x format */
      else return (fclose(fp), NULLHANDLE);
      offset = fhdr.offBits;
      } /* End of if - solitary bitmap */
    /* check for an array of bitmaps */
    else if (fhdr.usType == BFT_BITMAPARRAY) {
      offset = defoffset = found = 0;
      while (!found) {
        /* read in a header */
        if (fseek(fp, offset, SEEK_SET) || 
            !fread((void *)&afhdr, sizeof(BITMAPARRAYFILEHEADER2), 1, fp) ||
            afhdr.bfh2.usType != BFT_BMAP)
          return (fclose(fp), NULLHANDLE);
        /* check it for the resolution match - 0 will set the default */
        if (afhdr.cxDisplay == ScreenWidth && afhdr.cyDisplay == ScreenHeight)
          found = 1;
        else {
          /* res independant */
          if (!afhdr.cxDisplay) defoffset = offset;
          if (!(offset = afhdr.offNext)) break;
          } /* End of else - don't match the resolution */
        } /* End of while - not found */
      /* check if we got anything, if not read in default */
      if (!found) {
        offset = defoffset;
        fseek(fp, offset, SEEK_SET);
        fread((void *)&afhdr, sizeof(BITMAPARRAYFILEHEADER2), 1, fp);
        } /* End of if - didn't find anything, had to use defualt */
      if (afhdr.cbSize == sizeof(BITMAPARRAYFILEHEADER2)) 
        pbmp2 = &(afhdr.bfh2.bmp2);
      else if (afhdr.cbSize == sizeof(BITMAPARRAYFILEHEADER)) {
        oldformat = 1;
        pbmp = (PBITMAPINFOHEADER)&(afhdr.bfh2.bmp2);
        /* reset the file pointer to right after the header, since we read past it */
        fseek(fp, offset + afhdr.cbSize, SEEK_SET);
        } /* End of elseif - old 1.x format */
      else return (fclose(fp), NULLHANDLE);
      offset = afhdr.bfh2.offBits;
      } /* End of elseif - bitmap array */
    else return (fclose(fp), NULLHANDLE);

    if (oldformat) {
      pbmp2 = &bmp2;
      pbmp2->cx = pbmp->cx;
      pbmp2->cy = pbmp->cy;
      pbmp2->cPlanes = pbmp->cPlanes;
      pbmp2->cBitCount = pbmp->cBitCount;
      pbmp2->cbImage = ((pbmp->cx * pbmp->cBitCount * pbmp->cPlanes) + 31) /
                         32 * 4 * pbmp->cy;
      } /* End of if - load the values for the 'old' format bitmap */

    if (pbmi = LoadColorTable(fp, pbmp2, oldformat)) {
      /* store the dimensions for return */
      *width = pbmi->cx;
      *height = pbmi->cy;
      /* set up space for the data */
      data = (PBYTE)calloc(pbmp2->cbImage, 1);
      if (!fseek(fp, offset, SEEK_SET) && fread((void *)data, 1, pbmp2->cbImage, fp))
        /* build the bitmap compatible with backing bitmap PS */
        hbm = GpiCreateBitmap(stdbit, pbmp2, CBM_INIT, data, pbmi);
      free(data);
      } /* End of if - read of color table suceeded */
    free(pbmi);
    /* put away the file */
    fclose(fp);
    } /* End of if - could open the file */
  /* return the presentation space */
  return hbm;
} /* End of LoadImage */
#endif					/* PresentationManager */
#else					/* XIcon */
static char junk;		/* avoid empty module */
#endif					/* XIcon */
