; Copyright 1990, Tim Farley
;
; NOTE:  Don't use this technique unless you have more than 128
;        bytes of local variables!
;
xproc   PROC NEAR
;
; First, declare our local variables via a structure
;
xloc    STRUC
large1   dw   50 dup(?)            ; a large (100-byte) array
large2   dw   50 dup(?)            ; another one
word1    dw   ?                    ; a word
word2    dw   ?                    ; another word
xloc    ENDS

xlen    equ  SIZE xloc             ; size of our locals 
xbpadj  equ  xlen-128              ; how far we will move sweet spot
xlocals equ  [bp-128]              ; use this to access locals
;
; Now, the actual code
;
         push bp              ; Standard prologue
         mov  bp,sp
         sub  sp,xlen         ; allocate space for locals
;
; Reference passed parameters declared with ARG here, before we adjust
; the value of BP to move the sweet spot.
;
         sub  bp,xbpadj       ; move the sweet spot

;
; Example local references
;
         mov  si,xlocals.large1
         mov  ax,xlocals.word1

         mov  bx,xlocals.large2[di]

;
; Make sure to clean up stack
;
         add  bp,xbpadj       ; put bp back where we found it
;
; You can reference passed parameters declared with ARG again 
; here if you need to alter them for return to the caller.
;
         mov  sp,bp           ; Standard epilogue
         pop  bp
         ret                  ; Be sure to pop arguments if you need to

xproc   ENDP
