


CUT(1)              UNIX Programmer's Manual               CUT(1)



NAME
     cut - cut out selected fields of each line of a file

SYNOPSIS
     cut -clist [file1 file2 ...]
     cut -flist [-dchar] [-s] [file1 file2 ...]

DESCRIPTION
     Use _c_u_t to cut out columns from a table or fields from each
     line of a file; in data base parlance, it implements the
     projection of a relation.  The fields as specified by _l_i_s_t
     can be fixed length, i.e., character positions as on a
     punched card (-c option) or the length can vary from line to
     line and be marked with a field delimiter character like _t_a_b
     (-f option).  _C_u_t can be used as a filter; if no files are
     given, the standard input is used.

     The meanings of the options are:

     _l_i_s_t     A comma-separated list of integer field numbers,
              with optional - to indicate ranges as in the -o
              option of _n_r_o_f_f/_t_r_o_f_f for page ranges; e.g., 1,4,7;
              1-3,8; -5,10 (short for 1-5,10); or 3- (short for
              third through last field).

     -c_l_i_s_t   The _l_i_s_t following -c specifies character positions
              (e.g., -c1-72 would pass the first 72 characters of
              each line).

     -f_l_i_s_t   The _l_i_s_t following -f is a list of fields assumed
              to be separated in the file by a delimiter charac-
              ter (see -d ); e.g., -f1,7 copies the first and
              seventh field only.  Lines with no field delimiters
              will be passed through intact (useful for table
              subheadings), unless -s is specified.

     -d_c_h_a_r   The character following -d is the field delimiter
              (-f option only).  Default is _t_a_b.  Space or other
              characters with special meaning to the shell must
              be quoted.

     -s       Suppresses lines with no delimiter characters in
              case of -f option.  Unless specified, lines with no
              delimiters will be passed through untouched.

     Either the -c or -f option must be specified.

HINTS
     Use _g_r_e_p(1) to make horizontal ``cuts'' (by context) through
     a file, or _p_a_s_t_e(1) to put files together column-wise (i.e.,
     horizontally).  To reorder columns in a table, use _c_u_t and
     _p_a_s_t_e.



Printed 3/5/87                                                  1






CUT(1)              UNIX Programmer's Manual               CUT(1)



EXAMPLES
     cut -d: -f1,5 /etc/passwd
                           mapping of user IDs to names

     name=`who am i | cut -f1 -d" "`
                           to set name to current login name.

DIAGNOSTICS
     Error messages may come from getopt(3). All error messages
     contain limits for line and field lenghts.

SEE ALSO
     grep(1), paste(1).  getopt(3)










































Printed 3/5/87                                                  2



