-- TXT2DAT.ADA   Ver. 2.02   4-SEP-1992   Copyright 1988-1992 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- After running DAT2TXT on a PC and transferring the resulting TUTOR.TXT
-- file to another computer, compile and run this program on the other
-- computer to create ADA_TUTR.DAT on that machine.
--
with DIRECT_IO, TEXT_IO;
procedure TXT2DAT is
   subtype BLOCK_SUBTYPE is STRING(1 .. 64);
   package RANDOM_IO is new DIRECT_IO(BLOCK_SUBTYPE);
   TEXT_FILE  : TEXT_IO.FILE_TYPE;                           -- The input file.
   DATA_FILE  : RANDOM_IO.FILE_TYPE;                        -- The output file.
   OK         : BOOLEAN := TRUE;     -- True when both files open successfully.
   INPUT      : STRING(1 .. 65);           -- Line of text read from TUTOR.TXT.
   LEN        : INTEGER;                 -- Length of line read from TUTOR.TXT.
   LEGAL_NOTE : constant STRING := " Copyright 1988-92 John J. Herro ";
                       -- LEGAL_NOTE isn't used by the program, but it causes
                       -- most compilers to place this string in the .EXE file.
begin
   begin
      TEXT_IO.OPEN(TEXT_FILE, MODE => TEXT_IO.IN_FILE, NAME => "TUTOR.TXT");
   exception
      when TEXT_IO.NAME_ERROR =>
         TEXT_IO.PUT_LINE(
              "I'm sorry.  The file TUTOR.TXT seems to be missing.");
         OK := FALSE;
   end;
   begin
      RANDOM_IO.CREATE(DATA_FILE, RANDOM_IO.OUT_FILE, NAME => "ADA_TUTR.DAT");
   exception
      when others =>
         TEXT_IO.PUT_LINE("I'm sorry.  I can't seem to create ADA_TUTR.DAT.");
         TEXT_IO.PUT_LINE("Perhaps that file already exists?");
         OK := FALSE;
   end;
   if OK then
      while not TEXT_IO.END_OF_FILE(TEXT_FILE) loop
         TEXT_IO.GET_LINE(FILE => TEXT_FILE, ITEM => INPUT, LAST => LEN);
         if LEN > 3 then  -- In case extra CRs/LFs were added to the text file.
            INPUT(LEN + 1 .. 64) := (others => ' ');
              -- In case trailing blanks were lost when transferring TUTOR.TXT.
            RANDOM_IO.WRITE(DATA_FILE, ITEM => INPUT(1 .. 64));
         end if;
      end loop;
      TEXT_IO.CLOSE(TEXT_FILE);
      RANDOM_IO.CLOSE(DATA_FILE);
      TEXT_IO.PUT_LINE("ADA_TUTR.DAT created.");
   end if;
end TXT2DAT;
