------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
-- C O M P I L E R _ E X C E P T I O N S . M A C H I N E _ S P E C I F I C S--
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.1 $                             --
--                                                                          --
--   Copyright (C) 1991,1992,1993,1994,1995,1996 Florida State University   --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is the DJGPP V2 version of this package.

--  This file performs the system-dependent translation between machine
--  exceptions and the Ada exceptions, if any, that should be raised when
--  they occur.  This version works for the i486 running linux.

--  ??? This should not be part of tasking, since it is needed whether tasking
--      is used or not.  This file will eventually go away or be incorporated
--      into the non-tasking runtime.

with Interfaces.C; use Interfaces.C;

with Interfaces.C.POSIX_RTE;

package body System.Compiler_Exceptions.Machine_Specifics is

   package RTE renames Interfaces.C.POSIX_RTE;

   ------------------------
   -- Identify_Exception --
   ------------------------

   --  This function identifies the Ada exception to be raised using
   --  the information when the system received a synchronous signal.
   --  Since this function is machine and OS dependent, different code
   --  has to be provided for different target.

   --  Following code is intended for i486.

   function Identify_Exception
     (Which              : System.Task_Primitives.Machine_Exceptions;
      Info               : System.Task_Primitives.Error_Information;
      Modified_Registers : Pre_Call_State) return Ada.Exceptions.Exception_Id
   is

      type sigcontext is record
         gs            : unsigned_short;
         fs            : unsigned_short;
         es            : unsigned_short;
         ds            : unsigned_short;
         edi           : unsigned_long;
         esi           : unsigned_long;
         ebp           : unsigned_long;
         esp           : unsigned_long;
         ebx           : unsigned_long;
         edx           : unsigned_long;
         ecx           : unsigned_long;
         eax           : unsigned_long;
         trapno        : unsigned_long;
         err           : unsigned_long;
         eip           : unsigned_long;
         cs            : unsigned_short;
         eflags        : unsigned_long;
         esp_at_signal : unsigned_long;
         ss            : unsigned_short;
         i387          : unsigned_long;
         oldmask       : unsigned_long;
         cr2           : unsigned_long;
      end record;

      type sigcontext_ptr is access sigcontext;

      --  The above operations will be available as predefined operations on
      --  the modula Address type in GNARL, since this package is a child of
      --  System.

      FPE_INTOVF_TRAP   : constant int := 16#1#;  -- Int overflow
      FPE_STARTSIG_TRAP : constant int := 16#2#;  -- process using fp
      FPE_INTDIV_TRAP   : constant int := 16#14#; -- Int divide by zero
      FPE_FLTINEX_TRAP  : constant int := 16#c4#; -- floating inexact result
      FPE_FLTDIV_TRAP   : constant int := 16#c8#; -- floating divide by zero
      FPE_FLTUND_TRAP   : constant int := 16#cc#; -- floating underflow
      FPE_FLTOPERR_TRAP : constant int := 16#d0#; -- floating operand error
      FPE_FLTOVF_TRAP   : constant int := 16#d4#; -- floating overflow

      --  Following is SIGILL generated by trap 5 instruction

      ILL_CHECK_TRAP    : constant int := 16#80# + 16#05#;

      function Pre_Call_To_Context is new
        Unchecked_Conversion (Pre_Call_State, sigcontext_ptr);


      Current_Exception : Ada.Exceptions.Exception_Id;

      context : sigcontext_ptr :=
                  Pre_Call_To_Context (Modified_Registers);

      sig     : RTE.Signal := RTE.Signal (Which);

   begin

      --  As long as we are using a longjmp to return control to the
      --  exception handler on the runtime stack, we are safe. The original
      --  signal mask (the one we had before coming into this signal catching
      --  function) will be restored by the longjmp. Therefore, raising
      --  an exception in this handler should be a safe operation.

      case sig is

         when RTE.SIGFPE =>

            Current_Exception := Constraint_Error_Id;

         when RTE.SIGILL =>

            case Info.si_code is

               when ILL_CHECK_TRAP =>
                  Current_Exception := Constraint_Error_Id;

               when others =>

                  pragma Assert (false, "Unexpected SIGILL signal");
                  null;
            end case;

         when RTE.SIGSEGV =>

            Current_Exception := Storage_Error_Id;

         --  If the address that caused the error was in the first page, this
         --  was caused by accessing a null pointer.

--            if context.sc_o0 >= 0 and context.sc_o0 < 16#2000# then
--               Current_Exception := Constraint_Error_Id;
--
--            else
--               Current_Exception := Storage_Error_Id;
--            end if;

         when others =>

            pragma Assert (false, "Unexpected signal");
            null;
      end case;

      return Current_Exception;

   end Identify_Exception;

end System.Compiler_Exceptions.Machine_Specifics;
