

/*
    GWMON Parallel Ada Monitor for 386/486 PCs   
    Copyright (C) 1993, Charles W. Kann  & Michael Bliss Feldman
                        ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ed.h"
#include "keydef.h"
#define DISPLAY_ONLY -1

int
CWK_Get_Int( mode, save_row, save_col, length, initial_value, print_help )
int mode, save_row, save_col, length, *initial_value;
void (*print_help) ();
{
	int ret_val, col, icnt;
	int process;
	char digit;
	char *save_string, format[20];

	ret_val = 0;
	col = save_col;

	save_string = (char *) malloc( ( sizeof(char) * length ) + 1 );
	sprintf( format, "%c-%2.2d.1d", '%', length );
	sprintf( save_string, format, *initial_value );

	process = 1;
	while( process )
	{
		_settextposition( save_row, save_col );
		_outtext( save_string );
		if ( mode == DISPLAY_ONLY )
			return -2;
		_settextposition( save_row, col );
		digit = getch();
		switch ( digit ) {

		case ESC :
			ret_val = -1;
			process = 0;
			break;
			
		case CTRL_M :
		case CTRL_I :
			process = 0;
			break;

		case '?' :
			print_help();
			break;

		case CTRL_H :
			if ( --col < save_col )
			{
				col = save_col;
			}
			else
			{
				for ( icnt = col - save_col; icnt < length-1;
				      ++icnt )
				{
					save_string[icnt] = save_string[icnt+1];
				}
				save_string[length-1] = ' ';
			}
			break;

		case DEL :
			for ( icnt = col - save_col; icnt < length-1;
			      ++icnt )
			{
				save_string[icnt] = save_string[icnt+1];
			}
			save_string[length-1] = ' ';
			break;

		case LEFTARROW :
			if ( --col < save_col )
			{
				col = save_col;
			}
			break;

		case RIGHTARROW :
			if ( ++col > save_col + length - 1 )
			{
				col = save_col + length - 1;
			}
			break;

		case  '0' :
		case  '1' :
		case  '2' :
		case  '3' :
		case  '4' :
		case  '5' :
		case  '6' :
		case  '7' :
		case  '8' :
		case  '9' :
		case  ' ' :
			save_string[col-save_col] = digit;
			if ( ++col > save_col + length - 1 )
			{
				col = save_col + length - 1;
			}
			break;
		default :
			break;
		}
	}

	*initial_value = 0;

	for ( icnt = 0; icnt < length; ++icnt )
	{
		if ( save_string[icnt] == ' ' )
			break;
		*initial_value = ( *initial_value * 10 ) + ( save_string[icnt] - '0' );
	}
	return ret_val;
}

char *
CWK_Get_String( row, col, length )
int row, col, length;
{
}

int
CWK_Get_Choice( mode, row, col, length, initial_value, choices, print_help )
int mode, row, col, length, *initial_value;
char **choices;
void (*print_help) ();
{
	int process, icnt, Number_Of_Choices, choice, ret_val;
	char *msg, format[40];

	ret_val = 0;

	msg = (char *) malloc( (sizeof(msg)*length) + 1 );

	Number_Of_Choices = 0;
	while( 1 )
	{
		if ( *choices[Number_Of_Choices] == '\0' )
			break;
		Number_Of_Choices++;
	}
	Number_Of_Choices--;

	icnt = *initial_value;
	process = 1;
	while( process )
	{
		if ( icnt < 0 )
			icnt = Number_Of_Choices;
		else if ( *choices[icnt] == '\0' )
		{
			icnt = 0;
		}

		sprintf( format, "%c-%2.2d.%2.2ds", '%', length, length );
		sprintf( msg, format, choices[icnt] );
		_settextposition( row, col );
		_outtext( msg );
		if ( mode == DISPLAY_ONLY )
			return -2;
		_settextposition( row, col );
		choice = getch();
		switch (choice) {
		
		case ESC :
			ret_val = -1;
			process = 0;
			break;
		case CTRL_M :
		case CTRL_I :
			process = 0;
			break;
		case '?' :
			print_help();
			break;

		case UPARROW :
			icnt--;
			break;
		case DOWNARROW :
			icnt++;
			break;
		default :
			break;
		}
	}
	*initial_value = icnt;
	return ret_val;
}

long
CWK_Get_Long( mode, save_row, save_col, length, initial_value )
int mode, save_row, save_col, length;
long *initial_value;
{
	int  col, icnt;
	long ret_val;
	int process;
	char digit;
	char *save_string, format[20];

	ret_val = 0;
	col = save_col;

	save_string = (char *) malloc( ( sizeof(char) * length ) + 1 );
	sprintf( format, "%c-%2.2d.1d", '%', length );
	sprintf( save_string, format, *initial_value );

	process = 1;
	while( process )
	{
		_settextposition( save_row, save_col );
		_outtext( save_string );
		if ( mode == DISPLAY_ONLY )
			return -2;
		_settextposition( save_row, col );
		digit = getch();
		switch ( digit ) {

		case ESC :
			ret_val = -1;
			process = 0;
			break;
		case CTRL_M :
		case CTRL_I :
			process = 0;
			break;

		case CTRL_H :
			if ( --col < save_col )
			{
				col = save_col;
			}
			else
			{
				for ( icnt = col - save_col; icnt < length-1;
				      ++icnt )
				{
					save_string[icnt] = save_string[icnt+1];
				}
				save_string[length-1] = ' ';
			}
			break;

		case DEL :
			for ( icnt = col - save_col; icnt < length-1;
			      ++icnt )
			{
				save_string[icnt] = save_string[icnt+1];
			}
			save_string[length-1] = ' ';
			break;

		case LEFTARROW :
			if ( --col < save_col )
			{
				col = save_col;
			}
			break;

		case RIGHTARROW :
			if ( ++col > save_col + length - 1 )
			{
				col = save_col + length - 1;
			}
			break;

		case  '0' :
		case  '1' :
		case  '2' :
		case  '3' :
		case  '4' :
		case  '5' :
		case  '6' :
		case  '7' :
		case  '8' :
		case  '9' :
		case  ' ' :
			save_string[col-save_col] = digit;
			if ( ++col > save_col + length - 1 )
			{
				col = save_col + length - 1;
			}
			break;
		default :
			break;
		}
	}

	*initial_value = 0;

	for ( icnt = 0; icnt < length; ++icnt )
	{
		if ( save_string[icnt] == ' ' )
			break;
		*initial_value = ( *initial_value * 10 ) + ( save_string[icnt] - '0' );
	}
	return ret_val;
}
