# 
# AWK script to output prototype definitions for assembly language
# procedures declared with PROC. Optionally output interface-
# related assembler directives.  Morten Elling, Mar 1996, May 1997.
#
# Usage: awk -f proto.awk [LIST2=1 [IDEAL=1]] file.asm [>output.fil]
#	LIST2=1: output lines with certain assembler directives
#	IDEAL=1: assume Ideal syntax for LIST2 directives
#
#
# Note: Understands TASM and MASM's extended PROC syntax, also
#	in TASM's Ideal mode, but is otherwise ignorant.
# ToDo:	Strip ARG equate if present (TASM only).


#### Make set array from string
function zsplit(str, arr     ,i, j ,temp) {	# i,j,temp = locals
	j = split(str, temp);
	for (i = 1; i <= j; i++)  arr[temp[i]] = 1;
}


BEGIN { # Initialize

	# Lines with specified directives are output if LIST2 > 0
	if (IDEAL) {	# Keyword is 1st token on a line
	list1dir = "model public global extrn procdesc proctype typedef";
	list2dir = "";
	} else {
	list1dir = "model .model public global extrn externdef" \
		   " extern dosseg ";
	list2dir = "procdesc proctype typedef proto";
	}
	zsplit(list1dir, list1set);
	zsplit(list2dir, list2set);
}
{ # Main loop begins

##### Skip comments
if ($0 ~ /^;/)  next;

##### Combine "\"-ended lines to one
if (prevLn != "") {
	sub(/^[ \t]+/, "");		# Left-trim
	$0 = prevLn " " $0; 		# Append to previous line
	prevLn = "";
}
	gsub(/;.*$/, "");		# Remove ";" thru eol
if ($0 ~ /\\.*$/) {			# Remove "\" thru eol
	gsub(/\\.*$/, "");
	prevLn = $0;
	next;				# Skip to next line
}
tok1 = tolower($1);
tok2 = tolower($2);

##### Support for TASM's separate-line ARG
if (inProc) {
	if (tok1 == "uses")  next;	# Skip to next line
	if (tok1 == "local") next;
	inProc = 0;
	if (tok1 == "arg") {
	   gsub(/\t/, " ");		# Replace tabs with spaces
	   $1 = "";			# Strip off "ARG"
	   # Append args to prototype
	   protos[count] = protos[count] " " $0;
	   next;
	}
}
inProc = 0;

##### Output optional extras
if (LIST2) {
	if (tok1 in list1set) print;
	if (tok2 in list2set) print;
}

##### Handle PROC
if ( tok2 == "proc" || tok1 == "proc" ) {
   # Support for MASM's comma-ended multi-line arg construct
	if ( match($0, /,[ \t]*$/) ) {
		prevLn = $0;
		next;
	}

   # Do string replacements
	# print $0			# Un-comment for debug output
	gsub(/\t/, " ");		# Replace tabs with spaces
	# Replace " uses uses_list," with ""
	if (!sub(/ (U|u)(S|s)(E|e)(S|s) [ a-zA-Z]*,/, "", $0 ))
	     sub(/ (U|u)(S|s)(E|e)(S|s) [ a-zA-Z]*$/, "", $0 );
	# TASM only: strip off " returns arg_list" at eol
	sub(/ (R|r)(E|e)(T|t)(U|u)(R|r)(N|n)(S|s) [ a-zA-Z0-9_$?:]+$/, "", $0);
	# Replace "proc" with "procdesc"
	if (tok1 == "proc")
	   { $1 = "procdesc\t" }	# Ideal syntax
	else if (length($1) < 7)
	   { $2 = "\t\tprocdesc" }
	else { $2 = "\tprocdesc" };

   # Remember prototype definition
	protos[++count] = $0;
	inProc = 1;			# Flag looking for "ARG"
}
} ##### Main loop ends
END {
	printf("; procdesc equ proto\n");
	for (i = 1; i <= count; i++)
	   printf("%s\n", protos[i]);	# Output results
} # eof