Unit BCD;       (* 16-bit BCDASM routines (for Turbo Pascal 6.0) *)
{$G+}           (* Requires 80286+ CPU *)

INTERFACE

const
        MIN_SIZEOF_BCD  = 4;
        MAX_SIZEOF_BCD  = (65535-MIN_SIZEOF_BCD+1);
        MAX_SIZEOF_XBCD = (MAX_SIZEOF_BCD SHR 1);

type
	uint  = word;	(* 16-bit *)
	pbyte = ^byte;	(* BCD is an array of bytes *)
        pchar = ^char;  (* Pointer to a zero-terminated
                           string, NOT to a Pascal string *)


(* BCDASM procedure/function prototypes *)
(* math *)
procedure bcdAbs    (dst:pbyte; sz:uint);
function  bcdNeg    (dst:pbyte; sz:uint) : integer;
function  bcdCmp    (dst:pbyte; src:pbyte; sz:uint) : integer;
function  bcdCmpz   (dst:pbyte; sz:uint) : integer;
function  bcdAdd    (dst:pbyte; src:pbyte; sz:uint) : integer;
function  bcdSub    (dst:pbyte; src:pbyte; sz:uint) : integer;
procedure bcdImul   (xdst:pbyte; xsrc:pbyte; sz:uint);
function  bcdIdiv   (xdst:pbyte; xsrc:pbyte; sz:uint) : integer;
function  bcdShr    (dst:pbyte; sz:uint; count:uint) : integer;
function  bcdShl    (dst:pbyte; sz:uint; count:uint) : integer;
(* transfer *)
procedure bcdMov    (dst:pbyte; src:pbyte; sz:uint);
procedure bcdSwap   (dst:pbyte; src:pbyte; sz:uint);
procedure bcdLdz    (dst:pbyte; sz:uint);
procedure bcdLd1    (dst:pbyte; sz:uint);
procedure bcdLd100  (dst:pbyte; sz:uint);
(* conversion *)
procedure bcdSx     (xdst:pbyte; src:pbyte; srcsz:uint);
function  bcdIsbcd  (dst:pbyte; sz:uint) : integer;
function  bcdA2p    (dst:pbyte; dstsz:uint; pStr:pchar) : integer;
function  bcdP2a    (pStr:pchar; src:pbyte; srcsz:uint) : uint;
function  bcdB2p    (dst:pbyte; dstsz:uint; src:pointer; srcsz:uint) : integer;
procedure bcdP2b    (dst:pointer; dstsz:uint; src:pbyte; srcsz:uint);
procedure bcdBe2le  (dst:pbyte; src:pbyte; srcsz:uint);
procedure bcdLe2be  (dst:pbyte; src:pbyte; srcsz:uint);
function  bcdU2p    (dst:pbyte; usrc:pbyte; srcsz:uint) : integer;
procedure bcdP2u    (udst:pbyte; src:pbyte; srcsz:uint);
function  bcdFmt    (pStr:pchar; strsz:uint; pBCD:pbyte; sz:uint;
		     width:uint; numDec:uint; prec:uint; rtJust:byte;
		     signCh:char; fillCh:char; sepCh:char; sepMCh:char) :uint;


(* BCDUU prototypes (for unpacked unsigned BCDs) *)
procedure BCDUUmov  (dst:pbyte; src:pbyte; sz:uint);
function  BCDUUadd  (dst:pbyte; src:pbyte; sz:uint) : integer;
function  BCDUUsub  (dst:pbyte; src:pbyte; sz:uint) : integer;
function  BCDUUu2p  (dst:pbyte; src:pbyte; srcsz:uint) : integer;
function  BCDUUu2a  (pStr:pchar; src:pbyte; srcsz:uint) : uint;
procedure BCDUUmul  (xdst:pbyte; xsrc:pbyte; sz:uint);


(* BIN2ASC *)
function  bin2asc   (pStr:pchar; src:pbyte; srcsz:uint) : uint;
function  HexN	    (pStr:pchar; mval:uint) : uint;


(* CONSOLIO *)
function  IsDevRedir (hDev:uint) : integer;
function  GetKey     : char;
function  WriteZStr  (pStr:pchar) : uint;
function  WriteNL    : uint;


(*
 Function return values
 Fnx         < 0        = 0         > 0
 bcdNeg    dst < 0    dst = 0     dst > 0
 bcdCmp    dst < src  dst = src   dst > src
 bcdCmpz   dst < 0    dst = 0     dst > 0
 bcdAdd    n/a        No carry    Carry
 bcdSub    n/a        No borrow   Borrow
 bcdIdiv   n/a        DivZ/Ovf    No error
 bcdShr    n/a        dst = 0     dst <> 0
 bcdShl    n/a        dst = 0     dst <> 0
 bcdIsbcd  n/a        Error       No error
 bcdA2p    n/a        Error       No error
 bcdP2a    n/a        n/a         String length
 bcdB2p    n/a        Error       No error
 bcdU2p    n/a        Error       No error
 bcdFmt    n/a        Error       String length
 -
 BCDUUadd  n/a        No carry    Carry
 BCDUUsub  n/a        No borrow   Borrow
 BCDUUu2p  n/a        Error       No error
 BCDUUu2a  n/a        n/a         String length
 -
 bin2asc   n/a        Error       String length  (C string)
 HexN      n/a        n/a         String length  (C string)
 -
 IsDevRedir Error     No          Yes
 GetKey     n/a       Ascii character
 WriteZStr  n/a       No. of bytes written to stdout (C string)
 WriteNL    n/a       No. of bytes written to stdout
*)



IMPLEMENTATION
(* Assemble externals as '.model large, pascal' *)
{$L bcdAbs.obj}
procedure bcdAbs;    external;
{$L bcdNeg.obj}
function  bcdNeg;    external;
{$L bcdCmp.obj}
function  bcdCmp;    external;
{$L bcdCmpz.obj}
function  bcdCmpz;   external;
{$L bcdAdd.obj}
function  bcdAdd;    external;
function  bcdSub;    external;
{$L bcdImul.obj}
procedure bcdImul;   external;
{$L bcdIdiv.obj}
function  bcdIdiv;   external;
{$L bcdShr.obj}
function  bcdShr;    external;
{$L bcdShl.obj}
function  bcdShl;    external;
{$L bcdMov.obj}
procedure bcdMov;    external;
{$L bcdSwap.obj}
procedure bcdSwap;   external;
{$L bcdLd.obj}
procedure bcdLdz;    external;
procedure bcdLd1;    external;
procedure bcdLd100;  external;
{$L bcdSx.obj}
procedure bcdSx;     external;
{$L bcdIsbcd.obj}
function  bcdIsbcd;  external;
{$L bcdP2a.obj}
function  bcdA2p;    external;
function  bcdP2a;    external;
{$L bcdP2b.obj}
function  bcdB2p;    external;
procedure bcdP2b;    external;
{$L bcdBe2le.obj}
procedure bcdBe2le;  external;
procedure bcdLe2be;  external;
{$L bcdP2u.obj}
function  bcdU2p;    external;
procedure bcdP2u;    external;
{$L bcdFmt.obj}
function  bcdFmt;    external;
{}
{$L bcduu.obj}
procedure BCDUUmov;  external;
function  BCDUUadd;  external;
function  BCDUUsub;  external;
function  BCDUUu2p;  external;
function  BCDUUu2a;  external;
procedure BCDUUmul;  external;
{}
{$L bin2asc.obj}
function  bin2asc;   external;
function  HexN;      external;
{}
{$L consolio.obj}
function  IsDevRedir;external;
function  GetKey;    external;
function  WriteZStr; external;
function  WriteNL;   external;
END.
