
; ----- BCDASM procedure prototypes
	@CODESEG
; -math
@proto	bcdAbs	  dst:dataptr, sz:@uint
@proto	bcdNeg	  dst:dataptr, sz:@uint
@proto	bcdCmp	  dst:dataptr, src:dataptr, sz:@uint
@proto	bcdCmpz   dst:dataptr, sz:@uint
@proto	bcdAdd	  dst:dataptr, src:dataptr, sz:@uint
@proto	bcdSub	  dst:dataptr, src:dataptr, sz:@uint
@proto	bcdImul   xdst:dataptr, xsrc:dataptr, sz:@uint
@proto	bcdIdiv   xdst:dataptr, xsrc:dataptr, sz:@uint
@proto	bcdShr	  dst:dataptr, sz:@uint, count:@uint
@proto	bcdShl	  dst:dataptr, sz:@uint, count:@uint
; -transfer
@proto	bcdMov	  dst:dataptr, src:dataptr, sz:@uint
@proto	bcdSwap   dst:dataptr, src:dataptr, sz:@uint
@proto	bcdLdz	  dst:dataptr, sz:@uint
@proto	bcdLd1	  dst:dataptr, sz:@uint
@proto	bcdLd100  dst:dataptr, sz:@uint
; -conversion
@proto	bcdSx	  xdst:dataptr, src:dataptr, srcsz:@uint
@proto	bcdIsbcd  dst:dataptr, sz:@uint
@proto	bcdA2p	  dst:dataptr, dstsz:@uint, pStr:dataptr
@proto	bcdP2a	  pStr:dataptr, src:dataptr, srcsz:@uint
@proto	bcdB2p	  dst:dataptr, dstsz:@uint, src:dataptr, srcsz:@uint
@proto	bcdP2b	  dst:dataptr, dstsz:@uint, src:dataptr, srcsz:@uint
@proto	bcdBe2le  dst:dataptr, src:dataptr, srcsz:@uint
@proto	bcdLe2be  dst:dataptr, src:dataptr, srcsz:@uint
@proto	bcdU2p	  dst:dataptr, usrc:dataptr, srcsz:@uint
@proto	bcdP2u	  udst:dataptr, src:dataptr, srcsz:@uint
@proto	bcdFmt	  pStr:dataptr, strsz:@uint, pBCD:dataptr, sz:@uint,\
		  width:@uint, numDec:@uint,prec:@uint, rtJust:byte,\
		  signCh:byte, fillCh:byte, sepCh:byte, sepMCh:byte




; ----- Procedure return values (undefined if not stated)
; Proc	    Returns	   Acc < 0   Acc = 0    Acc > 0
; bcdNeg    Acc,cf,zf,sf   dst < 0   dst = 0    dst > 0
; bcdCmp    Acc (cf,zf,sf) dst < src dst = src  dst > src
; bcdCmpz   Acc (cf,zf,sf) dst < 0   dst = 0    dst > 0
; bcdAdd    Acc,cf,zf,sf   n/a	     No carry   Carry
; bcdSub    Acc,cf,zf,sf   n/a	     No borrow  Borrow
; bcdIdiv   Acc 	   n/a	     DivZ/Ovf   No error
; bcdShr    Acc,zf	   n/a	     dst = 0    dst <> 0
; bcdShl    Acc,zf (cf)    n/a	     dst = 0    dst <> 0
; bcdIsbcd  Acc 	   n/a	     Error      No error
; bcdA2p    Acc 	   n/a	     Error      No error
; bcdP2a    Acc 	   n/a	     n/a        String length
; bcdB2p    Acc 	   n/a	     Error      No error
; bcdU2p    Acc 	   n/a	     Error      No error
; bcdFmt    Acc 	   n/a	     Error      String length




; ----- MIN/MAX
; Here are the byte sizes BCD variables
; must obey to make results predictable:
;	MIN_SIZEOF_BCD	= 4
;	MAX_SIZEOF_BCD	= (0 - MIN_SIZEOF_BCD)
;	MAX_SIZEOF_XBCD = (MAX_SIZEOF_BCD / 2)
;	.errnz (SIZEOF_BCD MOD 2)
