	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Exchange (swap) two packed signed BCD numbers

	include	model.inc
	include	modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdSwap
;//	Desc	Exchange (swap) two packed signed BCD numbers.
;//
;//
;//	Entry	Passed args
;//	Exit	Contents of numbers exchanged.
;//		Acc undefined.

bcdSwap proc
arg	dstBCD	:dataptr, \	; Addr of 1st BCD
	srcBCD	:dataptr, \	; Addr of 2nd BCD
	BCDsz	:@uint		; Byte size of each BCD
@uses	ds,es,rsi,rdi,rcx,rax
;.
	mov   rcx, [BCDsz]
	@LDS  rsi, [srcBCD]
	@LES  rdi, [dstBCD]
	@alignn
@@swp:	mov   al, [rsi]
	xchg  al, @ES [rdi]
	mov   [rsi], al
	inc   rsi
	inc   rdi
	dec   rcx
	jnz   @@swp
	RET
bcdSwap endp

	END