#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>

void patch(unsigned long int address, unsigned char origbyte, unsigned char patchbyte, FILE *target, int no_orig, int restore, int zeile, int reset_patchanyway);


void patch(unsigned long int address, unsigned char origbyte, unsigned char patchbyte, FILE *target, int no_orig, int restore, int zeile, int reset_patchanyway)
/*
patch changes in the file target the byte at address in patchbyte, or if
restore is enabled, in origbyte. If origbyte is given it's compared
with the real origbyte and if they are not identical the user is prompted
whether to continue (Yes/on/always). The always-option must be set new for
every file. If the real origbyte and the patchbyte are identical a message
is created and patch returns. If there is no origbyte given and restore
is enabled a warning message is created and the user is prompted whether
to continue.
A short information (address: origbyte -> patchbyte) will be printed out.
*/
{
static int no_orig_anyway=0, wrong_orig_anyway=0;
unsigned char realorigbyte=0;
int c;

if (reset_patchanyway)            // kill patchanyway-flags (multiple files)
  {
  no_orig_anyway = 0;
  wrong_orig_anyway = 0;
  return;
  }

if (no_orig)       // no orig-byte given
  {
  if (restore)     // restoring ?
    {
    fprintf(stderr, " No orig-byte info found at line %i, cannot restore. Abort (Y/n) ? ", zeile);
    c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
    if (c != 'N')
      {
      exit(255);
      }
    }
   else
    {
    fprintf(stderr, " No orig-byte info found at line %i, cannot compare,", zeile);
    if (no_orig_anyway)  // patch always
      {
      fprintf(stderr, " patching anyway.\n");
      }
     else
      {
      fprintf(stderr, " patch anyway (Y/n/a) ? ");
      c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
      switch (c)
        {
        case 'A':
          no_orig_anyway = 1;
          break;
        case 'N':
        case 0x1B:
          return;
        default:
          break;
        }
      }
    }
  }


fseek(target, address, SEEK_SET);           // go to address
realorigbyte = fgetc(target);               // get real orig-byte in file

if (restore)               // if restore pb = ob
  {
  patchbyte = origbyte;
  }
 else
  {
  if (realorigbyte == patchbyte && !no_orig)  // real byte in file == patchbyte and origbyte given
    {    // so say it and do nothing
    fprintf(stderr, " %04lX: Old byte == patchbyte (0x%02X). Already patched ?\n", address, (int)patchbyte);
    return;
    }
  if (origbyte != realorigbyte && !no_orig)   // real byte in file != origbyte and origbyte given
    {    // say it and ask
    fprintf(stderr, " %04lX: Expected orig-byte (0x%02X) != real byte (0x%02X).", address, (int)origbyte, (int)realorigbyte);
    if (wrong_orig_anyway)
      {
      fprintf(stderr, " Patching anyway.\n");
      }
     else
      {
      fprintf(stderr, " Patch anyway (Y/n/a) ? ");
      c = getche(); c = toupper((unsigned char)c); fprintf(stderr, "\n");
      switch (c)
        {
        case 'A':
          wrong_orig_anyway = 1;
          break;
        case 'N':
        case 0x1B:
          return;
        default:
          break;
        }
      }
    }
  }

fseek(target, address, SEEK_SET);                 // else fputc says "failure"
if (fputc(patchbyte, target) == EOF)              // write patchbyte
  { fprintf(stderr, "\n Failure while writing to targetfile. Aborting.\n"); exit(255); }
printf(" %04lX: 0x%02X -> 0x%02X\n", address, (int)realorigbyte, (int)patchbyte);     // print out short info

return;
}
