//***************************************************************************
//
//  CtlDemo.h
//
//***************************************************************************

class CColorText : public CStatic
{
protected:
    COLORREF m_crTextColor;
    COLORREF m_crBkColor;
    CBrush m_brBkgnd;

public:
    CColorText ();
    void SetTextColor (COLORREF);
    void SetBkColor (COLORREF);

protected:
    afx_msg HBRUSH CtlColor (CDC*, UINT);
    DECLARE_MESSAGE_MAP ()
};

/////////////////////////////////////////////////////////////////////////////

class CEditListBox : public CListBox
{
private:
    int m_nIndex;

public:
    virtual BOOL PreCreateWindow (CREATESTRUCT&);
    virtual void DrawItem (LPDRAWITEMSTRUCT);

    void UpdateItemText (CString&);

protected:
    afx_msg void OnEditItem ();
    afx_msg LRESULT OnSetFont (UINT, LONG);

    DECLARE_MESSAGE_MAP ()
};

/////////////////////////////////////////////////////////////////////////////

class CLBEdit : public CEdit
{
public:
    virtual void PostNcDestroy ();

protected:
    afx_msg void OnChar (UINT, UINT, UINT);
    afx_msg void OnKillFocus (CWnd*);

    DECLARE_MESSAGE_MAP ()
};

/////////////////////////////////////////////////////////////////////////////

class CMyApp : public CWinApp
{
public:
    virtual BOOL InitInstance ();
};

/////////////////////////////////////////////////////////////////////////////

class CMainWindow : public CFrameWnd
{
private:
    int m_cxChar;
    int m_cyChar;
    CFont m_font;

    CButton m_ctlRadioButtonRed;
    CButton m_ctlRadioButtonGreen;
    CButton m_ctlRadioButtonBlue;
    CButton m_ctlGroupBox1;
    CButton m_ctlGroupBox2;

    CColorText m_ctlText;
    CEditListBox m_ctlEditListBox;

public:
    CMainWindow ();

protected:
    afx_msg int OnCreate (LPCREATESTRUCT);
    afx_msg void OnRedButtonClicked ();
    afx_msg void OnGreenButtonClicked ();
    afx_msg void OnBlueButtonClicked ();

    DECLARE_MESSAGE_MAP ()
};
